<?php
require_once 'EbatNs_ComplexType.php';

/**
 * Defines the values that make up the seller's preferences. 
 *
 * @link http://developer.ebay.com/DevZone/XML/docs/Reference/eBay/types/SellerPaymentPreferencesType.html
 *
 */
class CategoryGroupType extends EbatNs_ComplexType
{
	/**
	 * @var bool
	 */
	protected $isDefault;
	/**
	 * @var string
	 */
	protected $Name;

	/**
	 * @return bool
	 */
	function getisDefault()
	{
		return $this->isDefault;
	}
	/**
	 * @param bool $value 
	 */
	function setisDefault($value)
	{
		$this->isDefault = $value;
	}
	/**
	 * @return string
	 */
	function getName()
	{
		return $this->Name;
	}
	/**
	 * @param string $value 
	 */
	function setName($value)
	{
		$this->Name = $value;
	}


	/**
	 * @return 
	 */
	function __construct()
	{
		parent::__construct('CategoryGroupType', 'urn:ebay:apis:eBLBaseComponents');
		if (!isset(self::$_elements[__CLASS__]))
				self::$_elements[__CLASS__] = array_merge(self::$_elements[get_parent_class()],
				array(
					'isDefault' =>
					array(
						'required' => false,
						'type' => 'bool',
						'nsURI' => 'http://www.w3.org/2001/XMLSchema',
						'array' => false,
						'cardinality' => '0..1'
					),
					'Name' =>
					array(
						'required' => false,
						'type' => 'string',
						'nsURI' => 'http://www.w3.org/2001/XMLSchema',
						'array' => false,
						'cardinality' => '0..1'
					)
				));
	}
}

