<?php
require_once(DIR_FS_INC.'xtc_get_products_image.inc.php');
if(!class_exists('xtcPrice')){
    require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
}
function utf8ize($d) {
    if (is_array($d)) {
        foreach ($d as $k => $v) {
            $d[$k] = utf8ize($v);
        }
    } else if (is_string ($d)) {
        switch(mb_detect_encoding($d)){
            case 'UTF-8':
                //$d = utf8_decode($d);
                break;
        }
        return $d;
    }
    return $d;
}
function utf8_encode_all($dat){ // -- It returns $dat encoded to UTF8 
  if (is_string($dat)) return yes_encode_string($dat); 
  if (!is_array($dat)) return $dat; 
  $ret = array(); 
  foreach($dat as $i=>$d) $ret[$i] = utf8_encode_all($d); 
  return $ret; 
} 
/* ....... */ 

function utf8_decode_all($dat) // -- It returns $dat decoded from UTF8 
{ 
  if (is_string($dat)) return yes_decode_string($dat); 
  if (!is_array($dat)) return $dat; 
  $ret = array(); 
  foreach($dat as $i=>$d) $ret[$i] = utf8_decode_all($d); 
  return $ret; 
} 
function get_item_recommendations($id){
	global $EBAYAPI,$messageStack;
	$ep = new ebay_product($id);
        if(empty($ep->getCategory()) or $ep->getCategory()==0){
            $messageStack->add_session('Basis f&uuml;r die Erstellung eines Variantensets ist die eBay Kategorie. Bitte hinterlegen Sie bei den Sammlerprodukten der einzelnen Varianten die entsprechende eBay Kategorie aus den eBay Favoriten.','error');
            xtc_redirect(xtc_href_link('ebayapi_cart.php?page_type=cart&menugroup=interfaces'));
        }
        $site_id = $ep->getSite();
		return $EBAYAPI->sdk_taxonomy_caller(ebayAPI::get_oauth2_usertoken($ep->getUser()),
			'GetItemAspectsForCategory',
			[
				'CATEGORY_TREE_ID'=>''.$EBAYAPI->get_site_id_from_name($site_id),
				'CATEGORY_ID'=>''.$ep->getCategory()
			]
		);
}
if(isset($_REQUEST['page_type']) and $_REQUEST['page_type'] == 'multi_variations'){
	$items = array();
	$ebay_variations_sets_id = (int)xtc_db_input($_REQUEST['evsID']);
        $epID = ebay_variations_set::get_ebay_products_id_from_ebay_variations_set_id($ebay_variations_sets_id);
        if($epID <= 0){
            die('Invalid Item, missing ebay_products reference');
        }
        $ep = new ebay_product( $epID );
	
	// VERWENDETE VARIATIONSPECIFICS
	$variationspecificssets = array();
	
	// DROPDOWN ZUR VARIANTEN AUSWAHL FUER BILDER HINTERLEGEN
	$ebay_variationspecificssets_values = array();
	$evss_query = yes_db_query(sprintf(
		"SELECT ebay_variationspecificssets_id,nvl_name,nvl_value FROM ebay_variationspecificssets WHERE ebay_variations_sets_id='%s' ORDER BY variations_pictures_base DESC",
		$ebay_variations_sets_id
	));
	foreach($evss_query as $evss){
	    $ebay_variationspecificssets_values[] = array(
		'id'=>$evss['ebay_variationspecificssets_id'],
		'text'=>$evss['nvl_name'],
	    );
	}
	$smarty->assign('input_ebay_variationspecificssets_values',
		xtc_draw_pull_down_menu('ebay_variationspecificssets_image_base',$ebay_variationspecificssets_values)
	);
	
	$evss_query = yes_db_query(sprintf(
		"SELECT ebay_variationspecificssets_id,nvl_name,nvl_value FROM ebay_variationspecificssets WHERE ebay_variations_sets_id='%s' ORDER BY variations_pictures_base DESC LIMIT 1",
		$ebay_variations_sets_id
	));
	if(yes_db_num_rows($evss_query)){
		$ebay_variationspecificssets = array();
		$evss = current($evss_query);
		$evss['values'] = array();
		$evss['_values'] = explode(';',$evss['nvl_value']);
		// PRUEFEN OB WIR DIESES MERKMAL GESPEICHERT HABEN
		$evvs_query = yes_db_query(sprintf(
			"SELECT ebay_variations_variationspecifics_id,ebay_variations_id,evvs.nvl_value,evvs.nvl_name FROM ebay_variations ev LEFT JOIN ebay_variations_variationspecifics evvs USING(ebay_variations_id) WHERE ev.ebay_variations_sets_id='%s' and evvs.nvl_name='%s'",
			$ebay_variations_sets_id,$evss['nvl_name'],$evss['nvl_value']
		));
		if(yes_db_num_rows($evvs_query)){
			foreach($evvs_query as $evvs){
				$evss['values'][] = array(
					'value'=>$evvs['nvl_value'],
					/*'pictures'=>$pics,*/
					'ebay_variations_variationspecifics_id'=>$evvs['ebay_variations_variationspecifics_id'],
					'ebay_variations_id'=>$evvs['ebay_variations_id']
				);
			}
		}
		unset($evss['_values']);
		$ebay_variationspecificssets[] = $evss;
		$smarty->assign('ebay_variationspecificssets',$ebay_variationspecificssets);
	}


	$pictures = array();
	$query = yes_db_query(sprintf(
		"SELECT * FROM ebay_variations WHERE ebay_variations_sets_id='%s' ORDER BY sort_order",
		$ebay_variations_sets_id
	));
	foreach($query as $record){
                
		$ep_query = xtc_db_query(sprintf(
			"SELECT ep.ebay_land FROM ebay_variations_sets evs LEFT JOIN ebay_products ep ON evs.ebay_products_id=ep.id WHERE ebay_variations_sets_id='%s'",
			$record['ebay_products_variations_id']
		));
		$ep_record = xtc_db_fetch_array($ep_query);
		$cID = yes_get_country_id_from_iso2($ep_record['ebay_land']);
		$lID = xtc_is_language_installed($cID);
		if(!$lID){
			$lID = '2';
		}
		$record['ebay_products_title'] = xtc_get_products_ebay_title($record['products_id'], $lID);
		if(empty($record['ebay_products_title'])){
		    $record['ebay_products_title'] = '<i>kein eBay Titel zur pID</i>';
		}
 		$vs_query = yes_db_query(sprintf(
			"SELECT * FROM ebay_variations_variationspecifics WHERE ebay_variations_id='%s'",
			$record['ebay_variations_id']
		));
		if(yes_db_num_rows($vs_query)){
			foreach($vs_query as $vs){
				$vs['nvl_name_decoded'] = urldecode($vs['nvl_name']);
				$record['variationspecifics'][] = $vs;
				if(isset($variationspecificssets[$vs['nvl_name']]) and !in_array($vs['nvl_value'], $variationspecificssets[$vs['nvl_name']] )){
					$variationspecificssets[ $vs['nvl_name'] ][ $vs['nvl_value'] ][] = array(
						'name'=>$pictures[ $vs['nvl_name'] ],
						'ebay_variations_variationspecifics_id'=>$vs['ebay_variations_variationspecifics_id'],
						'ebay_variations_id'=>$vs['ebay_variations_id'],
						'ebay_variations_pictures_sets_id'=>$vs['ebay_variations_pictures_sets_id']
					);
				}
			}
		}
		$items[] = $record;
	}
	$buttons = array(
	    array(
		'text'=>IMAGE_BACK,
		'link'=>'ebayapi_cart.php',
		'auth'=>true,
		'lbOn'=>false
	    ),
	    array(
		'text'=>IMAGE_DELETE,
		'link'=>'javascript:;',
		'auth'=>true,
		'lbOn'=>false,
		'id'=>'delete_variation_button'
	    ),
	    array(
		'text'=>HEADING_TITLE_EBAY_VARIATIONS_PICTURES,
		'link'=>'ebayapi_cart.php?action=ebay_variations_pictures&evsID='.$_REQUEST['evsID'],
		'auth'=>true,
		'lbOn'=>false
	    ),
	);

	$cart_query = yes_db_query(sprintf(
		"SELECT ep.id,ep.ebay_titel FROM ebay_products ep LEFT JOIN ebay_variations_sets evs ON ep.id=evs.ebay_products_id WHERE evs.ebay_variations_sets_id='%s'",
		$ebay_variations_sets_id
	));
	$cart = current($cart_query);
	$smarty->assign(array(
	    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
	    'ADDITIONAL_PAGE_TITLE'=>TEXT_CARTID.' '.$cart['id'],
	    'MV_UPDATE_SET_INTRO'=>MV_UPDATE_SET_INTRO,
	    /*'pictures'=>$pictures,*/
	    'items'=>$items,
	    'EBAY_PRODUCTS_TITLE'=> $cart['ebay_titel'],
	    'EBAY_PRODUCTS_ID'=> $cart['id'],
	    'TEXT_LINK_ADD_EBAY_PRODUCT_TO_VS'=>TEXT_LINK_ADD_EBAY_PRODUCT_TO_VS,
	    'TEXT_ADD_PRODUCT_TO_VARIATIONSET_SEARCH'=>TEXT_ADD_PRODUCT_TO_VARIATIONSET_SEARCH,
	    'variationspecificssets'=>$variationspecificssets,
	    'EVSID'=>$ebay_variations_sets_id,
	    'BASE_LINK'=>xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('evID'))),
	    'FORM_END'=>'</form>',
	    'SAVED'=>1,
	    'FORM'=>xtc_draw_form('update','ebayapi_cart.php',xtc_get_all_get_params(array('action')).'action=update_multi_variations','POST','onsubmit="return false;" id="MVUpdateForm"'),
	    'TEXT_BACK'=>IMAGE_BACK,
	    'TEXT_NO_VARIATIONSPECIFICSPICS'=>TEXT_NO_VARIATIONSPECIFICSPICS,
	    'LISTING_FORM_ACTION'=>xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('mv_action'))),
	    'JS_ERROR_ALERT_EBAY_VARIATIONS_CANNOT_DELETE_ALL_VARIATIONS'=>JS_ERROR_ALERT_EBAY_VARIATIONS_CANNOT_DELETE_ALL_VARIATIONS,
	    'TEXT_SORT_VARIATIONS_BY_PRODUCTS_ID'=>TEXT_SORT_VARIATIONS_BY_PRODUCTS_ID,
	    'TEXT_ADD_PRODUCT_TO_VARIATIONSET_PID_MODE'=>TEXT_ADD_PRODUCT_TO_VARIATIONSET_PID_MODE,
	    'TEXT_LINK_ADD_PRODUCT_TO_VS'=>TEXT_LINK_ADD_PRODUCT_TO_VS
	));
	$smarty->display('ebayapi_cart.multi_variations.tpl');
	exit;
}
if(isset($_REQUEST['mv_action'])){
	switch($_REQUEST['mv_action']){
		case 'get_input_field':
			$values = get_item_recommendations(xtc_db_input(current($_REQUEST['id'])));
			$recommendation_title = urldecode($_REQUEST['recommendation_title']);
			$string = sprintf('Fehler: Variantenwerte f&uuml;r "%s" konnten nicht ermittelt werden.',
				$recommendation_title
			);
			$json_values = array();
			foreach($values->aspects as $rec){
				if($rec->localizedAspectName != $recommendation_title){
						continue;
				}
				if(stristr(CHARSET,'utf-8')){
					$_values = array(array('id'=>'','text'=>'Auswahl'));
				}else{
					$_values = array(array('id'=>'','text'=>TEXT_SELECT));
				}
				foreach($rec->aspectValues as $vr){
					$_values[] = array('id'=>$vr->localizedValue,'text'=>$vr->localizedValue);
				}
				$recommendations_preselection[] = xtc_draw_input_field( urlencode($rec->localizedAspectName), $rec->localizedAspectName, 'class="ui-button ui-corner-all ui-state-default" style="padding:4px; width:200px;" id="recommendation"',false,'button');
				$rules = $rec->aspectConstraint;
				//$help = $rec->getHelpText();
				$json_values = array(
					'name'=>$rec->localizedAspectName,
					'values'=>$_values,
					'type'=>$rules->aspectMode,
					'help'=>''
				);
			}
			if(!stristr(CHARSET,'utf-8')){
				$json_values = utf8_encode_all($json_values);
			}
			die( json_encode($json_values) );
			break;
	}
}

$recommendations = array();
$recommendations_preselection = array();

$values = get_item_recommendations(xtc_db_input(current($_REQUEST['id'])));
foreach($values->aspects as $rec){
    $select_values = array(array('id'=>'','text'=>TEXT_SELECT));
    if(is_countable($rec->aspectValues) and sizeOf($rec->aspectValues)){
		foreach($rec->aspectValues as $vr){
			$select_values[] = array('id'=>urldecode($vr->localizedValue),'text'=>yes_encode_string($vr->localizedValue));
		}
    }
    $rules = $rec->aspectConstraint;
    $name = $rec->localizedAspectName;
    if(mb_detect_encoding($name) != 'ASCII'){
	//$name = utf8_encode($name);
    }
    $value = $name;
    if($rules->aspectRequired == 1){
        $value = '* '.$value;
        continue;
    }
    switch($rules->aspectMode){
		case 'FREE_TEXT':
			$recommendations_preselection[] = '<input type="button" name="'.urlencode($name).'" value="'.$value.'" class="ui-button ui-corner-all ui-state-default" style="padding:4px; width:200px;" id="recommendation" title="'.$title.'" />';
			$select_values = array_merge($select_values,array(array('id'=>'add','text'=>'Eigenes Merkmal')));
			$recommendations[ $name ] = xtc_draw_pull_down_menu(urlencode($name),$select_values);
			break;
		case 'SELECTION_ONLY':
			$recommendations_preselection[] = '<input type="button" name="'.urlencode($name).'" value="'.$value.'" class="ui-button ui-corner-all ui-state-default" style="padding:4px; width:200px;" id="recommendation" title="'.$title.'" />';
			$recommendations[ $name ] = xtc_draw_pull_down_menu($name,$select_values);
			break;
                default:
                    echo '<li>es fehlt '.$rules->aspectMode;
                    break;
    }
}
$smarty->assign(array(
	'MV_NEXT'=>MV_NEXT,
	'MV_TITLE_SOURCE_CARTITEM'=>MV_TITLE_SOURCE_CARTITEM,
	'RECOMMENDATION_URL'=>'ebayapi_cart.php?action=multi_variations&mv_action=get_input_field&id[]='.implode('&id[]=',$_REQUEST['id']),
	'js_new_value_prompt'=>JS_MV_NEW_VALUE_PROMPT
));
$smarty->assign('recommendations',$recommendations);
$smarty->assign('recommendations_preselection',$recommendations_preselection);
$smarty->assign(array(
	    'TEXT_LINK_ADD_EBAY_PRODUCT_TO_VS'=>TEXT_LINK_ADD_EBAY_PRODUCT_TO_VS,
	'FORM_END'=>'</form>',
	'FORM'=>xtc_draw_form('save','ebayapi_cart.php',xtc_get_all_get_params(array('action')).'action=save_multi_variations','POST','id="MVform"'),
	'INTRO_MULTI_VARIATIONS_EDIT'=>INTRO_MULTI_VARIATIONS_EDIT,
	'JS_ERROR_MULTI_VARIATIONS_NO_SRC_EPID'=>JS_ERROR_MULTI_VARIATIONS_NO_SRC_EPID,
    'TEXT_EBAY_PRODUCT_GROUPS'=>TEXT_EBAY_PRODUCT_GROUPS
));
$smarty->assign(array(
    'FORM_END'=>'</form>'
));
$EBAYAPI = new ebayAPI;
$stuecklisten_error = 0;
foreach($_REQUEST['id'] as $id){
	$ep = new ebay_product(xtc_db_input($id));
	$cID = yes_get_country_id_from_iso2($ep->getCountry());
	$lID = xtc_is_language_installed($cID);
	if(!$lID){
		$lID = '2';
	}
        if(!main::isDev() && product::is_stuecklistenartikel($ep->getProductsId())){
            $stuecklisten_error = 1;
            continue;
        }
	
	$slave_title = xtc_get_products_slave_title($ep->getProductsId(),$lID);
	$products_ebay_title = xtc_get_products_ebay_title($ep->getProductsId(), $lID);
	$products_title = xtc_get_products_name($ep->getProductsId(),$lID);
	$pic = $ep->getPicture();
	$rel = 'images/product_images/thumbnail_images/';
	$pic_file_path = DIR_FS_CATALOG.$rel;
	if(!empty($pic) && is_file($pic_file_path.$pic)){
	    $pic = '../'.$rel.$pic;
	}else{
	    $pic = 'images/basicons/hanging15.png';
	}
	$items[] = array(
		'id'=>$id,
		'products_id'=>$ep->getProductsId(),
	    'slave_title'=>$slave_title,
	    'products_ebay_title'=>$products_ebay_title,
	    'products_title'=>$products_title,
		'text'=>$ep->getTitle(),
		'qty'=>$ep->getQuantity(),
		'price'=>number_format($ep->getAuctionprice(),2,'.',''),
		'sku'=>$ep->getProductsId(),
		'isbn'=>$ep->getIsbn(),
		'ean'=>$ep->getEan(),
	    'image'=>$pic,
            'ProductReferenceID'=>$ep->getProductReferenceID(),
	);
}

if(isset($_REQUEST['pIDArray']) and is_array($_REQUEST['pIDArray'])){
    foreach($_REQUEST['pIDArray'] as $pID){
        if(!main::isDev() && product::is_stuecklistenartikel($pID)){
            $stuecklisten_error = 1;
            continue;
        }
	$slave_title = xtc_get_products_slave_title($pID,$lID);
	$products_ebay_title = xtc_get_products_ebay_title($pID, $lID);
	$products_title = xtc_get_products_name($pID,$lID);
	// BOF EAN/ISBN - TICKET 1645
	$ean = '';
	$isbn = '';
	if(defined('EBAY_USE_PRODUCTS_EAN_FROM_PRODUCT_AS_EAN') and EBAY_USE_PRODUCTS_EAN_FROM_PRODUCT_AS_EAN == 'True'){
	    $ean = yes_get_products_ean($pID);
	}
	if(defined('EBAY_USE_PRODUCTS_EAN_FROM_PRODUCT_AS_ISBN') and EBAY_USE_PRODUCTS_EAN_FROM_PRODUCT_AS_ISBN == 'True'){
	    $isbn = yes_get_products_ean($pID);
	}
	// EOF EAN/ISBN - TICKET 1645
	$xtPrice = new xtcPrice($currency = DEFAULT_CURRENCY,EBAY_PRODUCTS_PRICE_CUSTOMER_STATUS);
        $tax_id = yes_eu_oss_get_products_tax_class_id($pID, STORE_COUNTRY);
	//$tax_id=xtc_get_tax_class_id($pID);
	$final_price=$xtPrice->xtcGetPrice($pID,
		$format=false,
		1,
		$tax_id,0
	);
	
	$pic = xtc_get_products_image($pID);
	$rel = 'images/product_images/thumbnail_images/';
	$pic_file_path = DIR_FS_CATALOG.$rel;
	if(!empty($pic) && is_file($pic_file_path.$pic)){
	    $pic = '../'.$rel.$pic;
	}else{
	    $pic = 'images/basicons/hanging15.png';
	}
        $ProductReferenceID = ''; // falls mal die eBay ePid im Artikel
                                  // implementiert wird
	$items[] = array(
		'products_id'=>$pID,
		'slave_title'=>$slave_title,
		'products_ebay_title'=>$products_ebay_title,
		'products_title'=>$products_title,
		'text'=>$products_ebay_title,
		'qty'=>1,
		'price'=>number_format($final_price,2,'.',''),
		'sku'=>$pID,
		'isbn'=>$isbn,
		'ean'=>$ean,
                'ProductReferenceID'=>$ProductReferenceID,
	);
    }
}


$smarty->assign(array(
    'count_items'=>sizeOf($items),
    'TEXT_MV_NO_CART_ITEM'=>TEXT_MV_NO_CART_ITEM,
    'TEXT_MV_SLAVE_TITLE'=>TEXT_MV_SLAVE_TITLE,
    'TEXT_MV_PRODUCTS_TITLE'=>TEXT_MV_PRODUCTS_TITLE,
    'TEXT_MV_PRODUCTS_EBAY_TITLE'=>TEXT_MV_PRODUCTS_EBAY_TITLE,
    'TEXT_STUECKLISTENARTIKEL_NOT_ALLOWED_AS_VARIATION'=>TEXT_STUECKLISTENARTIKEL_NOT_ALLOWED_AS_VARIATION,
    'STUECKLISTEN_ERROR'=>$stuecklisten_error
));
$smarty->assign('items',$items);
$smarty->assign('ADD_VARIATIONSSPECIFICSFORM',xtc_draw_form('add_vs','ebayapi_cart.php','action=multi_variations','post','id="add_vs"'));
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('ebayapi_cart.multi_variations.tpl');
