<?php
namespace YES4Trade\Model;
class customers extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'customers';
    const TABLE_INDEX = 'customers_id';

    private static $propertyTypes = [
        'customers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_id'
        ],
        'customers_cid' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_cid'
        ],
        'customers_vat_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_vat_id'
        ],
        'customers_vat_id_status' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_vat_id_status'
        ],
        'customers_warning' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_warning'
        ],
        'customers_status' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status'
        ],
        'customers_gender' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_gender'
        ],
        'customers_firstname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_firstname'
        ],
        'customers_lastname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_lastname'
        ],
        'customers_dob' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_dob'
        ],
        'customers_email_address' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_email_address'
        ],
        'customers_default_address_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_default_address_id'
        ],
        'customers_telephone' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_telephone'
        ],
        'customers_fax' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_fax'
        ],
        'customers_password' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_password'
        ],
        'customers_newsletter' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_newsletter'
        ],
        'customers_newsletter_mode' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_newsletter_mode'
        ],
        'member_flag' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'member_flag'
        ],
        'delete_user' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'delete_user'
        ],
        'account_type' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'account_type'
        ],
        'password_request_key' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'password_request_key'
        ],
        'customers_ebay_userid' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_ebay_userid'
        ],
        'kto_nummer' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'kto_nummer'
        ],
        'kto_blz' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'kto_blz'
        ],
        'kto_bank' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'kto_bank'
        ],
        'kto_inhaber' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'kto_inhaber'
        ],
        'kto_iban' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'kto_iban'
        ],
        'kto_swift' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'kto_swift'
        ],
        'block_warnings' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'block_warnings'
        ],
        'block_warnings_span' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'block_warnings_span'
        ],
        'block_warnings_dayspan' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'block_warnings_dayspan'
        ],
        'block_warnings_date' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'block_warnings_date'
        ],
        'mobile' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'mobile'
        ],
        'subject_from_textitem' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'subject_from_textitem'
        ],
        'customers_uosid' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_uosid'
        ],
        'branches_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'branches_id'
        ],
        'branches_id2' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'branches_id2'
        ],
        'customers_date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_date_added'
        ],
        'customers_last_modified' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_last_modified'
        ],
        'refferers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'refferers_id'
        ],
        'orders_default_search_type' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'orders_default_search_type'
        ],
        'use_own_mailaddress' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'use_own_mailaddress'
        ],
        'hpdd_kto' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpdd_kto'
        ],
        'hpdd_blz' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpdd_blz'
        ],
        'hpdd_own' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpdd_own'
        ],
        'hpgp_kto' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpgp_kto'
        ],
        'hpgp_blz' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpgp_blz'
        ],
        'hpgp_own' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpgp_own'
        ],
        'easylog_tn_national' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'easylog_tn_national'
        ],
        'easylog_tn_international' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'easylog_tn_international'
        ],
        'account_value' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'account_value'
        ],
        'hpsu_kto' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpsu_kto'
        ],
        'hpsu_blz' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpsu_blz'
        ],
        'hpsu_own' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpsu_own'
        ],
        'account_value_alert_notified' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'account_value_alert_notified'
        ],
        'email_signature' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'email_signature'
        ],
        'hpsu_iban' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpsu_iban'
        ],
        'hpsu_bic' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'hpsu_bic'
        ],
        'wechselgeld_calculator' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'wechselgeld_calculator'
        ],
        'distributor_orders_edit_products_search_default' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'distributor_orders_edit_products_search_default'
        ],
        'theme'=>[
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'theme'
        ]
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        yes_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, $data,'update',
            [$index=>$this->$index]
        );
    }


    public static function delete(int $index) {
        yes_query(sprintf(
            "DELETE FROM %s WHERE %s=:index_field",
                self::TABLE_NAME,self::TABLE_INDEX
            ),['index_field'=>$index]
        );
        \YES4Trade\Model\customers_info::delete($index);
    }


    public static function get_by_customers_id(int $customers_id, array $select_fields = []) {
        $select_str = (!sizeOf($select_fields))?'*':implode(',',$select_fields);
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE %s=:index_field",
                $select_str,self::TABLE_NAME, self::TABLE_INDEX
            ),['index_field'=>$customers_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        if(isset($record['account_value'])){
            $record['account_value'] = (float)$record['account_value'];
        }
        foreach(self::$propertyTypes as $p){
            if(!isset($record[$p['elementName']])){
                continue;
            }
            switch($p['type']){
                case 'integer':
                    $record[$p['elementName']] = intval($record[$p['elementName']]);
                    break;
            }
        }
        return new self($record);
    }
    
    /**
     * Prueft ob es einen customers Eintrag mit 
     * customers_id=%d AND customers_email_address='%s' 
     * gibt und liefert true or false
     * 
     * @param int $customers_id
     * @param string $email_address
     * @return bool
     */
    public static function customers_id_and_email_address_allocation_exists(int $customers_id, string $email_address) {
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE %s=:index_field AND customers_email_address=:email",
                self::TABLE_INDEX,self::TABLE_NAME, self::TABLE_INDEX, 
            ),['index_field'=>$customers_id,'email'=>$email_address]
        );
        if(!sizeOf($query)){
            return false;
        }
        return true;
    }

    /**
     * Zaehlt die Bestellungen des Kunden. Das Array status_filter grenzt ein
     * welche Statii gezaehlt werden sollen. 
     * zb [ORDERS_STATUS_OFFEN, ORDERS_STATUS_BEZAHLT]
     * 
     * @param int $customers_id
     * @param array $status_filter
     * @return int
     */
    public static function count_orders( int $customers_id, array $status_filter = [] ){
        $status_filter_sql = '';
        if(sizeOf($status_filter)){
            $status_filter_sql = sprintf(
                " AND orders_status IN(%s)",
                implode(', ',$status_filter)
            );
        }
        $record = yes_query(sprintf(
            "SELECT COUNT(orders_id) AS anz FROM %s WHERE customers_id=:customers_id %s",
                TABLE_ORDERS, $status_filter_sql
            ),['customers_id'=>$customers_id],
            true
        );
        return $record['anz'];
    }
    
    public static function get_orders_sum(int $customers_id, array $status_filter = []){
        $status_filter_sql = '';
        if(sizeOf($status_filter)){
            $status_filter_sql = sprintf(
                " AND o.orders_status IN(%s)",
                implode(', ',$status_filter)
            );
        }
        $record = yes_query(sprintf(
            "SELECT SUM(ot.value) as totalsum FROM %s o,%s ot WHERE ot.orders_id=o.orders_id and ot.class='ot_total' %s and o.customers_id=:customers_id",
                TABLE_ORDERS,TABLE_ORDERS_TOTAL,
                $status_filter_sql,
            ),['customers_id'=>$customers_id],
            true
        );
        return $record['totalsum'];
    }

    /**
     * Prueft ob die uebergebene Emailadresse bereits in der DB existiert
     * 
     * Dabei wird im SQL mit "and customers_id <> id" der uebergebene customer 
     * ausgeschlossen Diese Funktion wird zb beim admin Customer Update verwendet, 
     * wo bei einem Submit die aktuell uebergebene Email geprueft wird. Beim 
     * Kunden der gerade bearbeitet wird, darf die Email vorhanden sein, bei 
     * allen anderen nicht. Nur wenn sicher gestellt ist, dass die Email kein 
     * anderer customer verwendet, darf eine Email geaendert werden.
     * Wird keine customers_id verwendet, wird generell geprueft ob ein Eintrag
     * zu dieser customers_email_address existiert, ohne Beruecksichtigung
     * der customers_id
     * 
     * @param string $email
     * @param int $customers_id
     * @return boolean
     */
    public static function email_exists(string $email,int $customers_id = 0){
        $parameters = [
            'email'=>$email
        ];
        if($customers_id > 0){
            $parameters['customers_id'] = $customers_id;
            $customer_sql = " and customers_id <> :customers_id";
        }else{
            $customer_sql = '';
        }
        $query = yes_query(sprintf(
            "select customers_email_address from %s where customers_email_address=:email %s",
            self::TABLE_NAME, $customer_sql
        ),$parameters);
        return (sizeOf($query)>0)?true:false;
    }
    
    public static function exists( int $customers_id ){
        if($customers_id < 1){
            return false;
        }
        $query = yes_query(sprintf(
            "SELECT customers_id FROM %s WHERE %s=:customers_id",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['customers_id'=>$customers_id]
        );
        return (sizeOf($query) > 0) ? true : false;
    }
    
    public static function get_customers_email_duplicates( int $exclude_customers_id, string $email_address ){
        $array = [];
        $query = yes_query(sprintf(
            "SELECT customers_id FROM %s WHERE customers_email_address=:email AND customers_id !=:customers_id",
                self::TABLE_NAME
            ),['email'=>$email_address, 'customers_id'=>$exclude_customers_id]
        );
        foreach($query as $record){
            $array[] = $record['customers_id'];
        }
        return $array;
    }
    
    /**
     * Prueft in der Tabelle customers ob es Eintraege mit der gleichen
     * Email Adresse gibt. Das ist eine Bugfix Funktion die helfen soll Fehler 
     * zu beseitigen. 
     * Zurueckgegeben wird ein Array der Emailadressen die mehrfach vorhanden
     * sind.
     * Bisheriger Einsatz nur in der customers.php
     * 
     * @return array
     */
    public static function get_email_duplicates(){
        $duplicates = [];
        $q = xtc_db_query(sprintf(
            "SELECT customers_email_address FROM %s WHERE customers_email_address!='' GROUP BY customers_email_address HAVING COUNT(*) >= 2",
            self::TABLE_NAME
        ));
        while($record = xtc_db_fetch_array($q)){
            $duplicates[] = $record['customers_email_address'];
        }
        return $duplicates;
    }
    
    public static function get_customers_id_array_by_email_address(string $email_address){
        $items = [];
        $q = yes_query(sprintf(
            "SELECT %s FROM %s WHERE customers_email_address=:email",
                self::TABLE_INDEX, self::TABLE_NAME
            ),['email'=>$email_address]
        );
        foreach($q as $r){
            $items = $r[self::TABLE_INDEX];
        }
        return $items;
    }
    
    public static function get_by_email_address(string $email_address, array $select_fields = []){
        $parameters = [
            'email'=>$email_address,
        ];
        $q = yes_query(sprintf(
            "SELECT %s FROM %s WHERE customers_email_address=:email",
            self::TABLE_INDEX, self::TABLE_NAME
        ),$parameters);
        if(!sizeOf($q)){
            return null;
        }
        $res = current($q);
        return self::get_by_customers_id(intval($res[self::TABLE_INDEX]),$select_fields);
    }
    
    public static function get_by_customers_id_and_password_request_key(int $customers_id, string $password_request_key){
        if($customers_id < 1 or empty($password_request_key)){
            return null;
        }
        $parameters = [
            'customers_id'=>$customers_id,
            'password_request_key'=>$password_request_key
        ];
        $q = yes_query(sprintf(
            "SELECT %s FROM %s WHERE %s=:customers_id and password_request_key=:password_request_key",
            self::TABLE_INDEX, self::TABLE_NAME,self::TABLE_INDEX,
        ),$parameters);
        if(!sizeOf($q)){
            return null;
        }
        $res = current($q);
        return self::get_by_customers_id($res[self::TABLE_INDEX]);
    }
}
