<?php

namespace YES4Trade\Model;

class ebay_auctions_productsafety extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_auctions_productsafety';
    const TABLE_INDEX = 'ebay_auctions_productsafety_id';

    private static $propertyTypes = [
        'ebay_auctions_productsafety_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_auctions_productsafety_id'
        ],
        'ebay_auctions_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_auctions_id'
        ],
        'pictograms' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'pictograms'
        ],
        'statements' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'statements'
        ],
    ];


public function __construct(array $values = []) {
    list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
    parent::__construct($parentValues);
    if (!array_key_exists(__CLASS__, self::$properties)) {
        self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
    }
    if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
        self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
    }
    $this->setValues(__CLASS__, $childValues);
    }

    private static function convertInt( array $data ){
       foreach(get_class_vars(__CLASS__) as $pk=>$pv){
           if($pv['type'] == 'integer'){
               $data[$pk] = (int)$data[$pk];
           }
       }
       return $data;
    }


    public function create() {
        $data = $this->toArray();
        $data = self::convertInt($data);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        $data = self::convertInt($data);
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',$index."='".$this->$index."'");
    }


    public static function delete(int $index) {
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }


    public static function get_by_ebay_auctions_productsafety_id(int $ebay_auctions_productsafety_id) {
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE %s='%d'",
                self::TABLE_NAME, self::TABLE_INDEX, $ebay_auctions_productsafety_id
        ));
        if(!xtc_db_num_rows($query)){
            return null;
        }
        $record = xtc_db_fetch_array($query);
        $record = self::convertInt($record);
        return new self($record);
    }
    
    public static function get_by_ebay_auctions_id(int $ebay_auctions_id) {
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE ebay_auctions_id='%d'",
                self::TABLE_NAME, $ebay_auctions_id
        ));
        if(!xtc_db_num_rows($query)){
            return null;
        }
        $record = xtc_db_fetch_array($query);
        $record = self::convertInt($record);
        return new self($record);
    }

}
