<?php
namespace YES4Trade\Model;

class ebay_products_videos extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_products_videos';
    const TABLE_INDEX = 'ebay_products_videos_id';

    private static $propertyTypes = [
        'ebay_products_videos_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_products_videos_id'
        ],
        'ebay_products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_products_id'
        ],
        'video_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'video_id'
        ],
        'video_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'video_title'
        ],
    ];


public function __construct(array $values = []) {
    list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
    parent::__construct($parentValues);
    if (!array_key_exists(__CLASS__, self::$properties)) {
        self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
    }
    if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
        self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
    }
    $this->setValues(__CLASS__, $childValues);
    }

    private static function convertInt( array $data ){
       foreach(get_class_vars(__CLASS__) as $pk=>$pv){
           if($pv['type'] == 'integer'){
               $data[$pk] = (int)$data[$pk];
           }
       }
       return $data;
    }


    public function create() {
        $data = $this->toArray();
        $data = self::convertInt($data);
        $data['ebay_products_id'] = (int)$data['ebay_products_id'];
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        $data = self::convertInt($data);
        unset($data[self::TABLE_INDEX]);
        $data['ebay_products_id'] = (int)$data['ebay_products_id'];
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',$index."='".$this->$index."'");
    }


    public static function delete(int $index) {
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }


    public static function get_by_ebay_products_videos_id(int $ebay_products_videos_id) {
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE %s='%d'",
                self::TABLE_NAME, self::TABLE_INDEX, $ebay_products_videos_id
        ));
        if(!xtc_db_num_rows($query)){
            return null;
        }
        $record = xtc_db_fetch_array($query);
        $record = self::convertInt($record);
        $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
        $record['ebay_products_id'] = (int)$record['ebay_products_id'];
        return new self($record);
    }

    public static function get_by_ebay_products_id(int $ebay_products_id) {
        $items = [];
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE ebay_products_id='%d'",
                self::TABLE_NAME, $ebay_products_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $record = self::convertInt($record);
            $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
            $record['ebay_products_id'] = (int)$record['ebay_products_id'];
            $items[] = new self($record);
        }
        return $items;
    }
    public static function get_by_video_id_and_ebay_products_id( string $video_id, int $ebay_products_id ){
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE ebay_products_id='%d' AND video_id='%s'",
                self::TABLE_NAME, $ebay_products_id,$video_id
        ));
        if(!xtc_db_num_rows($query)){
            return null;
        }
        $record = xtc_db_fetch_array($query);
        $record = self::convertInt($record);
        $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
        $record['ebay_products_id'] = (int)$record['ebay_products_id'];
        return new self($record);
    }
}
