<?php

namespace YES4Trade\Model;

class ebay_variations_variationspecifics extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_variations_variationspecifics';
    const TABLE_INDEX = 'ebay_variations_variationspecifics_id';

    private static $propertyTypes = [
        'ebay_variations_variationspecifics_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_variations_variationspecifics_id'
        ],
        'ebay_variations_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_variations_id'
        ],
        'nvl_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'nvl_name'
        ],
        'nvl_value' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'nvl_value'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        $data['ebay_variations_variationspecifics_id'] = (int)$data['ebay_variations_variationspecifics_id'];
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',$index."='".$this->$index."'");
    }


    public static function delete(int $index) {
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }


    public static function get_by_ebay_variations_variationspecifics_id(int $ebay_variations_variationspecifics_id) {
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE %s='%d'",
                self::TABLE_NAME, self::TABLE_INDEX, $ebay_variations_variationspecifics_id
        ));
        if(!xtc_db_num_rows($query)){
            return null;
        }
        $record = xtc_db_fetch_array($query);
        foreach(get_class_vars(__CLASS__) as $pk=>$pv){
           if($pv['type'] == 'integer'){
               $record[$pk] = (int)$record[$pk];
           }
        }
        return new self($record);
    }
    
    public static function get_by_ebay_variations_id(int $ebay_variations_id) {
        $items = [];
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE ebay_variations_id='%d'",
                self::TABLE_NAME, $ebay_variations_id
        ));
        while($record = xtc_db_fetch_array($query)){
            foreach(get_class_vars(__CLASS__) as $pk=>$pv){
               if($pv['type'] == 'integer'){
                   $record[$pk] = (int)$record[$pk];
               }
            }
            $items[] = new self($record);
        }
        return $items;
    }

}
