<?php
namespace YES4Trade\Model;

class group_handler extends \YES4Trade\Model\BaseType{
    var $groups = array();
    var $language_id;
    const CACHE_KEY = 'groups_%s';
    
    public function __construct( int $language_id ){
        global $InstanceCache;
        $this->language_id = $language_id;
        $CachedString = $InstanceCache->getItem(sprintf(self::CACHE_KEY, $language_id));
        if (!$CachedString->isHit()) {
            $groups = self::get_groupsData( $language_id );
            $array = [];
            $groups_array = $groups;
            foreach($groups_array as $g){
                $array_chars = [];
                foreach($g->characteristics as $gc){
                    $sets = [];
                    foreach($gc->sets as $gcset){
                        $add_set = $gcset->toArray();
                        $add_set['description'] = [
                        	'title'=>$gcset->description->title,
                        	'products_characteristic_set_id'=>$gcset->description->products_characteristic_set_id,
                        	'language_id'=>$gcset->description->language_id,
                        	'products_characteristic_set_description_id'=>$gcset->description->products_characteristic_set_description_id
                        ];
//                        $add_set['description'] = $gcset->description->toArray();
                        $sets[] = $add_set;
                    }
                    
                    $array_char = $gc->toArray();
                    // wenn es keine desc gibt, ist gc_description ein leeres
                    // array
                    $gcdesc = (!is_countable($gc->description))? $gc->description->toArray() : [];
                    
                    $array_char['description'] = $gcdesc;
                    $array_char['sets'] = $sets;
                    $array_chars[] = $array_char;
                }
                $add = $g->toArray();
                $add['characteristics'] = $array_chars; 
                $array[] = $add;
            }
            $CachedString->set($array)->expiresAfter(0)->addTag('shop');//groups_*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $array = $CachedString->get();
        }
        $this->groups = $array;
    }
    
    public static function get_groupsData( int $language_id = -1 ){
        $groups = [];
        $query = xtc_db_query(
            "SELECT * FROM `groups` ORDER BY groups_title"
        );
        $recs = [];
        while($record = xtc_db_fetch_array($query)){
            $recs[] = $record;
        }
        foreach($recs as $record){
            foreach($record as $k=>$val){
                switch($k){
                    case 'groups_title':
                    case 'groups_created':
                    case 'groups_last_changed':
                        break;
                    default:
                        $record[$k] = (int)$val;
                        break;
                }
            }
            $g = new \YES4Trade\Model\groups($record);
            $g->characteristics = $g->get_characteristicsData( $language_id );
            $groups[] = $g;
        }
        return $groups;
    }

    
	function setGroups($value){
		$this->groups[] = $value;
	}

	function getGroups($id = -1){
		if($id == -1){
			return $this->groups;
		}else{
			return $this->groups[$id];
		}
	}

	function getGroupsById($id){
		for($i=0;$i<sizeOf($this->getGroups());$i++){
			$g = $this->groups[$i];
			if($g->getId() == $id)
				return $this->groups[$i];
		}
	}

	function getGroupsData($language_id=Null){
            $records = array();
            $groups_query = xtc_db_query("SELECT groups_id,groups_title FROM `groups` ORDER BY groups_title");
            while($groups = xtc_db_fetch_array($groups_query)){
                $records[] = $groups;
            }
            foreach($records as $groups){
		$g = new group($groups['groups_id'],$language_id);
		$this->setGroups($g);
            }
	}

	function getGroupsFormArray(){
		$array = array();
		for($i=0;$i<sizeOf($this->getGroups());$i++){
			$g = $this->getGroups($i);
			$array[] = array('id'=>$g->getId(),'text'=>$g->getTitle());
		}
		return $array;
	}
	
	function getGroupsCharacteristicFormArray($groups_id){
		$array = array();
		$g = $this->getGroupsById($groups_id);
		for($i=0;$i<sizeOf($g->getCharacteristics());$i++){
			$gc = $g->getCharacteristics($i);
			$array[] = array('id'=>$gc->getId(),'text'=>$gc->getTitle());
		}
		return $array;
	}
	
	function getGroupsCharacteristicSetFormArray($groups_id,$groups_characteristic_id){
		$array = array();
		$g = $this->getGroupsById($groups_id);
		$gc = $g->getCharacteristicsById($groups_characteristic_id);
		if($gc->getNoSets() == 0){
			for($i=0;$i<sizeOf($gc->getSets());$i++){
				$gcs = $gc->getSets($i);
				$array[] = array('id'=>$gcs->getId(),'text'=>$gcs->getTitle());
			}
		}else{
			$array[] = array('id'=>'','text'=>'Dieses Produktmerkmal enth&auml;lt Freitext-Werte.');
		}
		return $array;
	}

	function getGroupsCharacteristicDescription($groups_id,$groups_characteristic_id){
		$g = $this->getGroupsById($groups_id);
		$gc = $g->getCharacteristicsById($groups_characteristic_id);
		return $gc->getDescription();
	}
	
	function getCharacteristicTitleFromConfigValue($value){
		$return_string = '';
		$values = split('\|',$value);
		$g = $this->getGroupsById($values[0]);
		$return_string .= $g->getTitle();
		$gc = $g->getCharacteristicsById($values[1]);
		$return_string .= ' / '.$gc->getTitle();
		return $return_string;
	}

	function getProductSetValue($products_id,$groups_id,$characteristic_id,$language_id,$multiple_separator = ', '){
		$g = $this->getGroupsById($groups_id);
		$gc = $g->getCharacteristicsById($characteristic_id);
                $sess_lang_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
		if($gc->getNoSets() == 0){
			$set_id_query_raw = "SELECT ptc.products_characteristic_set_id FROM products_to_characteristics ptc LEFT JOIN products_characteristic_set pcs USING(products_characteristic_set_id) WHERE ptc.products_id=:products_id and pcs.products_characteristic_id=:pc_id ORDER BY sort_order";
			$set_id = yes_query($set_id_query_raw,[
                            'products_id'=>$products_id,
                            'pc_id'=>$characteristic_id
                            ],
                            true
                        );
			$gcs = $gc->getSetsById($set_id['products_characteristic_set_id']);
			if(is_object($gcs)){
				$gcsD = $gcs->getDescription($sess_lang_id);
				if(is_object($gcsD)){
				    return $gcsD->getTitle();
				}else{
				    return '';
				}
			}else{
				return '';
			}
		}else{
			$_values = array();
			$text_value_query = yes_query(
                            "SELECT content FROM products_characteristic_text_values WHERE products_id=:products_id AND products_characteristic_id=:c_id AND language_id=:language_id",
                            [
                                'products_id'=>$products_id,
                                'c_id'=>$characteristic_id,
                                'language_id'=>$language_id
                            ]
                        );
			foreach($text_value_query as $text_value){
                            $_values[] = xtc_db_prepare_input($text_value['content']);
			}
			if(sizeOf($_values)){
                            return implode($multiple_separator,$_values);
                        }
                        return '';
		}
	}

	function getCharacteristicsByTitle($groups_id,$title,$language_id,$use_cache = false){
		$query_raw = "SELECT pc.products_characteristic_id FROM products_characteristic pc LEFT JOIN products_characteristic_description pcd USING(products_characteristic_id) WHERE pc.groups_id=:groups_id AND pcd.title=:title AND pcd.language_id=:language_id";
		if($use_cache){
			$query = yes_query($query_raw,[
                            'groups_id'=>$groups_id,
                            'title'=>$title,
                            'language_id'=>$language_id
                        ]);
			if(sizeOf($query)){
                            $row = current($query);
                            return (int) $row['products_characteristic_id'];
			}
		}else{
			$row = yes_query($query_raw,[
                            'groups_id'=>$groups_id,
                            'title'=>$title,
                            'language_id'=>$language_id
                            ],true
                        );
			return (int) $row['products_characteristic_id'];
		}
	}
        
        public static function get_groups_with_titles(){
            $records = array();
            $groups_query = xtc_db_query("SELECT groups_id,groups_title FROM `groups` ORDER BY groups_title");
            while($groups = xtc_db_fetch_array($groups_query)){
                $records[] = $groups;
            }
            return $records;
        }
        
        public static function get_groups_products_set_allocations( int $products_characteristic_id ){
            $records = array();
            $query = yes_query(
                    "SELECT pcd.title as characteristic_title, pcs.products_characteristic_set_id,pcsd.title, ptc.products_id, pcd.language_id FROM products_characteristic_set pcs LEFT JOIN products_characteristic_description pcd USING(products_characteristic_id) LEFT JOIN products_characteristic_set_description pcsd USING(products_characteristic_set_id) LEFT JOIN products_to_characteristics ptc USING(products_characteristic_set_id) WHERE pcs.products_characteristic_id=:pc_id AND ptc.products_id IS NOT NULL AND pcsd.language_id=pcd.language_id ORDER BY pcs.sort_order",
                    ['pc_id'=>$products_characteristic_id]
            );
            foreach($query as $record){
                $records[] = $record;
            }
            return $records;
        }
        
        public static function get_groups_products_text_allocations( int $products_characteristic_id ){
            $records = array();
            $query = yes_query(
                    "SELECT pctv.products_id,pcd.title as characteristic_title, pctv.content as title,pctv.language_id "
                    . "FROM products_characteristic_text_values pctv "
                    . "LEFT JOIN products_characteristic_description pcd USING(products_characteristic_id,language_id) "
                    . "WHERE pctv.products_characteristic_id=:pc_id ORDER BY pctv.multiple_sort",
                    ['pc_id'=>$products_characteristic_id]
            );
            foreach($query as $record){
                $records[] = $record;
            }
            return $records;
        }
        
    public static function clear_cache(){
        global $InstanceCache;
        $languages = xtc_get_languages();
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            foreach($languages as $lang){
                if($cd->getKey() == sprintf(self::CACHE_KEY,$lang['id'])){
                    $InstanceCache->deleteItem($cd->getKey()); // groups_*
                }
            }
        }
    }
    
    public function get_allocated_product_group_characteristic_values( int $products_id ){
        $products_characteristics_data = [];
        $allocations = \YES4Trade\Model\groups_products::get_by_products_id($products_id);
        foreach($allocations as $alloc){
            foreach($this->groups as $g){
                if($g['groups_id'] != $alloc->groups_id){
                    continue;
                }
                foreach($g['characteristics'] as $gc){
                    if($gc['visible'] < 1){
                        continue;
                    }
                    $value = null;
                    switch($gc['no_sets']){
                        case 0:
                            $set_allocs = \YES4Trade\Model\groups_products_characteristics::get_by_products_id($products_id);
                            foreach($set_allocs as $sa){
                                foreach($gc['sets'] as $gset){
                                    if($gset['products_characteristic_set_id'] != $sa->products_characteristic_set_id){
                                        continue;
                                    }
                                    $value = $gset['description']['title'];
                                }
                            }
                            break;
                        case 1:
                            $gct = \YES4Trade\Model\groups_characteristic_text_values::get_by_characteristic_id_and_products_id($gc['products_characteristic_id'],$products_id, $this->language_id);
                            $value = ($gct !== false) ? $gct->content : '';
                            break;
                    }
                    if($value !== null){
                        $products_characteristics_data[] = array(
                            'title'=>$gc['description']['title'],
                            'value'=>$value,
                            'no_sets'=>$gc['no_sets'],
                            'multiple'=>$gc['multiple'],
                            'visible'=>$gc['visible'],
                            'ebay_visible'=>$gc['ebay_visible'],
                            'description'=>$gc['description']['description'],
                            'group_id'=>$alloc->groups_id,
                            'sort_order'=>$gc['sort_order'],
                        );
                    }
                }
            }
        }
        if(sizeOf($products_characteristics_data)){
            usort($products_characteristics_data, function($a, $b) {
                return $a['sort_order'] <=> $b['sort_order'];
            });
        }
        return $products_characteristics_data;
    }
    
    
    
}
