<?php
namespace YES4Trade\Model;
class group_prices_item extends \YES4Trade\Model\BaseType {
    private static $propertyTypes = [
        'price_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'price_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'quantity' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'quantity'
        ],
        'personal_offer' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'personal_offer'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }


    public static function exists( int $customers_status_id, int $products_id, int $quantity ){
        $query = yes_query(sprintf(
            "SELECT price_id FROM %s WHERE products_id=:products_id AND quantity=:quantity",
                self::get_table_name($customers_status_id)
            ),['products_id'=>$products_id, 'quantity'=>$quantity]
        );
        return (sizeOf($query)>0) ? true : false;
    }
    
    private static function get_table_name( int $customers_status_id ){
        return 'personal_offers_by_customers_status_'.$customers_status_id;
    }
    
    public function create( int $customers_status_id ) {
        if(self::exists( $customers_status_id, $this->products_id, $this->quantity )){
            throw new Exception(sprintf(
                'Cant create personal_offer: Entry for pID %d / Quantity %d for customers_status %d exists',
                $this->products_id, $this->quantity, $customers_status_id
            ));
        }
        yes_db_perform( self::get_table_name($customers_status_id), $this->toArray() );
        return xtc_db_insert_id();
    }
    
    /**
     * 
     * @param int $customers_status_id
     * @param int $price_id
     * @param float $personal_offer
     * @throws Exception
     */
    public function update( int $customers_status_id ){
        $update_sql_array = [
            'products_id'=>$this->products_id,
            'quantity'=>$this->quantity,
            'personal_offer'=>$this->personal_offer,
        ];
        yes_db_perform( self::get_table_name($customers_status_id), $update_sql_array, 'update',[
            'price_id'=>$this->price_id
        ]);
    }
    
    public static function delete( int $customers_status_id, int $price_id){
        yes_query(sprintf(
            "DELETE FROM %s WHERE price_id=:id",
                self::get_table_name( $customers_status_id ),
            ),['id'=>$price_id]
        );
    }
}
