<?php
namespace YES4Trade\Model;
ini_set('sys_temp_dir', DIR_FS_CATALOG.'cache/');
class imap extends \YES4Trade\Model\BaseType{
    var $hostname, $username, $password, $inbox, $path_to_attachements;
    public function __construct(array $config){
        $this->path_to_attachements = \main::get_importdata_path().'mail_attachments/';
        if(!$this->check_dependencies()){
            return false;
        }
        $this->hostname = $config['hostname'];
        $this->username = $config['username'];
        $this->password = $config['password'];
    }

    private function check_dependencies(){
        if (!extension_loaded('imap')) {
            throw new \Exception("IMAP extension nicht geladen.\n");
        }        
        if(!function_exists('yes_get_sha1_from_string')){
            throw new \Exception('Function yes_get_sha1_from_string() not declared.');
        }
        if(!is_dir($this->path_to_attachements)){
            mkdir($this->path_to_attachements);
        }
        return true;
    }

    public static function open(string $hostname, string $username, string $password){
        $hostname_str = sprintf('{%s}INBOX',$hostname);
        $imap = @imap_open($hostname_str, $username, $password);
        if(!$imap) {
            throw new \Exception("Verbindung fehlgeschlagen: " . imap_last_error());
        }
        return $imap;
    }

    public function get_headerinfo(int $email_number){
        return imap_headerinfo($this->inbox, $email_number);
    }

    public function get_num_messages():int{
        $status = imap_status($this->inbox, sprintf('{%s}INBOX', $this->hostname), SA_MESSAGES);
        if ($status === false) {
            throw new \Exception("Konnte Status nicht abrufen: " . imap_last_error());
        }
        return intval($status->messages);
    }
    
    public function connect(){
        $this->inbox = self::open($this->hostname, $this->username, $this->password);
    }

    public function get_emails(){
        $this->connect();
        $num_msg = $this->get_num_messages();
        if($num_msg > 2500){
            throw new \Exception(sprintf("Es befinden sich %s Emails in Postfach %s auf Server %s. (max 2500)",$num_msg,$this->username,HTTP_SERVER)); 
        }    
        $emails = imap_search($this->inbox, 'ALL');
        if(is_countable($emails) and sizeOf($emails)){
            rsort($emails);
        }
        return $emails;
    }
    
    public function yes_import_mail(int $email_nr){
	    $rawEmail = imap_fetchheader($this->inbox, $email_nr) 
            . imap_body($this->inbox, $email_nr, FT_PEEK);
            
	$message = \ZBateson\MailMimeParser\Message::from($rawEmail, true);
	$text = $message->getTextContent();
	$html = $message->getHtmlContent();
	$fromObj = $message->getHeader('From');
	if($fromObj === null){
		$status = imap_fetch_overview($this->inbox, $email_nr, 0);
		preg_match('/<([^>]+)>/', $status[0]->from, $matches);

		if (isset($matches[1])) {
		    $from_email = $matches[1];
		} else {
		    $from_email = $status[0]->from;
		}		
		$from_name = '';
	}else{
		$from_name = $fromObj->getPersonName();
		$from_email = $fromObj->getEmail();
	}
	$date = $message->getHeader('Date');
	if($date !== null){
		$date_string = $date->getDateTime()->format('Y-m-d H:i:s');
	}else{
		$date_string = date('Y-m-d H:i:s');
	}
	
        try{
            $new_email_sql = [
                'subject'=>$message->getSubject(),
                'mailto'=>$this->username, // immer die emailadresse aus mailaccounts
                'from_name'=>$from_name,
                'from_email'=>$from_email,
                'messageid'=>$message->getMessageId()??'unknown',
                'date'=>$date_string,
                'format'=>''
            ];
        }catch(Exception $e){
            yes_mail_debug('Emaildaten konnten nicht ermittelt werden.'.$e->getMessage()."\n\n".print_r($rawEmail,true));
            return -1;
        }
        try{
            $email_id = \YES4Trade\Model\ebay_emails::create_ebay_emails($new_email_sql,
                (!empty($html))?$html:$text??'-- [YES System Meldung] kein inhalt gefunden ---'
            );
        }catch(Exception $e){
            yes_mail_debug('Email konnte nicht gespeichert werden.'.$e->getMessage()."\n\n".print_r($rawEmail,true));
            return -1;
        }
        foreach($message->getAllAttachmentParts() as $attachment){
            $filename = $attachment->getFilename();
            $stream = $attachment->getContent();
            if ($stream === null) {
                // Logge einen Fehler oder ignoriere diesen Anhang
                continue;
            }

            $save_path = $this->path_to_attachements.$email_id;
            $filename_sha1 = yes_get_sha1_from_string($filename);
            $save_name = $save_path.'/'.$filename_sha1;
            if(!is_dir($save_path)){
                mkdir($save_path);
            }
            if(is_file($save_name)){
                unlink($save_name);
            }
            $attachment->saveContent($save_name);
            \YES4Trade\Model\ebay_email_attachments::create_ebay_email_attachments([
                'email_id'=>intval($email_id),
                'filename'=>$filename,
                'filesize'=>filesize($save_name),
                'filetype'=>$attachment->getContentType()
            ]);
            
        }
        return $email_id;
    }

    public function delete(int $email_nr){
        imap_delete($this->inbox, $email_nr);
    }

    public function expunge(){
        imap_expunge($this->inbox);
    }
}
