<?php
namespace YES4Trade\Model;

class products_conditions_description extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'products_conditions_description';
    const TABLE_INDEX = 'products_conditions_description_id';
    private static $propertyTypes = [
        'products_conditions_description_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_conditions_description_id'
        ],
        'products_conditions_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_conditions_id'
        ],
        'language_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'language_id'
        ],
        'title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'title'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }

    public function create(){
        xtc_db_perform(sprintf("`%s`",self::TABLE_NAME), $this->toArray());
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(sprintf("`%s`",self::TABLE_NAME), $data,'update',self::TABLE_INDEX."='".$this->$index."'");
        self::clear_cache();
    }
    
    public static function get_from_db_by_products_conditions_id_and_language_id(int $products_conditions_id, int $language_id ){
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_conditions_id=:pc_id and language_id=:language_id",
                self::TABLE_NAME
            ),['pc_id'=>$products_conditions_id,'language_id'=>$language_id]
        );
        if(!sizeOf($query)){
            return false;
        }
        $record = current($query);
        foreach($record as $k=>$v){
            switch($k){
                case 'title':
                    break;
                default:
                    $v = (int)$v;
                    break;
            }
        }
        return new self($record);
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                sprintf("`%s`",self::TABLE_NAME),self::TABLE_INDEX, $index
        ));
    }
    
    public static function clear_cache(){
        global $InstanceCache;
        $languages = xtc_get_languages();
        $key = \YES4Trade\Model\products_conditions::CACHE_KEY;
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            foreach($languages as $lang){
                if($cd->getKey() == sprintf($key,$lang['id'])){
                    $InstanceCache->deleteItem($cd->getKey()); // products_conditions_*
                }
            }
        }
    }
}