<?php 
require_once(DIR_FS_CATALOG.'inc/yes_write_notice.inc.php');
require_once(DIR_FS_CATALOG.'inc/xtc_oe_get_price_o_tax.inc.php');
/**
 * Description of amazon_fba_order
 *
 * @author mario
 */
class amazon_fba_order {
    const NEW_CUSTOMER_STATUS = MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID;
    const NEW_CUSTOMER_ACCOUNT_TYPE = 0; // 1 waere Gastaccount
    const CUSTOMERS_ADDRESS_FORMAT_ID = 5;
    const ORDER_PAYMENT_METHOD = 'amazon';
    const ORDER_PAYMENT_CLASS = 'amazon_payment';
    const ORDER_SHIPPING_METHOD = 'Amazon-FBA';
    const ORDER_SHIPPING_CLASS = 'amazon';
    const CREATE_ORDERS_STATUS = ORDERS_STATUS_VERSENDET;
    const LANGUAGES_ID = 2;
    
    var $amazon_orders_fba_id,$orders_id,$amazon_order_id,$shipment_id,$shipment_item_id,$amazon_order_item_id,
	$purchase_date,$payments_date,$shipment_date,$reporting_date,
	$ship_service_level,$carrier,$tracking_number,$estimated_arrival_date,
	$fulfillment_center_id,$fulfillment_channel,$merchant_id,
	$merchant_order_item_id, $buyer_email, $buyer_name, 
	$buyer_phone_number, $sku, $product_name, $quantity_shipped, $currency, 
	$item_price, $item_tax, $shipping_price, $shipping_tax, $gift_wrap_price, 
	$gift_wrap_tax, $recipient_name, $ship_address_1, $ship_address_2, $ship_address_3, 
	$ship_city, $ship_state, $ship_postal_code, $ship_country, $ship_phone_number, 
	$bill_address_1, $bill_address_2, $bill_address_3, $bill_city, $bill_state, 
	$bill_postal_code, $bill_country, $item_promotion_discount, 
	$ship_promotion_discount, $sales_channel;
    var $products_id;
    var $errors = array();
    var $testmode = true;

    function __construct( $merchant_id,$testmode = true ){
        $this->testmode = $testmode;
        if(!defined('MODULE_OTHER_AMAZON_FBA_SHIP_PROMOTION_DISCOUNT_PRODUCTS_ID') or MODULE_OTHER_AMAZON_FBA_SHIP_PROMOTION_DISCOUNT_PRODUCTS_ID < 1){
               die('MODULE_OTHER_AMAZON_FBA_SHIP_PROMOTION_DISCOUNT_PRODUCTS_ID not defined');
        }else{
            $exists_check = xtc_get_products_name(MODULE_OTHER_AMAZON_FBA_SHIP_PROMOTION_DISCOUNT_PRODUCTS_ID,self::LANGUAGES_ID);
            if(empty($exists_check)){
                die('Zur hinterlegten MODULE_OTHER_AMAZON_FBA_SHIP_PROMOTION_DISCOUNT_PRODUCTS_ID konnte kein Artikelname ermittelt werden. Entweder existiert die pID nicht oder es wurde kein Artikelname hinterlegt');
            }
        }
        if(!defined('MODULE_OTHER_AMAZON_FBA_ITEM_PROMOTION_DISCOUNT_PRODUCTS_ID') or MODULE_OTHER_AMAZON_FBA_ITEM_PROMOTION_DISCOUNT_PRODUCTS_ID < 1){
               die('MODULE_OTHER_AMAZON_FBA_ITEM_PROMOTION_DISCOUNT_PRODUCTS_ID not defined');
        }else{
            $exists_check = xtc_get_products_name(MODULE_OTHER_AMAZON_FBA_ITEM_PROMOTION_DISCOUNT_PRODUCTS_ID,self::LANGUAGES_ID);
            if(empty($exists_check)){
                die('Zur hinterlegten MODULE_OTHER_AMAZON_FBA_ITEM_PROMOTION_DISCOUNT_PRODUCTS_ID konnte kein Artikelname ermittelt werden. Entweder existiert die pID nicht oder es wurde kein Artikelname hinterlegt');
            }
        }
        if(!defined('MODULE_OTHER_AMAZON_FBA_GIFT_WRAP_PRODUCTS_ID') or MODULE_OTHER_AMAZON_FBA_GIFT_WRAP_PRODUCTS_ID < 1){
               die('MODULE_OTHER_AMAZON_FBA_GIFT_WRAP_PRODUCTS_ID not defined');
        }else{
            $exists_check = xtc_get_products_name(MODULE_OTHER_AMAZON_FBA_GIFT_WRAP_PRODUCTS_ID,self::LANGUAGES_ID);
            if(empty($exists_check)){
                die('Zur hinterlegten MODULE_OTHER_AMAZON_FBA_GIFT_WRAP_PRODUCTS_ID konnte kein Artikelname ermittelt werden. Entweder existiert die pID nicht oder es wurde kein Artikelname hinterlegt');
            }
        }
        
        if(!class_exists('product')){
            die('Class product is not available');
        }
        if(!class_exists('basics')){
            die('Class basics is not available');
        }
        if(!defined('MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID')){
            die('Amazon Module is not ready. Missing: MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID');
        }
	if(empty($merchant_id)){
		die('merchant id not set');
        }
        if(!isset($_SESSION['languages_id'])){
            die('No Session Language defined');
        }
        if(!function_exists('xtc_get_tax_rate')){
            die('Missing xtc_get_tax_rate() Function');
        }
        if(!defined('MODULE_ORDER_TOTAL_TOTAL_TITLE')){
            die('MODULE_ORDER_TOTAL_* Language Module sind nicht geladen.');
        }
        if(!function_exists('yes_end_auction_add')){
            die('Missing Function yes_end_auction_add()');
        }
        if(!function_exists('yes_add_products_history')){
            die('Missing Function yes_add_products_history()');
        }
        
	$this->setMerchant_id($merchant_id);
    }

    private static function prepare_string($string){
        if($string == '--'){
            return '';
        }
	if(stristr(CHARSET,'utf-8')){
		return $string;
	}
	if(mb_detect_encoding($string) == 'UTF-8'){
		return utf8_decode($string);
 	}
	return $string;
    }
    
    private function get_ascii_info(){
        $info = array();
	$keys = array_keys(get_class_vars( __CLASS__ ));
        foreach($keys as $key){
            $info[] = sprintf('%s: %s',$key,$this->$key);
        }
        return implode("\r\n",$info);
    }

    private function debug_mail($com, $notice = false){
        if(!strstr(HTTP_SERVER,'localhost')){
            mail('m.aspeleiter@yes-websolutions.de','DEBUG MAIL '.basename(__FILE__),HTTP_SERVER."\r\n".$com."\r\n\r\n-----------------------------------\r\n\r\n".$this->get_ascii_info());
        }else{
            echo $com."\r\n\r\n-----------------------------------\r\n\r\n".$this->get_ascii_info()."\r\n";
        }
        if($notice){
            yes_write_notice('Amazon FBA Protokoll', $com.'<br /><br /><hr noshade="noshade"><pre>'.nl2br($this->get_ascii_info()).'</pre>', 0, main::get_notice_recipients('amazon'));
        }
    }   

    public function get_products_id_from_sku($sku){
	$query = xtc_db_query(sprintf(
		"SELECT products_id FROM amazon_products_fba WHERE seller_sku='%s' AND merchant_id='%s'",
		$sku, $this->getMerchant_id()
	));
	if(!xtc_db_num_rows($query)){
		return 0;
	}
	$record = xtc_db_fetch_array($query);
	return $record['products_id'];
    }

    public function set_from_amazon_response(array $response){
	$keys = array_keys(get_class_vars( __CLASS__ ));
	$this->setProducts_id( $this->get_products_id_from_sku( $response['sku'] ));
	foreach($response as $field=>$value){
		$field = str_replace('-','_',trim($field));
		if(in_array($field, $keys)){
			$func = sprintf('set%s',ucfirst($field));
			$this->$func( $this->prepare_string($value) );
		}else{
			switch($field){
				case 'merchant_order_id':
					// = orders_id
					break;
				default:
					$com = sprintf("Das Feld %s (Wert %s) ist in der Klasse amazon_fba_order nicht bekannt\n",$field,$value);
					$this->debug_mail($com);
					break;
			}
		}
	}
    }

    public function amazon_orders_fba_exists(){
	$query = xtc_db_query(sprintf(
		"SELECT amazon_orders_fba_id FROM amazon_orders_fba WHERE amazon_order_id='%s' AND amazon_order_item_id='%s'",
		$this->getAmazon_order_id(),$this->getAmazon_order_item_id()
	));
	return xtc_db_num_rows($query);
    }

    public function check_create_amazon_order_fba(){
	if($this->amazon_orders_fba_exists()){
		$this->add_error(sprintf(
			'Amazon Order ID %s / Amazon Order Item ID %s wurde bereits eingelesen',
			$this->getAmazon_order_id(),
			$this->getAmazon_order_item_id()
		));
		return false;
	}
	if($this->getProducts_id() == 0){
		$this->add_error(sprintf(
			'Unbekannter Artikel in Amazon Order ID %s / Amazon Order Item ID %s mit der SKU %s',
			$this->getAmazon_order_id(),
			$this->getAmazon_order_item_id(),
			$this->getSku()
		));
		return false;
	}
        if($this->getShipping_tax() > 0){
            $com = sprintf(
                'Es wurde eine shipping_tax in Hoehe von %s uebergeben. Diese Funktion ist bisher nicht in YES integriert. Der Support wurde autom. benachrichtigt.',$this->getShipping_tax()
            );
            $this->debug_mail($com,true);
            return false;
        }
        if($this->getItem_tax() > 0){
            $com = sprintf(
                'Es wurde eine item_tax in Hoehe von %s uebergeben. Diese Funktion ist bisher nicht in YES integriert. Der Support wurde autom. benachrichtigt.',$this->getItem_tax()
            );
            $this->debug_mail($com,true);
            return false;
        }
        
        if($this->getGift_wrap_tax() <> 0){
            $com = sprintf(
                'Es wurde eine gift_wrap_tax in Hoehe von %s uebergeben. Diese Funktion ist bisher nicht in YES integriert. Der Support wurde autom. benachrichtigt.',$this->getGift_wrap_tax()
            );
            $this->debug_mail($com,true);
            return false;
        }
        
	return true;
    }

    private function get_customers_id_from_email(){
	$query = xtc_db_query(sprintf(
		"SELECT customers_id FROM customers WHERE customers_email_address='%s'",
		$this->getBuyer_email()
	));
	if(!xtc_db_num_rows($query)){
		return 0;
	}
	$record = xtc_db_fetch_array($query);
	return $record['customers_id'];
    }

    public function create_amazon_order_fba_entry(){
	$keys = array_keys(get_class_vars( __CLASS__ ));
	$insert_sql_array = array();
	foreach($keys as $key){
		switch($key){
			case 'testmode':
			case 'errors':
				break;
			default:
				$func = sprintf('get%s',ucfirst($key));
				$insert_sql_array[ $key ] = $this->$func();
				break;
		}
	}
        if(!$this->testmode){
            xtc_db_perform('amazon_orders_fba',$insert_sql_array);
            $aofbaID = xtc_db_insert_id();
        }else{
            $aofbaID = 777777;
        }
	$this->setAmazon_orders_fba_id($aofbaID);
        $orders_id = $this->create_orders_entry();
        return true;
    }
    
    private function split_name($name, $return_part = 0){
        $parts = explode(' ',$name);
        $first_name = $last_name = '';
        foreach($parts as $k=>$v){
            if($k == (sizeOf($parts)-1)){
                $last_name = $v;
                continue;
            }
            $first_name .= $v.' ';
        }
        $first_name = trim($first_name);
        return ($return_part == 0) ? $first_name : $last_name;
    }

    private function create_customer(){
	$insert_sql_array = array(
		'customers_status'=>self::NEW_CUSTOMER_STATUS,
		'customers_firstname'=>$this->split_name($this->getBuyer_name(),0),
		'customers_lastname'=>$this->split_name($this->getBuyer_name(),1),
		'customers_email_address'=>$this->getBuyer_email(),
		'customers_default_address_id'=>0,
		'customers_telephone'=>$this->getBuyer_phone_number(),
		'customers_password'=>basics::generate_password(8),
		'account_type'=>self::NEW_CUSTOMER_ACCOUNT_TYPE,
		'customers_date_added'=>'now()'
	);
        if(!$this->testmode){
            xtc_db_perform('customers',$insert_sql_array);
            $customers_id = xtc_db_insert_id();
        }else{
            $customers_id = 9999;
        }
        $suburb = $this->getBill_address_2();
        if($this->getBill_address_3() != ''){
            if($suburb != ''){
                $suburb .= ' ';
            }
            $suburb .= $this->getBill_address_3();
        }
	$insert_sql_array = array(
            'customers_id'=>(int)$customers_id,
            'entry_company'=>'',
            'entry_firstname'=>$this->split_name($this->getBuyer_name(),0),
            'entry_lastname'=>$this->split_name($this->getBuyer_name(),1),
            'entry_street_address'=>$this->getBill_address_1(),
            'entry_suburb'=>$suburb,
            'entry_postcode'=>$this->getBill_postal_code(),
            'entry_city'=>$this->getBill_city(),
            'entry_state'=>(($this->getBill_state() != '--') ? $this->getBill_state() : ''),
            'entry_country_id'=>(int)$this->getYesCountry_id( $this->getBill_country()),
            'address_date_added'=>date('Y-m-d H:i:is'),
	);
        
        if(!$this->testmode){
            $new = new \YES4Trade\Model\address_book($insert_sql_array);
            $ab_id = $new->create();
        }else{
            $ab_id = 888888;
        }
	$update_sql_array = array(
		'customers_default_address_id'=>$ab_id
	);
        if(!$this->testmode){
        	xtc_db_perform('customers',$update_sql_array,'update',"customers_id='".$customers_id."'");
        }
        $new = new \YES4Trade\Model\customers_memo([
            'customers_id'=>(int)$customers_id,
            'memo_date'=>date('Y-m-d H:i:s'),
            'memo_title'=>'Amazon FBA Neukunde',
            'memo_text'=>'Amazon FBA Order #'.$this->getAmazon_order_id(),
            'poster_id'=>0
        ]);
        if(!$this->testmode){
        	$new->create();
        }
	return $customers_id;
    }

    private function create_orders_entry(){
	$customers_id = $this->get_customers_id_from_email();
	if($customers_id === 0){
		$customers_id = $this->create_customer();
	}
        $customer = new customer($customers_id,true);
        $suburb = $this->getBill_address_2();
        if($this->getBill_address_3() != ''){
            if($suburb != ''){
                $suburb .= ' ';
            }
            $suburb .= $this->getBill_address_3();
        }
        $ship_suburb = $this->getShip_address_2();
        if($this->getShip_address_3() != ''){
            if($ship_suburb != ''){
                $ship_suburb .= ' ';
            }
            $ship_suburb .= $this->getShip_address_3();
        }
	$insert_sql_array = array(
		'customers_id'=>$customers_id,
		'customers_cid'=>$customer->customers_cid,
		'customers_vat_id'=>$customer->customers_vat_id,
		'customers_status'=>$customer->customers_status,
		'customers_status_name'=> xtc_get_customers_status_name($customer->customers_status),
		'customers_status_image'=>$customer->get_customers_status_image(),
		'customers_status_discount'=>'',
		'customers_name'=>$this->getBuyer_name(),
		'customers_company'=>'',
		'customers_street_address'=>$this->getBill_address_1(),
		'customers_suburb'=>$suburb,
		'customers_city'=>$this->getBill_city(),
		'customers_postcode'=>$this->getBill_postal_code(),
		'customers_state'=>(($this->getBill_state()!='--')?$this->getBill_state():''),
		'customers_country'=>$this->getCountry_name_from_iso2($this->getBill_country()),
		'customers_telephone'=>$this->getBuyer_phone_number(),
		'customers_mobile'=>'',
		'customers_email_address'=>$this->getBuyer_email(),
		'customers_address_format_id'=>self::CUSTOMERS_ADDRESS_FORMAT_ID,
		'delivery_name'=>$this->getRecipient_name(),
		'delivery_company'=>'',
		'delivery_street_address'=>$this->getShip_address_1(),
		'delivery_suburb'=>$ship_suburb,
		'delivery_city'=>$this->getShip_city(),
		'delivery_postcode'=>$this->getShip_postal_code(),
		'delivery_state'=>$this->getShip_state(),
		'delivery_country'=>$this->getCountry_name_from_iso2($this->getShip_country()),
		'delivery_address_format_id'=>self::CUSTOMERS_ADDRESS_FORMAT_ID,
		'delivery_email_address'=>'',
		'delivery_telephone'=>$this->getShip_phone_number(),
		'billing_name'=>$this->getBuyer_name(),
		'billing_company'=>'',
		'billing_street_address'=>$this->getBill_address_1(),
		'billing_suburb'=>$suburb,
		'billing_city'=>$this->getBill_city(),
		'billing_postcode'=>$this->getBill_postal_code(),
		'billing_state'=>$this->getBill_state(),
		'billing_country'=>$this->getCountry_name_from_iso2($this->getBill_country()),
		'billing_address_format_id'=>self::CUSTOMERS_ADDRESS_FORMAT_ID,
		'payment_method'=>self::ORDER_PAYMENT_METHOD,
		'comments'=>'Amazon Order #'.$this->getAmazon_order_id().' / Amazon Item ID #'.$this->getAmazon_order_item_id(),
		'last_modified'=>'',
		'date_purchased'=>$this->getPurchase_date(),
		'date_payment'=>$this->getPayments_date(),
		'orders_status'=>self::CREATE_ORDERS_STATUS,
		'orders_date_finished'=>'',
		'currency'=>$this->getCurrency(),
		'currency_value'=>1,
		'account_type'=>$customer->account_type,
		'payment_class'=>self::ORDER_PAYMENT_CLASS,
		'shipping_method'=>self::ORDER_SHIPPING_METHOD,
		'shipping_class'=>self::ORDER_SHIPPING_CLASS,
		'language'=>'german',
		'versender'=>'',
		'date_shipping'=>$this->getShipment_date(),
		'comments_visible'=>'',
		'source'=>'amazon',
		'source_editor_id'=>0,
		'amazon_order_id'=>$this->getAmazon_order_id(),
		'amazon_orders_fba_id'=>$this->getAmazon_orders_fba_id()
	);
        if(!$this->testmode){
            xtc_db_perform('orders',$insert_sql_array);
            $orders_id = xtc_db_insert_id();
        }else{
            $orders_id = 666666;
        }
        $this->setOrders_id($orders_id);
        $product = new product($this->getProducts_id());
        $products_tax_rate = $this->get_products_tax_rate($product->info['products_tax_class_id']);
        
        // WIR SAMMELN DIE DATEN
        $tax = array();
        $total = 0;
        
        $tax[''.$products_tax_rate] = 0;
        
        $insert_sql_array = array(
            'orders_id'=>$orders_id,
            'products_id'=>$this->getProducts_id(),
            'products_model'=>$product->info['products_model'],
            'products_name'=>$this->getProduct_name(),
            'products_price'=>$this->getItem_price() / $this->getQuantity_shipped(),
            'products_discount_made'=>0,
            'final_price'=>$this->getItem_price(),
            'products_tax'=> $products_tax_rate,
            'products_quantity'=>$this->getQuantity_shipped(),
            'allow_tax'=>(($products_tax_rate > 0)?1:0),
            'date_added'=>'now()',
            'amazon_order_item_code'=>$this->getAmazon_order_item_id(),
            'amazon_sku'=>$this->getSku(),
            'quantity_shipped'=>$this->getQuantity_shipped(),
            'not_ship'=>0,
            'marge'=>0
        );
        
        if($this->testmode){
            printf("tax[ %s ] += %s (netto aus itemprice %s)\r\n",
                    $products_tax_rate,
                    ($this->getItem_price()-xtc_oe_get_price_o_tax($this->getItem_price(), $products_tax_rate, false)),
                    $this->getItem_price()
            );
        }
        $tax[''.$products_tax_rate] += ($this->getItem_price()-xtc_oe_get_price_o_tax($this->getItem_price(), $products_tax_rate, false));
        
        if(!$this->testmode){
            xtc_db_perform('orders_products',$insert_sql_array);
            $orders_products_id = xtc_db_insert_id();
            xtc_db_query(sprintf(
                "UPDATE %s SET products_ordered=products_ordered+%d WHERE products_id='%d'",
                TABLE_PRODUCTS,$this->getQuantity_shipped(),
                $this->getProducts_id()
            ));
            if(defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
                yes_end_auction_add($this->getProducts_id(),$this->getQuantity_shipped());
            }
            yes_add_products_history($this->getProducts_id(),
                sprintf('Amazon FBA Order %s Import: %d Stk',
                        $this->getAmazon_order_id(),
                        $this->getQuantity_shipped()
                )
            );
        }else{
            $orders_products_id = 555555;
        }
        
        if($this->getItem_promotion_discount() <> 0){
            $insert_sql_array = array(
                'orders_id'=>$orders_id,
                'products_id'=>MODULE_OTHER_AMAZON_FBA_ITEM_PROMOTION_DISCOUNT_PRODUCTS_ID,
                'products_name'=>xtc_get_products_name(MODULE_OTHER_AMAZON_FBA_ITEM_PROMOTION_DISCOUNT_PRODUCTS_ID,self::LANGUAGES_ID),
                'products_price'=>$this->getItem_promotion_discount(),
                'products_discount_made'=>0,
                'final_price'=>$this->getItem_promotion_discount(),
                'products_tax'=> $products_tax_rate,
                'products_quantity'=>1,
                'allow_tax'=>(($products_tax_rate > 0)?1:0),
                'date_added'=>'now()',
                'not_ship'=>0,
                'marge'=>0
            );
            
            if($this->testmode){
                printf("tax[ %s ] += %s (netto itempromotiondiscount %s)\r\n",
                        $products_tax_rate,
                        ($this->getItem_promotion_discount()-xtc_oe_get_price_o_tax($this->getItem_promotion_discount(), $products_tax_rate, false)),
                        $this->getItem_promotion_discount()
                );
            }
            $tax[''.$products_tax_rate] += ($this->getItem_promotion_discount()-xtc_oe_get_price_o_tax($this->getItem_promotion_discount(), $products_tax_rate, false));
            
            if(!$this->testmode){
                xtc_db_perform('orders_products',$insert_sql_array);
                $item_promo_disc_orders_products_id = xtc_db_insert_id();
            }else{
                $item_promo_disc_orders_products_id = 333000;
            }
        }
        
        if($this->getShip_promotion_discount() <> 0){
            $insert_sql_array = array(
                'orders_id'=>$orders_id,
                'products_id'=>MODULE_OTHER_AMAZON_FBA_SHIP_PROMOTION_DISCOUNT_PRODUCTS_ID,
                'products_name'=>xtc_get_products_name(MODULE_OTHER_AMAZON_FBA_SHIP_PROMOTION_DISCOUNT_PRODUCTS_ID,self::LANGUAGES_ID),
                'products_price'=>$this->getShip_promotion_discount(),
                'products_discount_made'=>0,
                'final_price'=>$this->getShip_promotion_discount(),
                'products_tax'=> $products_tax_rate,
                'products_quantity'=>1,
                'allow_tax'=>(($products_tax_rate > 0)?1:0),
                'date_added'=>'now()',
                'not_ship'=>0,
                'marge'=>0
            );
            
            if($this->testmode){
                printf("tax[ %s ] += %s (netto shippromotiondiscount %s)\r\n",
                        $products_tax_rate,
                        ($this->getShip_promotion_discount()-xtc_oe_get_price_o_tax($this->getShip_promotion_discount(), $products_tax_rate, false)),
                        $this->getShip_promotion_discount()
                );
            }
            $tax[''.$products_tax_rate] += ($this->getShip_promotion_discount()-xtc_oe_get_price_o_tax($this->getShip_promotion_discount(), $products_tax_rate, false));
            
            if(!$this->testmode){
                xtc_db_perform('orders_products',$insert_sql_array);
                $promo_disc_orders_products_id = xtc_db_insert_id();
            }else{
                $promo_disc_orders_products_id = 333333;
            }
        }
        
        if($this->getGift_wrap_price() <> 0){
            $insert_sql_array = array(
                'orders_id'=>$orders_id,
                'products_id'=>MODULE_OTHER_AMAZON_FBA_GIFT_WRAP_PRODUCTS_ID,
                'products_name'=>xtc_get_products_name(MODULE_OTHER_AMAZON_FBA_GIFT_WRAP_PRODUCTS_ID,self::LANGUAGES_ID),
                'products_price'=>$this->getGift_wrap_price(),
                'products_discount_made'=>0,
                'final_price'=>$this->getGift_wrap_price(),
                'products_tax'=> $products_tax_rate,
                'products_quantity'=>1,
                'allow_tax'=>(($products_tax_rate > 0)?1:0),
                'date_added'=>'now()',
                'not_ship'=>0,
                'marge'=>0
            );
            if($this->testmode){
                printf("tax[ %s ] += %s (netto giftwrapprice %s)\r\n",
                        $products_tax_rate,
                        ($this->getGift_wrap_price()-xtc_oe_get_price_o_tax($this->getGift_wrap_price(), $products_tax_rate, false)),
                        $this->getGift_wrap_price()
                );
            }
            $tax[''.$products_tax_rate] += ($this->getGift_wrap_price()-xtc_oe_get_price_o_tax($this->getGift_wrap_price(), $products_tax_rate, false));
            
            if(!$this->testmode){
                xtc_db_perform('orders_products',$insert_sql_array);
                $gift_wrap_orders_products_id = xtc_db_insert_id();
            }else{
                $gift_wrap_orders_products_id = 333333;
            }
        }
	if($this->getShipping_price() > 0){
            $insert_sql_array = array(
                'orders_id' => $orders_id,
                'title' => MODULE_ORDER_TOTAL_SHIPPING_TITLE . ':',
                'text' => '<b>'.number_format($this->getShipping_price(),2,',','.').' '.$this->getCurrency().'</b>',
                'value' => $this->getShipping_price(),
                'class' => 'ot_shipping',
                'sort_order' => MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER,
                'tax_rate_percent'=>$products_tax_rate
            );
            if(!$this->testmode){
                xtc_db_perform('orders_total',$insert_sql_array);
            }
            
            if($this->testmode){
                printf("tax[ %s ] += %s (netto shippingprice %s)\r\n",
                        $products_tax_rate,
                        ($this->getShipping_price()-xtc_oe_get_price_o_tax($this->getShipping_price(), $products_tax_rate, false)),
                        $this->getShipping_price()
                );
            }
            $tax[''.$products_tax_rate] += ($this->getShipping_price()-xtc_oe_get_price_o_tax($this->getShipping_price(), $products_tax_rate, false));
	}
        $subtotal_value = $this->getItem_price() 
                + $this->getGift_wrap_price() 
                + $this->getItem_promotion_discount() 
                + $this->getShip_promotion_discount();
                //+ $this->getShipping_price();
        $subtotal_title = MODULE_ORDER_TOTAL_SUBTOTAL_TITLE;
        $insert_sql_array = array (
                'orders_id' => $orders_id,
                'title' => $subtotal_title . ':',
                'text' => '<b>'.number_format($subtotal_value,2,',','.').' '.$this->getCurrency().'</b>',
                'value' => $subtotal_value,
                'class' => 'ot_subtotal',
                'sort_order' => MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER
        );

        if(!$this->testmode){
            xtc_db_perform('orders_total',$insert_sql_array);
            $orders_total_id = xtc_db_insert_id();
        }else{
            $orders_total_id = 444444;
        }

        $total_value = $this->getItem_price() 
                + $this->getGift_wrap_price() 
                + $this->getItem_promotion_discount() 
                + $this->getShip_promotion_discount() 
                + $this->getShipping_price() 
                /* TAX VALUES IGNORIEREN WIR ERST EINMAL
                 * + $this->getShipping_tax() 
                + $this->getGift_wrap_tax()
                + $this->getItem_tax()*/;
        $total_title = MODULE_ORDER_TOTAL_TOTAL_TITLE;
        $insert_sql_array = array (
                'orders_id' => $orders_id,
                'title' => $total_title . ':',
                'text' => '<b>'.number_format($total_value,2,',','.').' '.$this->getCurrency().'</b>',
                'value' => $total_value,
                'class' => 'ot_total',
                'sort_order' => MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER
        );

        if(!$this->testmode){
            xtc_db_perform('orders_total',$insert_sql_array);
            $orders_total_id = xtc_db_insert_id();
        }else{
            $orders_total_id = 444444;
        }
        foreach($tax as $tax_rate => $tax_amount){
            $ot_tax_title = sprintf('%s %s%%',MODULE_ORDER_TOTAL_TAX_TITLE,
                    number_format($tax_rate,0)
            );
            $insert_sql_array = array(
                'orders_id' => $orders_id,
                'title' => $ot_tax_title . ':',
                'text' => '<b>'.number_format($tax_amount,2,',','.').' '.$this->getCurrency().'</b>',
                'value' => $tax_amount,
                'class' => 'ot_tax',
                'sort_order' => MODULE_ORDER_TOTAL_TAX_SORT_ORDER
            );
            if(!$this->testmode){
                xtc_db_perform('orders_total',$insert_sql_array);
                $orders_total_id = xtc_db_insert_id();
            }else{
                $orders_total_id = 141414;
            }
        }
        $insert_sql_array = array(
            'orders_id'=>$orders_id,
            'orders_status_id'=>self::CREATE_ORDERS_STATUS,
            'date_added'=>'now()',
            'customer_notified'=>0,
            'comments'=>'Amazon FBA Import #'.$this->getAmazon_order_id(),
            'editor_id'=>0
        );
        if(!$this->testmode){
            xtc_db_perform('orders_status_history',$insert_sql_array);
        }
    }
    
    private function get_products_tax_rate($tax_class_id){
        return xtc_get_tax_rate($tax_class_id, $this->getYesCountry_id($this->getBill_country()));
    }
    
    private function getCountry_name_from_iso2($country_iso_2){
        $country_id = yes_get_country_id_from_iso2($country_iso_2);
        return xtc_get_country_name($country_id);
    }
    
    private function getYesCountry_id($country_iso_2){
        return yes_get_country_id_from_iso2($country_iso_2);
    }

    function add_error($error){
	$this->errors[] = $error;
    }

    function get_errors(){
	return $this->errors;
    }
	
    function setAmazon_orders_fba_id($amazon_orders_fba_id){
	$this->amazon_orders_fba_id = $amazon_orders_fba_id;
    }

    function getAmazon_orders_fba_id(){
	return $this->amazon_orders_fba_id;
    }

    function getOrders_id() {
        return $this->orders_id;
    }

    function getAmazon_order_id() {
        return $this->amazon_order_id;
    }

    function getShipment_id() {
        return $this->shipment_id;
    }

    function getShipment_item_id() {
        return $this->shipment_item_id;
    }

    function getAmazon_order_item_id() {
        return $this->amazon_order_item_id;
    }

    function getPurchase_date() {
        return $this->purchase_date;
    }

    function getPayments_date() {
        return $this->payments_date;
    }

    function getShipment_date() {
        return $this->shipment_date;
    }

    function getReporting_date() {
        return $this->reporting_date;
    }

    function getShip_service_level() {
        return $this->ship_service_level;
    }

    function getCarrier() {
        return $this->carrier;
    }

    function getTracking_number() {
        return $this->tracking_number;
    }

    function getEstimated_arrival_date() {
        return $this->estimated_arrival_date;
    }

    function getFulfillment_center_id() {
        return $this->fulfillment_center_id;
    }

    function getFulfillment_channel() {
        return $this->fulfillment_channel;
    }

    function getMerchant_id() {
        return $this->merchant_id;
    }

    function setOrders_id($orders_id) {
        $this->orders_id = $orders_id;
    }

    function setAmazon_order_id($amazon_order_id) {
        $this->amazon_order_id = $amazon_order_id;
    }

    function setShipment_id($shipment_id) {
        $this->shipment_id = $shipment_id;
    }

    function setShipment_item_id($shipment_item_id) {
        $this->shipment_item_id = $shipment_item_id;
    }

    function setAmazon_order_item_id($amazon_order_item_id) {
        $this->amazon_order_item_id = $amazon_order_item_id;
    }

    function setPurchase_date($purchase_date) {
        $this->purchase_date = $purchase_date;
    }

    function setPayments_date($payments_date) {
        $this->payments_date = $payments_date;
    }

    function setShipment_date($shipment_date) {
        $this->shipment_date = $shipment_date;
    }

    function setReporting_date($reporting_date) {
        $this->reporting_date = $reporting_date;
    }

    function setShip_service_level($ship_service_level) {
        $this->ship_service_level = $ship_service_level;
    }

    function setCarrier($carrier) {
        $this->carrier = $carrier;
    }

    function setTracking_number($tracking_number) {
        $this->tracking_number = $tracking_number;
    }

    function setEstimated_arrival_date($estimated_arrival_date) {
        $this->estimated_arrival_date = $estimated_arrival_date;
    }

    function setFulfillment_center_id($fulfillment_center_id) {
        $this->fulfillment_center_id = $fulfillment_center_id;
    }

    function setFulfillment_channel($fulfillment_channel) {
        $this->fulfillment_channel = $fulfillment_channel;
    }

    function setMerchant_id($merchant_id) {
        $this->merchant_id = $merchant_id;
    }
    function getMerchant_order_item_id() {
        return $this->merchant_order_item_id;
    }

    function getBuyer_email() {
        return $this->buyer_email;
    }

    function getBuyer_name() {
        return $this->buyer_name;
    }

    function getBuyer_phone_number() {
        return $this->buyer_phone_number;
    }

    function getSku() {
        return $this->sku;
    }

    function getProduct_name() {
        return $this->product_name;
    }

    function getQuantity_shipped() {
        return $this->quantity_shipped;
    }

    function getCurrency() {
        return $this->currency;
    }

    function getItem_price() {
        return $this->item_price;
    }

    function getItem_tax() {
        return $this->item_tax;
    }

    function getShipping_price() {
        return $this->shipping_price;
    }

    function getShipping_tax() {
        return $this->shipping_tax;
    }

    function getGift_wrap_price() {
        return $this->gift_wrap_price;
    }

    function getGift_wrap_tax() {
        return $this->gift_wrap_tax;
    }

    function getRecipient_name() {
        return $this->recipient_name;
    }

    function getShip_address_1() {
        return $this->ship_address_1;
    }

    function getShip_address_2() {
        return $this->ship_address_2;
    }

    function getShip_address_3() {
        return $this->ship_address_3;
    }

    function getShip_city() {
        return $this->ship_city;
    }

    function getShip_state() {
        return $this->ship_state;
    }

    function getShip_postal_code() {
        return $this->ship_postal_code;
    }

    function getShip_country() {
        return $this->ship_country;
    }

    function getShip_phone_number() {
        return $this->ship_phone_number;
    }

    function getBill_address_1() {
        return $this->bill_address_1;
    }

    function getBill_address_2() {
        return $this->bill_address_2;
    }

    function getBill_address_3() {
        return $this->bill_address_3;
    }

    function getBill_city() {
        return $this->bill_city;
    }

    function getBill_state() {
        return $this->bill_state;
    }

    function getBill_postal_code() {
        return $this->bill_postal_code;
    }

    function getBill_country() {
        return $this->bill_country;
    }

    function getItem_promotion_discount() {
        return $this->item_promotion_discount;
    }

    function getShip_promotion_discount() {
        return $this->ship_promotion_discount;
    }

    function getSales_channel() {
        return $this->sales_channel;
    }

    function setMerchant_order_item_id($merchant_order_item_id) {
        $this->merchant_order_item_id = $merchant_order_item_id;
    }

    function setBuyer_email($buyer_email) {
        $this->buyer_email = $buyer_email;
    }

    function setBuyer_name($buyer_name) {
        $this->buyer_name = $buyer_name;
    }

    function setBuyer_phone_number($buyer_phone_number) {
        $this->buyer_phone_number = $buyer_phone_number;
    }

    function setSku($sku) {
        $this->sku = $sku;
    }

    function setProduct_name($product_name) {
        $this->product_name = $product_name;
    }

    function setQuantity_shipped($quantity_shipped) {
        $this->quantity_shipped = (int)$quantity_shipped;
    }

    function setCurrency($currency) {
        $this->currency = $currency;
    }

    function setItem_price($item_price) {
        $this->item_price = (float)$item_price;
    }

    function setItem_tax($item_tax) {
        $this->item_tax = (float)$item_tax;
    }

    function setShipping_price($shipping_price) {
        $this->shipping_price = (float)$shipping_price;
    }

    function setShipping_tax($shipping_tax) {
        $this->shipping_tax = (float)$shipping_tax;
    }

    function setGift_wrap_price($gift_wrap_price) {
        $this->gift_wrap_price = (float)$gift_wrap_price;
    }

    function setGift_wrap_tax($gift_wrap_tax) {
        $this->gift_wrap_tax = (float)$gift_wrap_tax;
    }

    function setRecipient_name($recipient_name) {
        $this->recipient_name = $recipient_name;
    }

    function setShip_address_1($ship_address_1) {
        $this->ship_address_1 = $ship_address_1;
    }

    function setShip_address_2($ship_address_2) {
        $this->ship_address_2 = $ship_address_2;
    }

    function setShip_address_3($ship_address_3) {
        $this->ship_address_3 = $ship_address_3;
    }

    function setShip_city($ship_city) {
        $this->ship_city = $ship_city;
    }

    function setShip_state($ship_state) {
        $this->ship_state = $ship_state;
    }

    function setShip_postal_code($ship_postal_code) {
        $this->ship_postal_code = $ship_postal_code;
    }

    function setShip_country($ship_country) {
        $this->ship_country = $ship_country;
    }

    function setShip_phone_number($ship_phone_number) {
        $this->ship_phone_number = $ship_phone_number;
    }

    function setBill_address_1($bill_address_1) {
        $this->bill_address_1 = $bill_address_1;
    }

    function setBill_address_2($bill_address_2) {
        $this->bill_address_2 = $bill_address_2;
    }

    function setBill_address_3($bill_address_3) {
        $this->bill_address_3 = $bill_address_3;
    }

    function setBill_city($bill_city) {
        $this->bill_city = $bill_city;
    }

    function setBill_state($bill_state) {
        $this->bill_state = $bill_state;
    }

    function setBill_postal_code($bill_postal_code) {
        $this->bill_postal_code = $bill_postal_code;
    }

    function setBill_country($bill_country) {
        $this->bill_country = $bill_country;
    }

    function setItem_promotion_discount($item_promotion_discount) {
        $this->item_promotion_discount = $item_promotion_discount;
    }

    function setShip_promotion_discount($ship_promotion_discount) {
        $this->ship_promotion_discount = (float)$ship_promotion_discount;
    }

    function setSales_channel($sales_channel) {
        $this->sales_channel = $sales_channel;
    }

    function setProducts_id($products_id){
	$this->products_id = $products_id;
    }

    function getProducts_id(){
	return $this->products_id;
    }
}
