<?php
class SOAP
{
	var $type,$root,$ResponseArray = array();	
	function __construct($xml){
		if($xml != ''){
		
			$array = xml2array($xml);
			$this->setRoot($array['soapenv:Envelope']['soapenv:Body']);
			$type = key($this->root);
			$event = $this->root[$type]['NotificationEventName']['value'];
			$seller = $this->root[$type]['RecipientUserID']['value'];
			switch($event){
				case 'FixedPriceTransaction':
				case 'EndOfAuction':
					$item = $this->root[$type]['Item'];
					$ebay_id = $item['ItemID']['value'];
					$return = array();
					$return['event'] = $event;
					$return['seller'] = $seller;
					$return['ebay_id'] = $ebay_id;
					$return['returned_transactions'] = $this->root[$type]['ReturnedTransactionCountActual']['value'];
					$return['item'] = $item;
					$number_of_transactions = $this->root[$type]['ReturnedTransactionCountActual']['value'];
					// VERKAEUFE
					if($number_of_transactions > 0){
						$actual = 0;
						$return['mode'] = 'transactions';
						foreach($this->root[$type]['TransactionArray'] as $k=>$transaction){
							$return['transactions'][$actual] = $transaction;
							$actual++;
						}
					}else{
						// NUR END OF AUCTION
						$return['mode'] = 'EndOfAuction';
					}
					$this->setResponseArray($return);
					break;
			}
		}
	}
	function setRoot($value){
		$this->root = $value;
	}
	function getRoot($value){
		return $this->root;
	}
	function setResponseArray($value){
		$this->ResponseArray = $value;
	}
	function getResponseArray(){
		return $this->ResponseArray;
	}
	function xml2array($xml) {

	    $_data = NULL;

	    $xp = xml_parser_create();
	    xml_parser_set_option($xp, XML_OPTION_CASE_FOLDING, false);
	    xml_parser_set_option($xp, XML_OPTION_SKIP_WHITE, true);

	    xml_parse_into_struct($xp,$xml,$vals,$index);
	    xml_parser_free($xp);

	    $temp = $depth = array();
	    $dc = array();

	    foreach($vals as $value) {

	        $p = join('::', $depth);
	    
	        $key = $value['tag'];

	        switch ($value['type']) {
	    
	          case 'open':
	            array_push($depth, $key);
	            array_push($depth, (int)$dc[$p]++ );
	            break;

	          case 'complete':
	            array_pop($depth);
	            array_push($depth, $key);
	            $p = join('::',$depth);
	            $temp[$p] = $value['value'];
	            array_pop($depth);
	            array_push($depth, (int)$dc[$p] );
	            break;

	          case 'close':
	            array_pop($depth);
	            array_pop($depth);
	            break;

	        }

	    }

	    foreach ($temp as $key=>$value) {

	        $levels = explode('::',$key);
	        $num_levels = count($levels);

	        if ($num_levels==1) {
	            $_data[$levels[0]] = $value;
	        } else {
	            $pointer = &$_data;
	            for ($i=0; $i<$num_levels; $i++) {
	                if ( !isset( $pointer[$levels[$i]] ) ) {
	                    $pointer[$levels[$i]] = array();
	                }
	                $pointer = &$pointer[$levels[$i]];
	            }
	            $pointer = $value;
	        }

	    }

	    return ($_data);
	}
}

function xml2array($contents, $get_attributes=1) {
    if(!$contents) return array();

    if(!function_exists('xml_parser_create')) {
        //print "'xml_parser_create()' function not found!";
        return array();
    }
    //Get the XML parser of PHP - PHP must have this module for the parser to work
    $parser = xml_parser_create();
    xml_parser_set_option( $parser, XML_OPTION_CASE_FOLDING, 0 );
    xml_parser_set_option( $parser, XML_OPTION_SKIP_WHITE, 1 );
    xml_parse_into_struct( $parser, $contents, $xml_values );
    xml_parser_free( $parser );

    if(!$xml_values) return;//Hmm...

    //Initializations
    $xml_array = array();
    $parents = array();
    $opened_tags = array();
    $arr = array();

    $current = &$xml_array;

    //Go through the tags.
    foreach($xml_values as $data) {
        unset($attributes,$value);//Remove existing values, or there will be trouble
        extract($data);//We could use the array by itself, but this cooler.

        $result = '';
        if($get_attributes) {//The second argument of the function decides this.
            $result = array();
            if(isset($value)) $result['value'] = $value;

            //Set the attributes too.
            if(isset($attributes)) {
                foreach($attributes as $attr => $val) {
                    if($get_attributes == 1) $result['attr'][$attr] = $val; //Set all the attributes in a array called 'attr'
                    /**  :TODO: should we change the key name to '_attr'? Someone may use the tagname 'attr'. Same goes for 'value' too */
                }
            }
        } elseif(isset($value)) {
            $result = $value;
        }

        //See tag status and do the needed.
        if($type == "open") {//The starting of the tag '<tag>'
            $parent[$level-1] = &$current;

            if(!is_array($current) or (!in_array($tag, array_keys($current)))) { //Insert New tag
                $current[$tag] = $result;
                $current = &$current[$tag];

            } else { //There was another element with the same tag name
                if(isset($current[$tag][0])) {
                    array_push($current[$tag], $result);
                } else {
                    $current[$tag] = array($current[$tag],$result);
                }
                $last = count($current[$tag]) - 1;
                $current = &$current[$tag][$last];
            }

        } elseif($type == "complete") { //Tags that ends in 1 line '<tag />'
            //See if the key is already taken.
            if(!isset($current[$tag])) { //New Key
                $current[$tag] = $result;

            } else { //If taken, put all things inside a list(array)
                if((is_array($current[$tag]) and $get_attributes == 0)//If it is already an array...
                        or (isset($current[$tag][0]) and is_array($current[$tag][0]) and $get_attributes == 1)) {
                    array_push($current[$tag],$result); // ...push the new element into that array.
                } else { //If it is not an array...
                    $current[$tag] = array($current[$tag],$result); //...Make it an array using using the existing value and the new value
                }
            }

        } elseif($type == 'close') { //End of tag '</tag>'
            $current = &$parent[$level-1];
        }
    }

    return($xml_array);
} 
?>
