<?php
define('EBAY_MARKETPLACE_IDS',[
    'EBAY_AT',
    'EBAY_AU',
    'EBAY_BE',
    'EBAY_CA',
    'EBAY_CH',
    'EBAY_CN',
    'EBAY_CZ',
    'EBAY_DE',
    'EBAY_DK',
    'EBAY_ES',
    'EBAY_FI',
    'EBAY_FR',
    'EBAY_GB',
    'EBAY_GR',
    'EBAY_HALF_US',
    'EBAY_HK',
    'EBAY_HU',
    'EBAY_ID',
    'EBAY_IE',
    'EBAY_IL',
    'EBAY_IN',
    'EBAY_IT',
    'EBAY_JP',
    'EBAY_MOTORS_US',
    'EBAY_MY',
    'EBAY_NL',
    'EBAY_NO',
    'EBAY_NZ',
    'EBAY_PE',
    'EBAY_PH',
    'EBAY_PL',
    'EBAY_PR',
    'EBAY_PT',
    'EBAY_RU',
    'EBAY_SE',
    'EBAY_SG',
    'EBAY_TH',
    'EBAY_TW',
    'EBAY_US',
    'EBAY_VN',
    'EBAY_ZA'
]);

/**
 * XTC - EBAY API
 * CLASS WITH MISC FUNCTIONS
 *
 * @version $Id: class.ebay.php,v 1.349 2020/06/08 07:33:43 ssh-511548-cvs Exp $
 * @copyright 2004
 * @author: mario aspeleiter <dazze@gmx.de>
 **/

/* DINGE ZUM WISSEN

- in der tabelle ebay_auctions ist das feld 'status' wie folgt auszulesen:
  0 = Aktive Auktion bei Ebay
  1 = in Vorbereitung (Timer)
  2 = Auktion ist vorbei

*/


require_once(DIR_FS_CATALOG.'admin/includes/classes/class.ebay_item.php');		
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.ebay_sammler.php');		
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.ebay_product.php');		
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.ebay_auction.php');		
$_YES_auction_types = array(	'Chinese'=>'Auktion',
					'FixedPriceItem'=>'Festpreis',
					/*'StoresFixedPrice'=>'Shop'*/);
		
$_YES_auction_counter = array('NoHitCounter'=>'Kein Counter',
					'BasicStyle'=>'BasicStyle',
					'RetroStyle'=>'RetroStyle');
		
define('OAUTH2_USERTOKEN_FILE', main::get_secure_path().DIRECTORY_SEPARATOR.'ebay-sdk-oauth.usertoken');
define('OAUTH2_REFRESHTOKEN_FILE', main::get_secure_path().DIRECTORY_SEPARATOR.'ebay-sdk-oauth.refreshtoken');
class ebayAPI{
	var $price_class_included = false;
	var $array = false;
    var $item_add_errors = array();
	var $ebayCategoryPathArray;
        
        public static function get_ebay_config_ini(){
            if(!file_exists(main::get_secure_path().'EBAY_DEVELOPER_KEYS.ini')){
                throw new Exception('Missing developer keys ini file');
            }
            return parse_ini_file(main::get_secure_path().'EBAY_DEVELOPER_KEYS.ini',true);
        }
        
        private static function get_ebay_sdk_ini(){
            return self::get_ebay_config_ini();
        }
        
        public function isGood( $resultObj){
			return ($resultObj->Ack == 'Failure') ? false : true;
            //return (is_countable($resultObj->Errors) and sizeOf($resultObj->Errors)) ? false : true;
        }
        
        public function getResponseErrors( $resultObj, $use_html = false){
            $errors = [];
			if(!is_countable($resultObj->Errors) and $resultObj->Errors !== null){
				$err = $resultObj->Errors;
                $errDetails = [];
				if(isset($err->ErrorParameters)){
					if(is_countable($err->ErrorParameters)){
						foreach($err->ErrorParameters as $erp){
							$errDetails[] = sprintf('[Parameter %s] %s',
									$erp->ParamID, htmlentities($erp->Value)
							);
						}
					}else{
						$errDetails[] = sprintf('[Parameter %s] %s',
							$err->ErrorParameters->ParamID, htmlentities($err->ErrorParameters->Value)
						);
					}
				}
                $errTpl = '<div style="padding: 4px;margin-top: 15px;border: 1px solid red; background-color: #EEE;" class="main"><b>%s</b><br /><i>[Code #%s]</i> %s<br />%s<div style="page-break-inside: avoid;font-family: monospace;overflow: auto;display: block;word-wrap: break-word;">%s</div></div>';
                $errTpl_nohtml = '%s #%s: %s %s%s';
                $implode = '<br />';
                $implode_nohtml = '; ';
                $tpl = ($use_html === true) ? $errTpl : $errTpl_nohtml;
                $imp = ($use_html === true) ? $implode : $implode_nohtml;
                $errors[] = sprintf(
                        $tpl,
                        $err->SeverityCode,
                        $err->ErrorCode,
                        ($use_html)?htmlentities($err->ShortMessage):$err->ShortMessage,
                        ($use_html)?htmlentities($err->LongMessage):$err->LongMessage,
                        implode($imp,$errDetails)
                );
			}else{
				foreach($resultObj->Errors as $err){
					$errDetails = [];
					if(is_countable($err->ErrorParameters)){
						foreach($err->ErrorParameters as $erp){

							if (is_object($erp)) {
								$valueArray = (array)$erp;
								if (count($valueArray) > 0) {
									// Wenn du mit verschachtelten Objekten rechnest, hier erweitern
									$valueStr = json_encode($valueArray);
								}
							} else {
								$valueStr = (string)$erp;
							}
							$errDetails[] = sprintf('[Parameter %s] %s',
								$erp->ParamID, htmlentities($valueStr)
							);
						}
					}elseif($err->ErrorParameters !== null){
						if(gettype($err->ErrorParameters->Value) == 'object'){
							$valueArray = (array)$err->ErrorParameters->Value;
							$errval = '';
							if (count($valueArray) > 0) {
								// Wenn du mit verschachtelten Objekten rechnest, hier erweitern
								$errval = json_encode($valueArray);
							}
						}else{
							$errval = $err->ErrorParameters->Value;
						}
						$errDetails[] = sprintf('[Parameter %s] %s',
							$err->ErrorParameters->ParamID, htmlentities($errval)
						);
					}
					$errTpl = '<div style="padding: 4px;margin-top: 15px;border: 1px solid red; background-color: #EEE;" class="main"><b>%s</b><br /><i>[Code #%s]</i> %s<br />%s<div style="page-break-inside: avoid;font-family: monospace;overflow: auto;display: block;word-wrap: break-word;">%s</div></div>';
					$errTpl_nohtml = '%s #%s: %s %s%s';
					$implode = '<br />';
					$implode_nohtml = '; ';
					$tpl = ($use_html === true) ? $errTpl : $errTpl_nohtml;
					$imp = ($use_html === true) ? $implode : $implode_nohtml;
					$errors[] = sprintf(
							$tpl,
							$err->SeverityCode,
							$err->ErrorCode,
							($use_html)?htmlentities($err->ShortMessage):$err->ShortMessage,
							($use_html)?htmlentities($err->LongMessage):$err->LongMessage,
							implode($imp,$errDetails)
					);
				}
			}
            return $errors;
        }    
        
        public function getTaxonomyService(string $seller, int $site_id, bool $sandbox = false, $debug = false){
            if(empty($seller)){
                die('Error: Cant create TaxonomyService Class, missing seller');
            }
            $ini = $this->get_ebay_sdk_ini();
            $env = ($sandbox === true)?'sandbox':'production';
            $key = ($sandbox === true)?'test':'prod';
            try{
                $authToken = $this->get_oauth2_usertoken($seller);
            }catch( Exception $e){
                switch($e->getMessage()){
                    case 'REFRESH':
                        $authToken = $this->refresh_oauth2_usertoken($seller);
                        break;
                }
            }
            $site = $this->get_site_name_from_id( $site_id );
            return new \DTS\eBaySDK\Taxonomy\Services\TaxonomyService([
                'sandbox'     => $sandbox,
                'authorization'=> $authToken,
                'marketplaceId' => $site,//'EBAY_DE',
                'httpOptions' => []
            ]);
        }
        
        public static function getOAuthService( $seller, $sandbox = false ){
            if(empty($seller)){
                die('Error: Cant create TaxonomyService Class, missing seller');
            }
            $ini = self::get_ebay_sdk_ini();
            $key = ($sandbox === true)?'test':'prod';
            $cred = [
                'credentials' => [
                    'appId' => $ini['ebay-config']['app-key-'.$key], 
                    'certId' => $ini['ebay-config']['cert-id-'.$key], 
                    'devId' => $ini['ebay-config']['dev-key-'.$key], 
                ],
                'ruName'      => YES_UNIQUE_RUNAME,
                'httpOptions' => [],
            ];
            if($sandbox === true){
                $cred['sandbox'] = $sandbox;
                
            }
            return new \DTS\eBaySDK\OAuth\Services\OAuthService($cred);
        }
        
	public static function get_site_name_from_id($site_id){
            global $InstanceCache;
            $key = 'ebay_site_name_'.intval($site_id);
            $CachedString = $InstanceCache->getItem($key);
            if (!$CachedString->isHit()) {
				$site_name_query = xtc_db_query("SELECT site_name FROM ebay_sites WHERE id='".intval($site_id)."'");
				if(xtc_db_num_rows($site_name_query)){
					$site_name = xtc_db_fetch_array($site_name_query);
				}else{
					$site_name = [
						'site_name'=>''
					];
				}
                $CachedString->set($site_name)->expiresAfter(0);//'ebay_site_name_
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                $site_name = $CachedString->get();
            }
            return $site_name['site_name'];
	}
	public static function get_site_id_from_name($site_name){
            global $InstanceCache;
            $key = 'ebay_site_id_'.$site_name;
            $CachedString = $InstanceCache->getItem($key);
            if (!$CachedString->isHit()) {
				$site_id_query = xtc_db_query("SELECT id FROM ebay_sites WHERE site_name='".xtc_db_input($site_name)."'");
				$site_id = xtc_db_fetch_array($site_id_query);
                $CachedString->set($site_id)->expiresAfter(0);//ebay_site_id_*
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                $site_id = $CachedString->get();
            }
            return $site_id['id'];
	}
	public static function get_site_currency($DynEbaySiteID){
		if($DynEbaySiteID == "2") { // Canada
		$dynCurrencyCode = "CAD";
		$dynCurrencySign = "$";
		$dynEbaySiteCountry = "Canada";
		} else if($DynEbaySiteID == "3") { // United Kingdom
		$dynCurrencyCode = "GBP";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "United Kingdom";
		} else if($DynEbaySiteID == "15") { // Australia
		$dynCurrencyCode = "AUD";
		$dynCurrencySign = "$";
		$dynEbaySiteCountry = "Australia";
		} else if($DynEbaySiteID == "16") { // Austria
		$dynCurrencyCode = "EUR";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "Austria";
		} else if($DynEbaySiteID == "23") { // Belgium (French)
		$dynCurrencyCode = "EUR";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "Belgium - French";
		} else if($DynEbaySiteID == "71") { // France
		$dynCurrencyCode = "EUR";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "France";
		} else if($DynEbaySiteID == "77") { // Germany
		$dynCurrencyCode = "EUR";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "Germany";
		} else if($DynEbaySiteID == "101") { // Italy
		$dynCurrencyCode = "EUR";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "Italy";
		} else if($DynEbaySiteID == "123") { // Belgium (Dutch)
		$dynCurrencyCode = "EUR";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "Belgium - Dutch";
		} else if($DynEbaySiteID == "146") { // Netherlands
		$dynCurrencyCode = "EUR";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "Netherlands";
		} else if($DynEbaySiteID == "186") { // Spain
		$dynCurrencyCode = "EUR";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "Spain";
		} else if($DynEbaySiteID == "193") { // Switzerland
		$dynCurrencyCode = "CHF";
		$dynCurrencySign = "$";
		$dynEbaySiteCountry = "SFr.";
		} else if($DynEbaySiteID == "196") { // Taiwan
		$dynCurrencyCode = "TWD";
		$dynCurrencySign = "$";
		$dynEbaySiteCountry = "Taiwan";
		} else if($DynEbaySiteID == "201") { // Hong Kong
		$dynCurrencyCode = "HKD";
		$dynCurrencySign = "$";
		$dynEbaySiteCountry = "Hong Kong";
		} else if($DynEbaySiteID == "203") { // India
		$dynCurrencyCode = "INR";
		$dynCurrencySign = "&#8360;";
		$dynEbaySiteCountry = "India";
		} else if($DynEbaySiteID == "205") { // Ireland
		$dynCurrencyCode = "EUR";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "Ireland";
		} else if($DynEbaySiteID == "207") { // Malaysia
		$dynCurrencyCode = "MYR";
		$dynCurrencySign = "MR";
		$dynEbaySiteCountry = "Malaysia";
		} else if($DynEbaySiteID == "211") { // Philippines
		$dynCurrencyCode = "PHP";
		$dynCurrencySign = "P";
		$dynEbaySiteCountry = "Philippines";
		} else if($DynEbaySiteID == "212") { // Poland
		$dynCurrencyCode = "EUR";
		$dynCurrencySign = "�";
		$dynEbaySiteCountry = "Poland";
		} else if($DynEbaySiteID == "216") { // Singapore
		$dynCurrencyCode = "SGD";
		$dynCurrencySign = "$";
		$dynEbaySiteCountry = "Singapore";
		} else if($DynEbaySiteID == "218") { // Sweden
		$dynCurrencyCode = "SEK";
		$dynCurrencySign = "kr";
		$dynEbaySiteCountry = "Sweden";
		} else if($DynEbaySiteID == "223") { // China
		$dynCurrencyCode = "CNY";
		$dynCurrencySign = "&#20803;";
		$dynEbaySiteCountry = "China";
		} else {
		$dynCurrencyCode = "USD";
		$dynCurrencySign = "$";
		$dynEbaySiteCountry = "USA";
		}
		return $dynCurrencyCode;
	}
	
	function getToken($user) {
            $token_query = xtc_db_query("SELECT ebaytkn FROM ebay_auth WHERE user='".$user."'");
            $token_res = xtc_db_fetch_array($token_query);
            $token = $token_res["ebaytkn"];
            return $token;
	}


	/*
	 * der parameter cat1 bewirkt, dass bei den not-leaf kategorien keine id-zurueckgegeben wird
	 * das braucht man, wenn man zB nur Leaf-Kategorien klickbar machen will
	*/
	function getPullDownArray( $arr,$cat1 = false, $space_on = false ){
		for($i=0;$i<count($arr);$i++){
			$spaces = "";
			if($space_on){

				for($j = 3; $j<$arr[$i]["CategoryLevel"];$j++){
					$spaces .= " &nbsp; &nbsp;";
				}
			}
			$text = ($arr[$i]["LeafCategory"] == 'y') ? $spaces . $arr[$i]["CategoryName"] : $spaces.$arr[$i]["CategoryName"];
			if(!$cat1)
				$id = ($arr[$i]["LeafCategory"] == 'y') ? $arr[$i]["CategoryId"] : "none";
			else
				$id = $arr[$i]["CategoryId"];
			$return_arr[] = array("id"=>$id,"text"=>$text);
		}
		return $return_arr;
	}


	function get_products_id_from_id($id){
		$id_query = xtc_db_query("SELECT products_id FROM ".TABLE_EBAY_PRODUCTS." WHERE id='$id'");
		$data = xtc_db_fetch_array($id_query);
		return $data["products_id"];
	}

	
	function getProductDetails($id) {
		if(xtc_not_null($id)){
			$query = xtc_db_query("SELECT * FROM " . TABLE_EBAY_PRODUCTS . " WHERE id='".(int)$id."'");
			$data = xtc_db_fetch_array($query);
			return $data;
		}else{
			return array();
		}
	}

	/**
	 * Holt alle Daten zu einem ebay_auctions Eintrag
	 *
	 * @param Integer $id
	 * @return Array
	 */
	public static function _getTimerAuctionDetails($id) {
		if((int)$id < 1){
			return array();
		}
		$ea = \YES4Trade\Model\ebay_auctions::get_by_id((int)$id);
		if($ea === null){
			return array();
		}
		return $ea->toArray();
	}

	/**
	 * zaehlt die anzahl laufender ebay_auctions zu einer ebay_products_id
	 * beruecksichtigt ebay_auctions.status = 1|0 (wobei 1 nicht mehr vorkommt)
	 * @param int $ebay_products_id
	 * 
	 * @return int anzahl laufender auktionen
	 */
	public static function count_running_auctions_for_ebay_products_id( int $ebay_products_id ){
		return \YES4Trade\Model\ebay_auctions::count_running_auctions_for_ebay_products_id($ebay_products_id);
	}

	function get_category_to_products($products_id) {
		$query = xtc_db_query("SELECT category_id FROM " . TABLE_EBAY_PRODUCTS_TO_CATEGORIES . " WHERE products_id='".$products_id."'");
		$data = xtc_db_fetch_array($query);
		$return = (!empty($data["category_id"])) ? $data["category_id"] : false;
		return $return;
	}

	function get_category_to_products_saved($products_id) {
		$query = xtc_db_query("SELECT ebay_kategorie FROM " . TABLE_EBAY_PRODUCTS . " WHERE products_id='".$products_id."'");
		$data = xtc_db_fetch_array($query);
		return $data["ebay_kategorie"];
	}

	/**
	 * ist die angegebene ebay_id in yes als laufend gefuehrt? (status = 0)
	 * @param string $ebay_id
	 * 
	 * @return [type]
	 */
	function is_auction_active($ebay_id){
		return \YES4Trade\Model\ebay_auctions::is_ebay_id_active($ebay_id);
	}


	function generatePassword ($length = 8)
	{

	  // start with a blank password
	  $password = "";

	  // define possible characters
	  $possible = "0123456789bcdfghjkmnpqrstvwxyz";

	  // set up a counter
	  $i = 0;

	  // add random characters to $password until $length is reached
	  while ($i < $length) {

		// pick a random character from the possible ones
		$char = substr($possible, mt_rand(0, strlen($possible)-1), 1);

		// we don't want this character if it's already in the password
		if (!strstr($password, $char)) {
		  $password .= $char;
		  $i++;
		}

	  }

	  // done!
	  return $password;
	}

	function getSammlerValues($id_title=false) {
		$sammler = array( 0 => array("id"=>'',"text"=>TEXT_SELECT));
		$sammler[] = array("id"=>'0',"text"=>EBAY_SAMMLER_DEFAULT_TITEL);
		$sammler_query = xtc_db_query("SELECT id,titel FROM ".TABLE_EBAY_SAMMLER." WHERE aktiv='j' ORDER BY titel");
		while( $sammler_res = xtc_db_fetch_array($sammler_query) ) {
			if($id_title)
				$sammler[] = array("id"=>$sammler_res["id"],"text"=>$sammler_res["titel"].' [ID: '.$sammler_res["id"].']');
			else
				$sammler[] = array("id"=>$sammler_res["id"],"text"=>$sammler_res["titel"]);
		}
		return $sammler;
	}


	function getSammlerTitel($sammler_id) {
		if($sammler_id > 0) {
			$sammler_query = xtc_db_query("SELECT titel FROM ".TABLE_EBAY_SAMMLER." WHERE id='$sammler_id'");
			$sammler_res = xtc_db_fetch_array($sammler_query);
			return $sammler_res["titel"];
		}else{
			return EBAY_SAMMLER_DEFAULT_TITEL;
		}
	}

	function get_ebay_category_name_from_favorites($category_id,$site_id){
		$favorite_query_raw = sprintf("SELECT favorite_title FROM ebayapi_favorites WHERE favorite_ebayid='%s' and site='%s'",$category_id,$site_id);
		$favorite_query = yes_db_query($favorite_query_raw,true);
		if($favorite_query){
			$favorite = current($favorite_query);
			return $favorite['favorite_title'];
		}else{
			return false;
		}
	}
	
	function get_ebay_category($level,$parent,$site = EBAY_SITE_ID){
		$ebaycaller = new \YES4Trade\Model\ebaycalls();
		$body = [
			'DetailLevel' => 'ReturnAll',
			'CategorySiteID' => $site,
			'ViewAllNodes' => true
		];
		if(intval($level)>0){
			$body['LevelLimit'] = (int)$level;
		}
		if($parent > 0){
			$body['CategoryParent'] = $parent;
		}
		$seller = constant('EBAY_USER');
		if(self::oauth2_refreshtoken_exists($seller)){
				if(!self::oauth2_usertoken_exists($seller) or self::get_oauth2_usertoken_lifetime($seller) < 1){
					try{
						self::refresh_oauth2_usertoken($seller);
					}catch(Exception $e){
						$api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
					}
				}
		}

		$res = $ebaycaller->tradingQuery($seller,
			'GetCategories',
			$site,
			$body
		);
		if($res->Ack == 'Failure'){
			return $res->Errors;
		}
		return $res->CategoryArray;
	}

	function get_ebay_category_path_array($categoryID,$level,$site){
		$category = $this->get_ebay_category($level,$categoryID,$site);
		$parent = $category->Category->CategoryParentID;
		if($level > 1){
			if(is_countable($category->Category)){
				foreach($category->Category as $cat){
					if($cat->CategoryID == $categoryID){
						$this->ebayCategoryPathArray[] = $cat->CategoryName;
					}
				}
			}else{
				$this->ebayCategoryPathArray[] = $category->Category->CategoryName;
			}
			
			$this->get_ebay_category_path_array($parent,
				$category->Category->CategoryLevel,
				$site
			);
		}
        return true;
	}

	function get_ebay_category_path( $categoryID,$level,$site ){
		$this->ebayCategoryPathArray = array();
		$this->get_ebay_category_path_array($categoryID,$level,$site);
		$path_string = '';
		if(sizeOf($this->ebayCategoryPathArray)>0){
			$path = array_reverse($this->ebayCategoryPathArray);
			foreach($path as $k=>$v){
				$path_string .= $v . ' / ';
			}
		}
		return $path_string;
	}
        
	public static function get_sdk_type_class( string $className, array $parameters = []){
            $className = "\\DTS\\eBaySDK\\Trading\\Types\\".$className;
            return new $className($parameters);
        }
        
	private function iaP_prepare_string($string){
		return xtc_db_prepare_input($string);
	}

        /**
         * AddItem Objekt generieren
         * 
         * @global type $gh
         * @global type $groups
         * @global array $groups_array
         * @param int $id (ebay_products_id)
         * @param string $mode ist immer 'normal', da timings rausgeflogen sind
         * @param bool $stack_processing
         * @param bool $verify
         * @return Additem Request Object
         */
	function itemAddProcess($id,$mode = 'normal',$stack_processing = false, $verify = false) {
		$this->item_add_errors = array();
        $data = $this->getProductDetails($id);
		// EU-OSS 2021/07
		$country_id = yes_get_country_id_from_iso2($data['ebay_land']);
		$tcID = yes_eu_oss_get_products_tax_class_id(
			$data['products_id'], 
			$country_id
		);
		$pID = $data['products_id'];
		$epID = $id;
		if($data['ebay_site'] == 'Germany'){
			// EU-OSS 2021/07
			$tVAL = number_format(xtc_get_tax_rate($tcID,$country_id),2,'.','.');
			$collies = array();
			// calculate brutto price for display
			if(intval(constant('COLLI_ACTIVE'))==1){
					$collies = xtc_get_product_collies($pID);
					if(sizeOf($collies)>0){
						// EU-OSS 2021/07
						$tVAL = xtc_get_product_collies_tax_value($collies,$country_id);
					}
			}
		}

		$_PAYMENTS = $this->get_payments('ebay_products_payments','ebay_products_id',$id);
		if(defined('EBAY_TESTMODE') and EBAY_TESTMODE == '1'){
			$_PAYMENTS = ['CashOnPickup','MOCC'];
		}
		$this->get_shippingcosts_value('ebay_products',$_SHIPPINGMETHODS,$id);

		$_GALLERYPIC = $data["ebay_bild"];
		if(isset($data['ebay_insurancefee'])){
			$_INSURANCEFEE = $data['ebay_insurancefee'];
		}
		$_VAT = $data['ebay_vat'];
		$_TAXRATE = $tVAL;
		$_TYPE = $data["ebay_angebotsformat"];
		$_SHOPCAT = $data["ebay_shopcat"];
		$_SHOPCAT2 = $data["ebay_shopcat2"];
		$_CATEGORY = $data['ebay_kategorie'];
		$_CATEGORY2 = $data['ebay_kategorie2'];
		$_DURATION = $data["ebay_auktionsdauer"];
		$_BUYITNOWPRICE = $data["ebay_sofortkauf_preis"];
		$_AUCTIONPRICE = $data["ebay_preis"];
		$_TITLE = xtc_db_prepare_input($data["ebay_titel"]);
		$_COUNTER = $data['ebay_counter'];
		$_GELDZURUECK = $data['ebay_geldzurueck'];
		$_GALLERY = $data["ebay_gallery"];
		$_GALLERYPLUS = $data["ebay_gallery_plus"];
		$_GALLERYFEATURED = $data["ebay_galleryfeatured"];
		$_GALLERYFEATUREDDURATION = $data["ebay_galleryfeaturedduration"];
		$_SUBTITLETEXT = xtc_db_prepare_input($data["ebay_untertitel"]);
		$_QUANTITY = $data["ebay_menge"];
		if(isset($data["ebay_shippingoption"]))
			$_SHIPPINGOPTION = $data["ebay_shippingoption"];
		if(isset($data["new"]))
			$_NEU = $data["new"];
		$_BESTOFFER = $data["ebay_bestoffer"];
		$_SITE = $data["ebay_site"];
		$_LOCATION = $data['ebay_ort'];
		$_SHIPTOLOCATION = $data['ebay_land'];
		$_INSTRUCTIONS = $data["ebay_paymentinstructions"];

		$_BESTOFFER_PRICE = $data["ebay_bestoffer_price"];
		$_BESTOFFERAUTOACCEPTPRICE = $data["ebay_bestofferautoacceptprice"];
		$_EBAY_USER = $data['ebay_user'];
		$_EXTERNAL_PRODUCT_ID = $data['ebay_external_product_id'];
		$_EXTERNAL_PRODUCT_ID_TYPE = $data['ebay_external_product_id_type'];
		$_POSTALCODE = $data['ebay_postalcode'];
		$_DISPATCHTIMEMAX = $data['ebay_dispatchtimemax'];

		$_CHARACTERISTICS_TABLE = 'ebay_products_characteristics';
		$_CHARACTERISTICS_TABLE_KEY = 'ebay_products_id';
		$_ITEMCONDITION = $data['itemcondition'];

		$this->get_itemspecifics('ebay_product',$id,$_ITEMSPECIFICS);
		$_SHIPPINGDISCOUNTPROFILEID = $data['ShippingDiscountProfileID'];
		$_INTERNATIONALSHIPPINGDISCOUNTPROFILEID = $data['InternationalShippingDiscountProfileID'];
		$_RESERVEPRICE = $data['reserveprice'];
		$_EBAY_PLUS = $data['ebay_plus'];
		if(strlen($_SHIPTOLOCATION)==0){
			$_SHIPTOLOCATION = EBAY_SHIPTOLOCATIONS;
		}

		$item = new stdClass();

		$wrap1 = "";
		$template_file = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE . '/admin/ebay_templates/'.$data['ebay_template'];
        $PICPATH = (EXTERN_EBAYPICTURE_SERVER == 1) ? EXTERN_EBAYPICTURE_SERVER_PICURL : EBAY_PICPATH_WEBSERVER;
		if(!is_file($template_file)){
			$this->item_add_errors[] = 'eBay Template '.$data['ebay_template'].' not found';
			$wrap1 = 'no description available';
		}else{
			include(DIR_FS_CATALOG."admin/ebayapi_wrap.php");
		}
		$wrap1 = xtc_db_prepare_input($wrap1);
		$item->Description = $wrap1;

		if($_EBAY_PLUS == 1){
			$item->eBayPlus = true;
		}
		if($_DURATION > 0){
            $item->ListingDuration = 'Days_'.$_DURATION;
		}else{
			// BIS AUF WIDERRUF
			$item->ListingDuration = 'GTC';
		}
		if(!$variation_set){
            $item->Quantity = (int)$_QUANTITY;
		}
		
		$item->Title = $this->iaP_prepare_string($_TITLE);
		if(xtc_not_null($_SUBTITLETEXT)){
			$item->SubTitle = $this->iaP_prepare_string($_SUBTITLETEXT);
		}

		$site_id = $this->get_site_id_from_name($_SITE);
		$CUR = $this->get_site_currency($site_id);	
		$item->Currency = $CUR;
		if($_POSTALCODE != ''){
			$item->PostalCode = $_POSTALCODE;
		}
		$iso2 = yes_get_countries_iso_code_2_from_countries_name($_SITE);
		if($iso2 == '') {
			$country_id = 'DE'; // workaround germany falls nix
		}
		
		$item->Country = strtoupper($_SHIPTOLOCATION);
		
		$loc = ($_LOCATION != '') ? $_LOCATION : constant('EBAY_LOCATION');
		if(!empty($loc)){
			$item->Location = $loc;
		}
		
		$item->ListingType = $_TYPE;
        
		$item->PrimaryCategory = (object)[
			'CategoryID' => $_CATEGORY
		];
		
		if(xtc_not_null($_CATEGORY2)){
			$item->SecondaryCategory = (object)[
				'CategoryID' => $_CATEGORY2
			];
		}
			
	    // BOF PROPERTIES (MULTIVARIATIONS)
	    if(!class_exists('ebay_item')){
			include(DIR_FS_CATALOG.'admin/includes/classes/ebay_item.php');
	    }
	    $e = new \ebay_item();
	    $cID = xtc_get_site_country_id($_SITE);
	    $lID = xtc_is_language_installed($cID);
	    if(!$lID){
		    $lID = '2';
	    }

		if($_SITE == 'United Kingdom'){
			$_SITE = 'UK';
		}

		$item->Site = $_SITE;
	    
	    /**
	     * VORAUSSICHTLICHES PROBLEM BEI BRAND/MPN
	     * WENN IN DEN ITEMSPECIFICS ZB "Hersteller" ODER "MARKE"
	     * UEBERGEBEN WIRD, DANN FUEGEN WIR ZUSAETZLICH TROTZDEM "Brand" EIN
	     * DA WIR JA NICHT FUER ALLE SPRACHEN ALLE MOEGLICHKEITEN DURCHEXZER-
	     * ZIEREN KOENNEN
	     */
	    $mpn = array();
	    if($pID > 0){
			$mpn_query = xtc_db_query(sprintf(
				"SELECT m.manufacturers_name as brand, p.mpn FROM  %s p LEFT JOIN manufacturers m USING ( manufacturers_id ) WHERE products_id='%s' AND m.manufacturers_id IS NOT NULL",
				TABLE_PRODUCTS,$pID
			));
			if(xtc_db_num_rows($mpn_query)){
				$mpn = xtc_db_fetch_array($mpn_query);
			}
	    }
	    	
		// BOF SELLER RICHTLINIEN
		if($data['seller_profile_payment_id'] != '' or $data['seller_profile_shipping_id'] != '' or $data['seller_profile_return_policy_id'] != ''){
			$SellerProfiles = new \stdClass();
			if($data['seller_profile_payment_id'] != ''){
				$SellerProfiles->SellerPaymentProfile = (object)[
					'PaymentProfileID'=>(int)$data['seller_profile_payment_id']
				];
			}
			if($data['seller_profile_return_policy_id'] != ''){
				$SellerProfiles->SellerReturnProfile = (object)[
					'ReturnProfileID' => (int)$data['seller_profile_return_policy_id']
				];
			}
			if($data['seller_profile_shipping_id'] != ''){
				$SellerProfiles->SellerShippingProfile = (object)[
					'ShippingProfileID' => (int)$data['seller_profile_shipping_id']
				];
			}
			$item->SellerProfiles = $SellerProfiles;
		}
		// EOF SELLER RICHTLINIEN
	    
        /**
         * BOF - 2024-07 Pruefung ob scheduletime valide und in der Zukunft
         */
		if($data['scheduletime'] != '' and $data['scheduletime'] != '0000-00-00 00:00:00'){
            $dformat = 'Y-m-d H:i:s';
            $d = DateTime::createFromFormat($dformat, $data['scheduletime']);
            // The Y ( 4 digits year ) returns TRUE for any integer with any number of digits so changing the comparison from == to === fixes the issue.
            if($d && $d->format($dformat) === $data['scheduletime']){
                $current_date = new DateTime();
                if ($d > $current_date){
                    $item->ScheduleTime = $d;
                }
            }
        }
        /**
         * EOF - 2024-07 Pruefung ob scheduletime valide und in der Zukunft
         */
        
		$ebay_variations_sets_id = $this->get_ebay_variations_sets_id_from_ebay_products_id($epID);
		$variation_set = ($ebay_variations_sets_id > 0) ? true : false;
		// PREISBINDUNG CHECK!
		$isClass = class_exists('xtcPrice');
		if(!$isClass && !$this->price_class_included){
			require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
			$this->price_class_included = true;
		}
		if(!$xtPrice){
        	$xtPrice = new xtcPrice(DEFAULT_CURRENCY,EBAY_CUSTOMERS_STATUS);
        }

		if($_RESERVEPRICE > 0){
			$item->ReservePrice = (float)$_RESERVEPRICE;
		}
                
		if(EBAY_TESTMODE == 0){
			if(xtc_not_null($_SHOPCAT) and $_SHOPCAT > 0){
				$store_body = [
					'StoreCategoryID' => (int)$_SHOPCAT,
				];
				if(xtc_not_null($_SHOPCAT2) and $_SHOPCAT2 != ''){
					$store_body['StoreCategory2ID'] = (int)$_SHOPCAT2;
				}
				$store = (object)$store_body;
				$item->Storefront = $store;
			}
		}
		if(xtc_not_null($_GALLERYPIC)){
			$pics = $this->get_picture_details($pID,$epID,$_GALLERYPIC,$_GALLERY,$_GALLERYPLUS, $_GALLERYFEATUREDDURATION, $_GALLERYFEATURED, $_EXTERNAL_PRODUCT_ID);
			$item->PictureDetails = $pics;
		} // end if not empty gal_url

		if(!$variation_set){
			$item->StartPrice = (float)$_AUCTIONPRICE;
			if($_BUYITNOWPRICE > 0){
				$item->BuyItNowPrice = (float)$_BUYITNOWPRICE;
			}
		}
		
		if($_BESTOFFER == '1'){
			$best = new \stdClass();
			$LD = new \stdClass();
			$best->BestOfferEnabled = true;
			if($_BESTOFFER_PRICE > 0){
				$LD->MinimumBestOfferPrice = (float)$_BESTOFFER_PRICE;
			}
			if($_BESTOFFERAUTOACCEPTPRICE > 0){
				$LD->BestOfferAutoAcceptPrice = (float)$_BESTOFFERAUTOACCEPTPRICE;
			}
		    $item->BestOfferDetails = $best;
			$item->ListingDetails = $LD;
		}

		if(is_array($_PAYMENTS) and sizeOf($_PAYMENTS)>0){
            $item->PaymentMethods = $_PAYMENTS;
		}
		
		if(constant('EBAY_SHOW_AUCTION_TAX') == 'true' and $tVAL and (!defined('EBAY_TESTMODE') or intval(constant('EBAY_TESTMODE')) == 0)){
			$vatType = new \stdClass();
			$vatType->VATPercent = (float)$tVAL;
			$vatType->BusinessSeller = true;
			$item->VATDetails = $vatType;
		}
		if(sizeOf($_SHIPPINGMETHODS)>0){
			$shipD = new \stdClass();
			$shipD->ShippingServiceOptions = [];
			$shipD->InternationalShippingServiceOption = [];
			foreach($_SHIPPINGMETHODS as $Sk=>$ships){
				switch($Sk){
					case 'national':
						// COD AN ERSTE STELLE SETZEN
						$sort_shippings = array();
						$codship = false;
						foreach($ships as $nationalship){
							if(stristr($nationalship['shipService'],'pickup')){
								$codship = $nationalship;
							}else{
								$sort_shippings[] = $nationalship;
							}
						}
						if(isset($codship) and is_array($codship)){
							array_push($sort_shippings,$codship);
							$sort_shippings = array_reverse($sort_shippings);
						}
						$ships = $sort_shippings;
						// COD AN ERSTE STELLE SETZEN ENDE
						foreach($ships as $sk=>$_ship){
							$ship = new \stdClass();
							if($_ship['shipAdditionalFee']>0){
								$ship->ShippingServiceAdditionalCost = (float)$_ship['shipAdditionalFee'];
							}
							$ship->ShippingServiceCost = (float)$_ship['shipFee'];
							$ship->ShippingService = $_ship['shipService'];

							if($_ship['shipsWithinDays']>0){
								$ship->ShippingTimeMin = (int)$_ship['shipsWithinDays'];
							}
							$shipD->ShippingServiceOptions[] = $ship;
						}
						break;
					case 'international':
						foreach($ships as $sk=>$_ship){
							$shipI = new \stdClass();
							$shipI->ShipToLocation = [];
							if($_ship['shipAdditionalFeeIntl']>0){
								$shipI->ShippingServiceAdditionalCost = (float)$_ship['shipAdditionalFeeIntl'];
							}
							$shipI->ShippingServiceCost = (float)$_ship['shipFeeIntl'];
							$shipI->ShippingService = $_ship['shipServiceIntl'];
							if($_ship['shipIntlWorldwide']){
								$shipI->ShipToLocation[] = 'WorldWide';
							}else{
								for($l=0;$l<sizeOf($_ship['shipIntlRegion']);$l++){
									$shipI->ShipToLocation[] = $_ship['shipIntlRegion'][$l];
                                }
							}
							if(!is_countable($shipI->ShipToLocation) or !sizeOf($shipI->ShipToLocation)){
								unset($shipI->ShipToLocation);
							}
							$shipI->ShippingServicePriority = ($sk+1);
							$shipD->InternationalShippingServiceOption[] = $shipI;
						}
						break;
				}
			}
			if(!is_countable($shipD->InternationalShippingServiceOption) or !sizeOf($shipD->InternationalShippingServiceOption)){
				unset($shipD->InternationalShippingServiceOption);
			}

			if($_SHIPPINGDISCOUNTPROFILEID != ''){
				$shipD->ShippingDiscountProfileID = $_SHIPPINGDISCOUNTPROFILEID;
			}
			if($_INTERNATIONALSHIPPINGDISCOUNTPROFILEID != ''){
				$shipD->InternationalShippingDiscountProfileID = $_INTERNATIONALSHIPPINGDISCOUNTPROFILEID;
			}
			$item->ShippingDetails = $shipD;
		}
		if(defined('EBAY_SHIPTOLOCATIONS') and EBAY_SHIPTOLOCATIONS != ''){
			$item->ShipToLocations = [EBAY_SHIPTOLOCATIONS];
		}

		if($_EXTERNAL_PRODUCT_ID != '' && EBAY_AUTOMATIC_ISBN == 'true'){
			$epidtype = new \stdClass();
			$epidtype->Value = $_EXTERNAL_PRODUCT_ID;
			$epidtype->Type = $_EXTERNAL_PRODUCT_ID_TYPE;
			$item->ExternalProductID = $epidtype;
		}
		$num_of_specifx = 0;
		foreach($_ITEMSPECIFICS as $ik=>$iv){
		    if(empty($iv['value'])) continue;
		    $num_of_specifx++;
		}
		if($num_of_specifx > 0 and is_countable($_ITEMSPECIFICS) and sizeOf($_ITEMSPECIFICS)>0){
			$specifics = new \stdClass();
			$specifics->NameValueList = [];
			$is_grouped = array();
			foreach($_ITEMSPECIFICS as $ik=>$iv){
			    if(!isset($is_grouped[ $iv['name'] ])) $is_grouped[ $iv['name'] ] = array();
			    $is_grouped[ $iv['name'] ][] = $iv['value'];
			}
			$ic = 0;
			$has_mpn = false;
			$has_brand = false;
			foreach($is_grouped as $iv_name=>$ivalues){
			    $has_values = false;
				foreach($ivalues as $ivk=>$iv){
				    if(!empty($iv)) $has_values = true;
				}
				if(!$has_values)
				    continue;

				if($this->is_ebay_mpn_alias($iv_name,$site_id)){
				    $has_mpn = true;
				}
				if($this->is_ebay_brand_alias($iv_name,$site_id)){
				    $has_brand = true;
				}
				$specifics_set = new \stdClass();
				$specifics_set->Value = [];
				$specifics_set->Name = $iv_name;
				foreach($ivalues as $ivk=>$iv){
				    $specifics_set->Value[] = $iv;
				}
				$specifics->NameValueList[] = $specifics_set;
				$ic++;
			}
			if(!$has_mpn and !$variation_set){
				$specifics_set = new \stdClass();
				$specifics_set->Value = [];
			    $spName = $this->get_ebay_mpn_default_name($site_id,$_CATEGORY);
			    if(!empty($spName)){
					$specifics_set->Name = $spName;
					$specifics_set->Value[] = (empty($mpn['mpn'])) ? 'Does not apply' : $mpn['mpn'];
					$specifics->NameValueList[] = $specifics_set;
					$ic++;
			    }
			}
			if(!$has_brand and isset($mpn['brand'])){
				$specifics_set = new \stdClass();
				$specifics_set->Value = [];
			    $spName = $this->get_ebay_brand_default_name($site_id,$_CATEGORY);
			    if(!empty($spName)){
					$specifics_set->Name = $spName;
					$specifics_set->Value[] = $mpn['brand'];
					$specifics->NameValueList[] = $specifics_set;
					$ic++;
			    }
			}
			$item->ItemSpecifics = $specifics;
		}else{
			$specifics = new \stdClass();
			$specifics->NameValueList = [];
			$ic = 0;
			if(isset($mpn['brand']) and isset($mpn['mpn'])){
			    $spName = $this->get_ebay_brand_default_name($site_id,$_CATEGORY);
			    if(!empty($spName)){
					$specifics_set = new \stdClass();
					$specifics_set->Value = [];
					$specifics_set->Name = $spName;
					$specifics_set->Value[] = $mpn['brand'];
					$specifics->NameValueList[] = $specifics_set;
					$ic++;
					if(!$variation_set){
						$specifics_set = new \stdClass();
						$specifics_set->Value = [];
						$spName = $this->get_ebay_mpn_default_name($site_id,$_CATEGORY);
						if(!empty($spName)){
							$specifics_set->Name = $spName;
							$specifics_set->Value[] = (empty($mpn['mpn'])) ? 'Does not apply' : $mpn['mpn'];
							$specifics->NameValueList[] = $specifics_set;
							$ic++;
						}
					}
			    }
			}
			$item->ItemSpecifics = $specifics;
		}
		// BEARBEITUNGSDAUER
		if($_DISPATCHTIMEMAX > 0){
			$item->DispatchTimeMax = (int)$_DISPATCHTIMEMAX;
		}

		if($_ITEMCONDITION > 0){
			$item->ConditionID = (int)$_ITEMCONDITION;
		}

		// BOF VARIATIONS
		if($variation_set and !isset($variations)){
			$Variations = new \stdClass();
			$Variations->Pictures = [];
	    	$vpictures_array = $this->get_variations_pictures_array_from_ebay_variations_sets_id($ebay_variations_sets_id);
			if(sizeOf($vpictures_array)){
				$PicturesType = $this->get_variation_pictures_type($vpictures_array);
				$Variations->Pictures[] = $PicturesType;
			}
			
			/**
			 * VARIATION LISTE
			 */
			$has_variations = false;
			$variations_query = yes_db_query(sprintf(
				"SELECT products_id,ebay_variations_id,quantity,sku,startprice,ean,isbn FROM ebay_variations WHERE ebay_variations_sets_id='%s' ORDER BY sort_order",
				$ebay_variations_sets_id
			));
			if(yes_db_num_rows($variations_query)){
			    $has_variations = true;
			}
			$VariationSpecificsSet = new \stdClass();
			$VariationSpecificsSet->NameValueList = [];
			if($has_variations){
			    
				$vproducts_mpn_array = array(); // doppelqueries verhindern
				$NameValueListSetArray = array();
                $_addeds = []; // all unique values for VariationSpecificsSet
				foreach($variations_query as $record){
					$collies = xtc_get_product_collies($record['products_id']);
					if(is_countable($collies) and sizeOf($collies)){
						$this->item_add_errors[] = MSG_ERROR_ITEMADDPROCESS_STUECKLISTEN_NOT_ALLOWED;
						return false;
					}
					$Variation = new \stdClass();
					$Variation->StartPrice = (float)$record['startprice'];
					$VariationProductListingDetails = new \stdClass();
					$VariationSpecifics = new \stdClass();
					$VariationSpecifics->NameValueList = [];
					$Variation->SKU = $record['sku'];
					$Variation->Quantity = (int)$record['quantity'];
					if(!empty($record['isbn'])){
					    $VariationProductListingDetails->ISBN = $record['isbn'];
					}
					if(empty($record['ean'])){
					    $record['ean'] = (strtolower($country_id) == 'de') ? EBAY_EAN_UNKNOWN_IDENTIFIER_GERMAN : EBAY_EAN_UNKNOWN_IDENTIFIER_ENGLISH;
					}
					$VariationProductListingDetails->EAN = $record['ean'];
					if(!empty($record['ProductReferenceID'])){
						$VariationProductListingDetails->ProductReferenceID = $record['ProductReferenceID'];
					}
					$Variation->VariationProductListingDetails = $VariationProductListingDetails;
					
					$VariationSpecifics_query = yes_db_query(sprintf(
						"SELECT nvl_name,nvl_value FROM ebay_variations_variationspecifics WHERE ebay_variations_id='%s'",
						$record['ebay_variations_id']
					));
					if(!yes_db_num_rows($VariationSpecifics_query)){
						continue;
					}
					$var_has_mpn = false;
					foreach($VariationSpecifics_query as $VS){
						$NameValueList = new \stdClass();
						$NameValueList->Value = [];
						$vname = $this->iaP_prepare_string($VS['nvl_name']);
						if($vname == 'MPN') $var_has_mpn = true;
						$NameValueList->Name = $vname;
						
						$values = explode(';',$VS['nvl_value']);
						for($vi=0;$vi<sizeOf($values);$vi++){
							$NameValueList->Value[] = $this->iaP_prepare_string($values[$vi]);
							$NameValueListSetArray[ $vname ][] = $this->iaP_prepare_string($values[$vi]);
						}
						$VariationSpecifics->NameValueList[] = $NameValueList;
					}
					if(!$var_has_mpn){
					    // UMWEG UEBER $vproducts_mpn_array UM ZU VERHINDERN,
					    // DAS BEI zb 20 Varianten zur gleichen pID die selbe
					    // pID X mal abgefragt wird
					    if(!isset($vproducts_mpn_array[ $record['products_id'] ])){
							$var_mpn_query = xtc_db_query(sprintf(
								"SELECT m.manufacturers_name as brand, p.mpn FROM  %s p LEFT JOIN manufacturers m USING ( manufacturers_id ) WHERE products_id='%s' AND m.manufacturers_id IS NOT NULL",
								TABLE_PRODUCTS,$record['products_id']
							));
							if(xtc_db_num_rows($var_mpn_query)){
								$vproducts_mpn_array[ $record['products_id'] ] = xtc_db_fetch_array($var_mpn_query);
								if(empty($vproducts_mpn_array[ $record['products_id'] ]['mpn'])){
									$vproducts_mpn_array[ $record['products_id'] ]['mpn'] = 'Does not apply';
								}
							}else{
								$vproducts_mpn_array[ $record['products_id'] ] = array();
							}
					    }

					    if(isset($vproducts_mpn_array[ $record['products_id'] ]['mpn'])){
							$NameValueList = new \stdClass();
							$NameValueList->Value = [];
							$NameValueList->Name = 'MPN';
/// testen - vor allem die Value[] Anweisung, war vorher addValue
							$NameValueList->Value[] = $this->iaP_prepare_string($vproducts_mpn_array[ $record['products_id'] ]['mpn']);
							$VariationSpecifics->NameValueList[] = $NameValueList;
							$NameValueListSetArray[ 'MPN' ][] = $this->iaP_prepare_string($vproducts_mpn_array[ $record['products_id'] ]['mpn']);
					    }
					}
					$Variation->VariationSpecifics[] = $VariationSpecifics;
/// testen - vor allem die Variation[] Anweisung
					$Variations->Variation[] = $Variation;
				}
				if(sizeOf($NameValueListSetArray)){
					foreach($NameValueListSetArray as $nvlName=>$nvlValues){
						$NameValueList = new \stdClass();
						$NameValueList->Value = [];
						//$vname = utf8_encode($nvlName);
						$vname = $nvlName;
						$NameValueList->Name = $vname;

						foreach($nvlValues as $nvlValue){
/// testen - vor allem die Value[] Anweisung, war vorher addValue
							if(!in_array($nvlValue,$_addeds)){
/// testen - vor allem die value[] Anweisung
								$NameValueList->Value[] = $nvlValue;
								$_addeds[] = $nvlValue;
							}
						}
/// testen - vor allem die NameValueList[] Anweisung
						$VariationSpecificsSet->NameValueList[] = $NameValueList;
					}
					$Variations->VariationSpecificsSet = $VariationSpecificsSet;
				}
			}
			$item->Variations = $Variations;
		}else{
			$ProductListingDetails = new \stdClass();
		    if(!empty($data['isbn'])){
				$ProductListingDetails->ISBN = $data['isbn'];
		    }
		    if(empty($data['ean'])){
				$data['ean'] = (strtolower($country_id) == 'de') ? EBAY_EAN_UNKNOWN_IDENTIFIER_GERMAN : EBAY_EAN_UNKNOWN_IDENTIFIER_ENGLISH;
		    }
		    $ProductListingDetails->EAN = $data['ean'];
			if(!empty($data['ProductReferenceID'])){
				$ProductListingDetails->ProductReferenceID = $data['ProductReferenceID'];
			}
		    // BOF - MPN/Brand 
			$BrandMPN = new \stdClass();
		    if(isset($mpn['brand'])){
			    $BrandMPN->Brand = $mpn['brand'];
			    $mpn['mpn'] = (!isset($mpn['mpn']) or $mpn['mpn'] == '') ? 'Does not apply' : $mpn['mpn'];
			    $BrandMPN->MPN = $mpn['mpn'];
			    $ProductListingDetails->BrandMPN = $BrandMPN;
		    }else{
			    $BrandMPN->Brand = 'Does not apply';
			    $BrandMPN->MPN = 'Does not apply';
			    $ProductListingDetails->BrandMPN = $BrandMPN;
		    }
		    // EOF - MPN/Brand
		    $item->ProductListingDetails = $ProductListingDetails;
		    $item->SKU = "$pID";
		}
               
               
		// EOF TEST VARIATIONS
		$RTP = new \stdClass();
		$RTP->Description = EBAY_RETURNPOLICY_DESCRIPTION;
		$RTP->ReturnsAcceptedOption = 'ReturnsAccepted';
		$RTP->ShippingCostPaidByOption = $data['shippingcostpaidby'];
		$RTP->ReturnsWithinOption = $data['returnswithincode'];
                
		if($_SITE != 'US'){ // GIBTS IN US NICHT?
			$item->ReturnPolicy = $RTP;
		}
                
		$include_reg = false;
		$reg = new \stdClass();
		$ee = \YES4Trade\Model\ebay_products_energy_efficiency::get_by_ebay_products_id($epID);
		if($ee != null){
			$EnergyEff = new \stdClass();
			if(!empty($ee->energy_efficiency_image_description)){
				$EnergyEff->ImageDescription = $ee->energy_efficiency_image_description;
			}
			if(!empty($ee->energy_efficiency_image_url)){
				$EnergyEff->ImageURL = $ee->energy_efficiency_image_url;
			}
			if(!empty($ee->energy_efficiency_ProductInformationsheet)){
				$EnergyEff->ProductInformationsheet = $ee->energy_efficiency_ProductInformationsheet;
			}
			$reg->EnergyEfficiencyLabel = $EnergyEff;
			$include_reg = true;
		}
                
		$haz = \YES4Trade\Model\ebay_products_regulatory_hazmats::get_by_ebay_products_id($epID);
		if($haz != null){
			$Hazmat = new \stdClass();
			$pictograms = [];
			if(!empty($haz->pictograms)){
				$pictograms = explode(',',$haz->pictograms);
			}
			if(is_countable($pictograms) and sizeOf($pictograms)){
				$Picto = new \stdClass();
				$Picto->Pictogram = [];
				foreach($pictograms as $pictogram){
					$Picto->Pictogram[] = $pictogram;
				}
				$Hazmat->Pictograms = $Picto;
			}
			if(!empty($haz->signalword)){
				$Hazmat->SignalWord = $haz->signalword;
			}
			$statements_array = [];
			if(!empty($haz->statements)){
				$statements_array = explode(',',$haz->statements);
			}
			if(is_countable($statements_array) and sizeOf($statements_array)){
				$State = new \stdClass();
				$State->Statement = [];
				foreach($statements_array as $stm){
					$State->Statement[] = $stm;
				}
				$Hazmat->Statements = $State;
			}
			$reg->Hazmat = $Hazmat;
			$include_reg = true;
		}
                
		$saf = \YES4Trade\Model\ebay_products_productsafety::get_by_ebay_products_id($epID);
		if($saf != null){
			$ProductSafety = new \stdClass();
			$statements_array = [];
			if(!empty($saf->statements)){
				$State = new \stdClass();
				$State->Statement = explode(',',$saf->statements);
				$ProductSafety->Statements = $State;
			}
			if(!empty($saf->pictograms)){
				$pictograms = explode(',',$saf->pictograms);
				$Picto = new \stdClass();
				$Picto->Pictogram = $pictograms;
				$ProductSafety->Pictograms = $Picto;
			}
			$reg->ProductSafety = $ProductSafety;
			$include_reg = true;
		}
                
		$epm = \YES4Trade\Model\ebay_products_manufacturer::get_by_ebay_products_id($epID);
		if($epm != null){
			$Manufacturer = new \stdClass();
			$keys = \YES4Trade\Model\ebay_products_manufacturer::get_array_keys();
			foreach($keys['propertyTypes'] as $ptk=>$ptv){
				if(strpos($ptk,'manufacturer_') !== 0){
					continue;
				}
				$rep_key = str_replace('manufacturer_','',$ptk);
				switch($rep_key){
					case 'cityname': $Manufacturer->CityName = $epm->$ptk;break;
					case 'companyname': $Manufacturer->CompanyName = $epm->$ptk;break;
					case 'country': $Manufacturer->Country = $epm->$ptk;break;
					case 'email': $Manufacturer->Email = $epm->$ptk;break;
					case 'phone': $Manufacturer->Phone = $epm->$ptk;break;
					case 'postalcode': $Manufacturer->PostalCode = $epm->$ptk;break;
					case 'stateorprovince': $Manufacturer->StateOrProvince = $epm->$ptk;break;
					case 'cityname': $Manufacturer->CityName = $epm->$ptk;break;
					case 'street2': $Manufacturer->Street2 = $epm->$ptk;break;
					case 'street1': $Manufacturer->Street1 = $epm->$ptk;break;
				}
			}
			$reg->Manufacturer = $Manufacturer;
			$include_reg = true;
		}
		$rsps = \YES4Trade\Model\ebay_products_responsible_persons::get_by_ebay_products_id($epID);
		if(sizeOf($rsps)){
			$ResponsiblePersons = [];
			$keys = \YES4Trade\Model\ebay_products_responsible_persons::get_array_keys();
			foreach($rsps as $rsp){
				$ResponsiblePerson = new \stdClass();
				foreach($keys['propertyTypes'] as $ptk=>$ptv){
					if(strpos($ptk,'rp_') !== 0){
						continue;
					}
					$rep_key = str_replace('rp_','',$ptk);
					switch($rep_key){
						case 'cityname': $ResponsiblePerson->CityName = $rsp->$ptk;break;
						case 'companyname': $ResponsiblePerson->CompanyName = $rsp->$ptk;break;
						case 'country': $ResponsiblePerson->Country = $rsp->$ptk;break;
						case 'email': $ResponsiblePerson->Email = $rsp->$ptk;break;
						case 'phone': $ResponsiblePerson->Phone = $rsp->$ptk;break;
						case 'postalcode': $ResponsiblePerson->PostalCode = $rsp->$ptk;break;
						case 'stateorprovince': $ResponsiblePerson->StateOrProvince = $rsp->$ptk;break;
						case 'cityname': $ResponsiblePerson->CityName = $rsp->$ptk;break;
						case 'street2': $ResponsiblePerson->Street2 = $rsp->$ptk;break;
						case 'street1': $ResponsiblePerson->Street1 = $rsp->$ptk;break;
					}
					$Types = new \stdClass();
					$Types->Type = ['EUResponsiblePerson'];
					$ResponsiblePerson->Types = $Types;
				}
				$ResponsiblePersons[] = $ResponsiblePerson;
			}
			$reg->ResponsiblePersons = $ResponsiblePersons;
			$include_reg = true;
		}
                
		$docs = \YES4Trade\Model\ebay_products_regulatory_documents::get_by_ebay_products_id($epID);
		if(sizeOf($docs)){
			$Documents = [];
			foreach($docs as $doc){
				$Document = new \stdClass();
				$Documents->Document = [];
				$Document->DocumentID = $doc->documents_id;
				$Documents->Document[] = $Document;
			}
			$reg->Documents = $Documents;
			$include_reg = true;
		}
                                
		if($include_reg){
			$item->Regulatory = $reg;
		}
                
		$videos = \YES4Trade\Model\ebay_products_videos::get_by_ebay_products_id($epID);
		if(sizeOf($videos)){
			$VideoDetails = new \stdClass();
			$VideoDetails->VideoID = [];
			foreach($videos as $video){
				$VideoDetails->VideoID[] = $video->video_id;
			}
			$item->VideoDetails = $VideoDetails;
		}
		$req = new \stdClass();
		$req->Item = $item;
		$req->ErrorLanguage = 'de_DE';
		return $req;	
	}

	function get_converted_payment_string($ebay_payment) {
		switch (strtolower($ebay_payment)){
			case 'paypal':
				$string = 'Paypal';
				break;			
			case 'cod':
			case 'de_cod':
			case 'yes_cod':
				$string = 'cod';
				break;			
			case 'invoice':
				$string = 'invoice';
				break;			
			default:
				$string = "moneyorder";
				break;
		}
		return $string;
	}
		
	function remove_combined_order($remOID,$parent_orders_id ) {
		$remOrder = new order($remOID);
		for ($i = 0, $n = sizeof($remOrder->totals); $i < $n; $i++) {
			switch($remOrder->totals[$i]['class']) {
				case 'ot_subtotal':
					$remSubtotal = $remOrder->totals[$i]['value'];
					break;
				case 'ot_total':
					$remTotal = $remOrder->totals[$i]['value'];
					break;
				case 'ot_shipping':
					$remShippingcosts += $remOrder->totals[$i]['value'];
					break;
				case 'ot_cod_fee':
					$rem_ot_cod_fee += $remOrder->totals[$i]['value'];
					break;
				case 'ot_coupon':
					$rem_ot_coupon += $remOrder->totals[$i]['value'];
					break;
				case 'ot_discount':
					$rem_ot_discount += $remOrder->totals[$i]['value'];
					break;
				case 'ot_gv':
					$rem_ot_gv += $remOrder->totals[$i]['value'];
					break;
				case 'ot_loworderfee':
					$rem_ot_loworderfee += $remOrder->totals[$i]['value'];
					break;
				case 'ot_subtotal_no_tax':
					$rem_ot_subtotal_no_tax += $remOrder->totals[$i]['value'];
					break;
			}
		} // end all orders_total from remOID
		$order = new order($parent_orders_id);
		$currency = $order->info['currency'];
                $shipping_tax_rate = 0;
                $max_tax_value = 0;
		for ($i = 0, $n = sizeof($order->totals); $i < $n; $i++) {
			switch($order->totals[$i]['class']) {
				case 'ot_subtotal':
					$Subtotal = $order->totals[$i]['value'];
					break;
				case 'ot_total':
					$Total = $order->totals[$i]['value'];
					break;
				case 'ot_shipping':
					$Shippingcosts += $order->totals[$i]['value'];
					break;
				case 'ot_cod_fee':
					$ot_cod_fee += $order->totals[$i]['value'];
					break;
				case 'ot_coupon':
					$ot_coupon += $order->totals[$i]['value'];
					break;
				case 'ot_discount':
					$ot_discount += $order->totals[$i]['value'];
					break;
				case 'ot_gv':
					$ot_gv += $order->totals[$i]['value'];
					break;
				case 'ot_loworderfee':
					$ot_loworderfee += $order->totals[$i]['value'];
					break;
				case 'ot_subtotal_no_tax':
					$ot_subtotal_no_tax += $order->totals[$i]['value'];
					break;
                                case 'ot_tax':
                                    if($order->totals[$i]['value'] > $max_tax_value){
                                        $max_tax_value = $order->totals[$i]['value'];
                                        $shipping_tax_rate = $order->totals[$i]['tax_rate_percent'];
                                    }
                                    break;
			}
		} // end all orders_total from remOID
		$newSubtotal = $Subtotal - $remSubtotal;
		$newTotal = $Total - ($remTotal-$remShippingcosts);
		
		$newShippingcosts = $Shippingcosts;
		
		$newot_cod_fee = $ot_cod_fee - $rem_ot_cod_fee;
		$newot_coupon = $ot_coupon - $rem_ot_coupon;
		$newot_discount = $ot_discount - $rem_ot_discount;
		$newot_gv = $ot_gv - $rem_ot_gv;
		$newot_loworderfee = $ot_loworderfee - $rem_ot_loworderfee;
		$newot_subtotal_no_tax = $ot_subtotal_no_tax - $rem_ot_subtotal_no_tax;
		
		xtc_db_query("UPDATE ".TABLE_ORDERS_TOTAL." SET text='".number_format($newSubtotal,2,',','')." ".$currency."', value='".$newSubtotal."' WHERE class='ot_subtotal' && orders_id='$parent_orders_id'");
                $mwst_divisor = (100+$shipping_tax_rate) / 100;
		xtc_db_query("UPDATE ".TABLE_ORDERS_TOTAL." SET text='".number_format( ($newSubtotal-($newSubtotal/$mwst_divisor)) ,2,',','')." ".$currency."', value='".($newSubtotal-($newTotal/$mwst_divisor))."' WHERE orders_id='$parent_orders_id'  && class='ot_tax'");
		xtc_db_query("UPDATE ".TABLE_ORDERS_TOTAL." SET text='".number_format($newTotal,2,',','')." ".$currency."', value='".$newTotal."' WHERE orders_id='$parent_orders_id' && class='ot_total'");

		xtc_db_query("UPDATE ".TABLE_ORDERS_TOTAL." SET text='".number_format($newot_cod_fee,2,',','')." ".$currency."', value='".$newot_cod_fee."' WHERE orders_id='$parent_orders_id' && class='ot_cod_fee'");
		xtc_db_query("UPDATE ".TABLE_ORDERS_TOTAL." SET text='".number_format($newot_coupon,2,',','')." ".$currency."', value='".$newot_coupon."' WHERE orders_id='$parent_orders_id' && class='ot_coupon'");
		
		xtc_db_query("UPDATE ".TABLE_ORDERS_TOTAL." SET text='".number_format($newShippingcosts,2,',','')." ".$currency."', value='".$newShippingcosts."' WHERE orders_id='$parent_orders_id' && class='ot_shipping'");
		
		xtc_db_query("UPDATE ".TABLE_ORDERS_TOTAL." SET text='".number_format($newot_discount,2,',','')." ".$currency."', value='".$newot_discount."' WHERE orders_id='$parent_orders_id' && class='ot_discount'");
		xtc_db_query("UPDATE ".TABLE_ORDERS_TOTAL." SET text='".number_format($newot_qv,2,',','')." ".$currency."', value='".$newot_qv."' WHERE orders_id='$parent_orders_id' && class='ot_qv'");
		xtc_db_query("UPDATE ".TABLE_ORDERS_TOTAL." SET text='".number_format($newot_loworderfee,2,',','')." ".$currency."', value='".$newot_loworderfee."' WHERE orders_id='$parent_orders_id' && class='ot_loworderfee'");
		xtc_db_query("UPDATE ".TABLE_ORDERS_TOTAL." SET text='".number_format($newot_subtotal_no_tax,2,',','')." ".$currency."', value='".$newot_subtotal_no_tax."' WHERE orders_id='$parent_orders_id' && class='ot_subtotal_no_tax'");
	}

	function get_dispute_status_string($id) {
	  /* 0 = Unknown
	   * 1 = Waiting for seller's response
	   * 2 = Waiting for buyer's response
	   * 3 = Closed, FVF credit, strike
	   * 4 = Closed, No FVF credit, strike
	   * 5 = Closed, FVF credit, no strike
	   * 6 = Closed, No FVF credit, no strike
	  */
	   switch($id){
	   		case '0':
	   			$string = 'Unbekannt.';
	   			break;
	   		case '1':
	   			$string = 'Warten auf Antwort des Verk�ufers';
	   			break;
	   		case '2':
	   			$string = 'Warten auf Antwort des K�ufers';
	   			break;
	   		case '3':
	   			$string = 'Geschlossen: Erstattung Geb�hr, K�ufer verwarnt';
	   			break;
	   		case '4':
	   			$string = 'Geschlossen: Keine Erstattung Geb�hr, K�ufer verwarnt';
	   			break;
	   		case '5':
	   			$string = 'Geschlossen: Erstattung Geb�hr, K�ufer keine Verwarnung';
	   			break;
	   		case '6':
	   			$string = 'Geschlossen: Keine Erstattung Geb�hr, Keine Verwarnung an Kunde';
	   			break;
	   }
	   return $string;
	}

	function get_dispute_state_string($id) {
	  /* 0 = Closed
	   * 1 = UPI buyer first response, Pay option
	   * 2 = UPI buyer first response, NoPay option
	   * 3 = UPI buyer first response, Pay option, late response
	   * 4 = UPI buyer first response, NoPay option, late response
	   * 5 = UPI communicate Not Paid
	   * 6 = UPI communicate Have Paid
	   * 7 = UPI pending Resolve
	   * 8 = UPI mutual withdrawal agreement
	   * 9 = UPI mutual withdrawal agreement late
	   */
	   switch( $id ){
	   		case '0':
	   			$string = 'geschlossen';
	   			break;
	   		case '1':
	   			$string = 'Kaeufer muss antworten, Bezahloption';
	   			break;
	   		case '2':
	   			$string = 'Kaeufer muss antworten, keine Bezahloption';
	   			break;
	   		case '3':
	   			$string = 'Kaeufer muss antworten, Bezahloption, verspaetete Antwort';
	   			break;
	   		case '4':
	   			$string = 'Kaeufer muss antworten, keine Bezahloption, verspaetete Antwort';
	   			break;
	   		case '5':
	   			$string = 'Kommunikation: noch Keine Bezahlung';
	   			break;
	   		case '6':
	   			$string = 'Kommunikation: Bezahlung abgeschlossen';
	   			break;
	   		case '7':
	   			$string = 'Offen';
	   			break;
	   		case '8':
	   			$string = 'Beidseitiger Ruecktritt';
	   			break;
	   		case '9':
	   			$string = 'Verspaeteter beidseitiger Ruecktritt';
	   			break;
	   }
	   return $string;
	}


	function get_dispute_reason_string($id){
   		switch($id){
			case '1':
				$string = 'Der Kaeufer hat nicht bezahlt';
				break;
			case '2':
				$string = 'Der Kaeufer und ich haben beschlossen die Bestellung zu stornieren';
				break;
   		}
   		return $string;
	}


	function get_dispute_explanation_string($reason,$dispute_id) {
	  /* Additional information about the reason for the dispute.
	   * When the DisputeReason is 1: "The buyer has not paid for the item," valid values are:
	   * 1 = The buyer has not responded.
	   * 2 = The buyer has refused to pay.
	   * 20 = The buyer requests shipment to a country I don't ship to.
	   * 21 = The buyer requests shipment to an unconfirmed address.
	   * 22 = The buyer requests a payment method that I don't accept.
	   * 23 = the buyer is no longer a registered user.
	   * 13 = Other reason.
	   *
	   * When the DisputeReason is 2: "We have both agreed not to complete the transaction," valid values are:
	   * 5 = The buyer returned the item for a refund.
	   * 12 = We were unable to resolve a disagreement over terms.
	   * 14 = The buyer made a mistake and no longer wants the item.
	   * 21 = The buyer requests shipment to an unconfirmed address.
	   * 22 = The buyer requests a payment method that I don't accept.
	   * 13 = Other reason.
	   */
		$string = '';
	   	if($reason == '1') {
			switch($dispute_id) {
				case '1':
					$string = 'Der Kae�ufer antwortet nicht.';
					break;
				case '2':
				   	$string = 'Der Kaeufer verweigert die Zahlung.';
					break;
				case '20':
				   	$string = 'Der Kaeufer m�chte die Lieferung in ein Land ausserhalb meines Liefergebietes.';
					break;
				case '21':
				   	$string = 'Der Kaeufer hat eine ungueltige Lieferadresse angegeben';
					break;
				case '22':
					$string = 'Der Kaeufer verwendete eine Bezahlmethode die ich nicht akzeptiere';
					break;
				case '23':
					$string = 'Der Kaeufer ist kein registrierter Ebayuser mehr.';
					break;
				case '13':
					$string = 'Anderer Grund.';
					break;
			}
		}else{
			switch($dispute_id) {
				case '5':
					$string = 'Der Kaeufer schickte mir das Produkt zurueck um die Bestellung zu stornieren';
					break;
				case '12':
					$string = 'Wir konnten keine Uebereinstimmungen zu den Bedingungen der Auktion finden.';
					break;
				case '14':
					$string = 'Der Kaeufer m�chte aufgrund eines Irrtums vom Kauf zuruecktreten.';
					break;
				case '21':
					$string = 'Der Kaeufer hat eine ungueltige Lieferadresse angegeben.';
					break;
				case '22':
					$string = 'Der Kaeufer verwendete eine Bezahlmethode die ich nicht akzeptiere.';
					break;
				case '13':
					$string = 'Anderer Grund.';
					break;
			}
		}
		return $string;
	}
	function get_dispute_type_string($id){
		switch($id){
			case '1':
				$string = 'Unbezahlter Artikel';
				break;
		}
		return $string;
	}
	
	function get_german_feedbackcomment_type( $feedbacktype ){
		switch($feedbacktype){
			case 'Positive': return 'Positiv';break;
			case 'Negative': return 'Negativ';break;
			case 'Neutral': return 'Neutral';break;
			case 'Withdrawn': return 'Zur�ckgezogen';break;
		}
	}
	
	function get_bestoffer_accept_check($ebay_id,$qty,$price){
		if(intval($qty) == 1){
			$ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($ebay_id,[
				'bestoffer_price'
			]);
			return ((float)$price >= (float)$ea->bestoffer_price) ? true : false;
		}else{
			$check = yes_query(sprintf(
				"SELECT em.minimumprice,em.quantity FROM ebay_bestoffer_matrix em LEFT JOIN %s ea USING ( ebay_products_id ) WHERE ea.ebay_id=:ebay_id and em.quantity <= :qty ORDER BY em.quantity DESC LIMIT 1",
					TABLE_EBAY_AUCTIONS
				),['ebay_id'=>$ebay_id,'qty'=>intval($qty)],
				true
			);
			return ((float)$check['minimumprice']<=(float)$price and intval($check['quantity']) >= intval($qty)) ? true : false;
		}
	}
	
	function get_bestoffer_matrix($ebay_id){
		$bestoffer_matrix = array();
		
		$ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($ebay_id,[
			'bestoffer_price','ebay_products_id'
		]);
		if($ea !== null and (float)$ea->bestoffer_price > 0){
			$bestoffer_matrix[] = array(
				'ebay_products_id'=>$ea->ebay_products_id,
				'quantity'=>1,
				'minimumprice'=>$ea->bestoffer_price
			);
		}
		
		$matrix_query = xtc_db_query("SELECT em.* FROM ebay_bestoffer_matrix em LEFT JOIN ebay_auctions ea USING ( ebay_products_id ) WHERE ea.ebay_id='".$ebay_id."'");
		while($matrix = xtc_db_fetch_array($matrix_query)){
			$bestoffer_matrix[] = $matrix;
		}
		return $bestoffer_matrix;
	}
	
	function get_bestoffer_proposal($ebay_id,$qty){
		if($qty == 1){
			$ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($ebay_id,[
				'bestoffer_price'
			]);
			if($ea !== null){
				return (float) $ea->bestoffer_price;
			}
		}else{
			$check_query_raw = "SELECT em.minimumprice FROM ebay_bestoffer_matrix em LEFT JOIN ebay_auctions ea USING ( ebay_products_id ) WHERE ea.ebay_id='".$ebay_id."' and em.quantity <= '".$qty."' ORDER BY em.quantity DESC LIMIT 1";
			$check_query = xtc_db_query($check_query_raw);
			$check = xtc_db_fetch_array($check_query);
			return (float)$check['minimumprice'];
		}
		return 0;
	}
	
	function get_ebay_product_bestoffer_matrix_array($id){
		$data['bestoffer_matrixes'] = array();
		$bestoffer_one_query = xtc_db_query("SELECT ebay_bestoffer_price FROM ebay_products WHERE id='".$id."'");
		$bestoffer_one = xtc_db_fetch_array($bestoffer_one_query);
		if($bestoffer_one['ebay_bestoffer_price'] > 0){
			$data['bestoffer_matrixes_num'] = 1;
			$data['bestoffer_matrixes'][] = array('ebay_products_id'=>$id,'quantity'=>1,'minimumprice'=>$bestoffer_one['ebay_bestoffer_price']);
		}
		
		$bestoffer_matrix_query = xtc_db_query("SELECT * FROM ebay_bestoffer_matrix WHERE ebay_products_id='".$id."' ORDER BY quantity");
		$data['bestoffer_matrixes_num'] += xtc_db_num_rows($bestoffer_matrix_query);
		while($bestoffer_matrix = xtc_db_fetch_array($bestoffer_matrix_query)){
			$data['bestoffer_matrixes'][] = $bestoffer_matrix;
		}
		return $data;
	}
	
	function get_ebay_product_template_excludes_array($id){
		$data['template_excludes'] = array();
		$template_excludes_query = xtc_db_query("SELECT * FROM ebay_template_excludes WHERE ebay_products_id='".$id."'");
		$data['template_excludes_num'] = xtc_db_num_rows($template_excludes_query);
		while($template_excludes = xtc_db_fetch_array($template_excludes_query)){
			$data['template_excludes'][] = $template_excludes;
		}
		return $data;
	}
	
	function save_history($id,$comments,$editor_id){
		$history_sql_array = array(
			'ebay_products_id'=>$id,
			'date_saved'=>'now()',
			'comments'=>$comments,
			'editor_id'=>$editor_id
		);
		xtc_db_perform('ebay_products_history',$history_sql_array);
	}
	
	function get_payments($table,$id_field,$id){
		$payments = array();
		if($id_field)
			$query = xtc_db_query("SELECT payment FROM ".$table." WHERE ".$id_field."='".$id."'");
		else
			$query = xtc_db_query("SELECT payment FROM ".$table);
		while($payment = xtc_db_fetch_array($query)){
			$payments[] = $payment['payment'];
		}
		return $payments;
	}
	
	function _is_payment_selected($value,$array){
		if(is_array($array) and sizeOf($array)>0){
			foreach($array as $id=>$val){
				if($value == $val)
					return true;
			}
		}
		return false;
	}
	
	function draw_payments_select($class,$id,$payment_codes){
		$string = '';
		switch($class){
			case 'sammler':
				$saved = $this->get_payments('ebay_sammler_payments','ebay_sammler_id',$id);
				break;
			case 'products':
				$saved = $this->get_payments('ebay_products_payments','ebay_products_id',$id);
				break;
			case 'default':
				$saved = $this->get_payments('ebay_default_payments',false,0);
				break;
		}
		foreach($payment_codes as $k=>$pc){
			$string .= xtc_draw_checkbox_field('payment[]',$pc['id'],$this->_is_payment_selected($pc['id'],$saved)).'&nbsp;'.$pc['id'].'<br>';
		}
		return $string;
	}

	function get_sql_keys($source,$item_id=''){
		$key_array = array();
		switch($source){
			case 'sammler':
				$key_array['table'] = 'ebay_sammler_shippings';
				$key_array['table_id_key'] = 'ebay_sammler_shippings_id';
				$key_array['id_key'] = 'ebay_sammler_id';
				$key_array['id'] = $item_id;
				break;
			case 'ebay_products':
				$key_array['table'] = 'ebay_products_shippings';
				$key_array['table_id_key'] = 'ebay_products_shippings_id';
				$key_array['id_key'] = 'ebay_products_id';
				$key_array['id'] = $item_id;
				break;
			case 'auction':
				$key_array['table'] = 'ebay_auctions_shippings';
				$key_array['table_id_key'] = 'ebay_auctions_shippings_id';
				$key_array['id_key'] = 'ebay_auctions_id';
				$key_array['id'] = $item_id;
				break;
			case 'default':
				$key_array['table'] = 'ebay_default_shippings';
				$key_array['table_id_key'] = 'ebay_default_shippings_id';
				$key_array['id_key'] = '';
				$key_array['id'] = '';
				break;
		}
		return $key_array;
	}
	function get_shippingcosts_count($item_shippingcosts){
		$national = (isset($item_shippingcosts['national'])) ? sizeOf($item_shippingcosts['national']) : 0;
		$international = (isset($item_shippingcosts['international'])) ? sizeOf($item_shippingcosts['international']) : 0;
		return $national+$international;
	}
	function get_shippingcosts_value($source,&$item_shippingcosts,$item_id=false){
		$item_shippingcosts = array();
		$key_array = $this->get_sql_keys($source,$item_id);
		foreach( $this->get_ebayshippings($key_array['table'],$key_array['id_key'],$key_array['id']) as $k=>$shippings ){
			switch($shippings['shippingtype']){
				case 'national':
					$item = array(
						'shipService'=>xtc_db_prepare_input($shippings['ShippingService']),
						'shipFee'=>xtc_db_prepare_input($shippings['ShippingServiceCost']),
						'shipAdditionalFee'=>xtc_db_prepare_input($shippings['ShippingServiceAdditionalCost']),
						'shipsWithinDays'=>$shippings['shipsWithinDays']
					);
					break;
				case 'international':
					$location_array = $this->get_ebayshipping_locations( $table = $key_array['table'].'_locations',$table_id_key = $key_array['table_id_key'],$id = $shippings[ $key_array['table_id_key'] ],$shipIntlWorldwide );
	
					$item = array(
						'shipIntlRegion'=>$location_array,
						'shipIntlWorldwide'=>$shipIntlWorldwide,
						'shipServiceIntl'=>xtc_db_prepare_input($shippings['ShippingService']),
						'shipFeeIntl'=>xtc_db_prepare_input($shippings['ShippingServiceCost']),
						'shipAdditionalFeeIntl'=>xtc_db_prepare_input($shippings['ShippingServiceAdditionalCost'])
					);
					break;
			}
			$item_shippingcosts[$shippings['shippingtype']][] = $item;
		}
	}

	function get_shipping_class($method){
		switch($method){
			case 'DE_COD':
			case 'DE_Nachname':
				return 'cod_cod';
				break;
			default:
				return EBAY_WORKAROUND_SHIPPINGCLASS;
				break;
		}
	}

	function get_ebayshippings($table,$id_key,$id){
//	    printf('<li>get_ebayshippings(%s,%s,%s)',$table,$id_key,$id);
		$shipping_array = array();
		if($id_key and $id)
			$shippings_query_raw = sprintf("SELECT * FROM %s WHERE %s='%s' ORDER BY ShippingServiceCost",$table,$id_key,$id);
		else
			$shippings_query_raw = sprintf("SELECT * FROM %s  ORDER BY ShippingServiceCost",$table);
		$shippings_query = xtc_db_query($shippings_query_raw);
		while($shippings = xtc_db_fetch_array($shippings_query)){
			$shipping_array[] = $shippings;
		}
		return $shipping_array;
	}

	function get_ebayshipping_locations($table,$table_id_key,$id,&$shipIntlWorldwide){
		$shipIntlWorldwide = false;
		$location_array = array();
		$locations_query_raw = sprintf("SELECT location FROM %s WHERE %s='%s'",$table,$table_id_key,$id );
		$locations_query = xtc_db_query($locations_query_raw);
		while($locations = xtc_db_fetch_array($locations_query)){
			if($locations['location'] != 'Worldwide')
				$location_array[] = xtc_db_prepare_input($locations['location']);
			else
				$shipIntlWorldwide = true;
		}
		return $location_array;
	}

	function save_ebayshipping_values($shippingmethods,$source,$id){
			// shippings kopieren
			if(is_array($shippingmethods) and sizeOf($shippingmethods)>0){
				$key_array = $this->get_sql_keys($source,$id);
				// LOESCHE GESPEICHERTE EINTRAEGE
				foreach( $this->get_ebayshippings($key_array['table'],$key_array['id_key'],$key_array['id']) as $k=>$existing ){
					$delete_sql_raw = sprintf("DELETE FROM %s WHERE %s='%s'",$key_array['table'].'_locations',$key_array['table_id_key'],$existing[ $key_array['table_id_key'] ]);
					xtc_db_query($delete_sql_raw);
				}
				$delete_sql_raw = sprintf("DELETE FROM %s WHERE %s='%s'",$key_array['table'],$key_array['id_key'],$key_array['id']);
				xtc_db_query($delete_sql_raw);
		
				// SCHREIBE EINTRAEGE NEU
				for($i=0;$i<3;$i++){
					if(isset($shippingmethods['national'][$i]['shipService']) and xtc_not_null($shippingmethods['national'][$i]['shipService'])){
						$sql_insert_array = array(
							$key_array['id_key']=>$key_array['id'],
							'shippingtype'=>'national',
							'ShippingService'=>$shippingmethods['national'][$i]['shipService'],
							'ShippingServiceAdditionalCost'=>$shippingmethods['national'][$i]['shipAdditionalFee'],
							'ShippingServiceCost'=>$shippingmethods['national'][$i]['shipFee'],
							'shipsWithinDays'=>$shippingmethods['national'][$i]['shipsWithinDays']
						);
						xtc_db_perform($key_array['table'],$sql_insert_array);
					}
				}
				for($i=0;$i<5;$i++){
					if(isset($shippingmethods['international'][$i]['shipServiceIntl']) and xtc_not_null($shippingmethods['international'][$i]['shipServiceIntl'])){
						$sql_insert_array = array(
							$key_array['id_key']=>$key_array['id'],
							'shippingtype'=>'international',
							'ShippingService'=>$shippingmethods['international'][$i]['shipServiceIntl'],
							'ShippingServiceAdditionalCost'=>$shippingmethods['international'][$i]['shipAdditionalFeeIntl'],
							'ShippingServiceCost'=>$shippingmethods['international'][$i]['shipFeeIntl']
						);
						xtc_db_perform($key_array['table'],$sql_insert_array);
						$ship_insert_id = xtc_db_insert_id();
						if(is_array($shippingmethods['international'][$i]['shipIntlRegion']) and sizeOf($shippingmethods['international'][$i]['shipIntlRegion'])>0){
							foreach($shippingmethods['international'][$i]['shipIntlRegion'] as $k=>$region){
								$sql_insert_array = array(
									$key_array['table_id_key']=>$ship_insert_id,
									'location'=>xtc_db_input($region)
								);
								xtc_db_perform($key_array['table'].'_locations',$sql_insert_array);
							}
						}
						if($shippingmethods['international'][$i]['shipIntlWorldwide'] == 1){
							$sql_insert_array = array(
								$key_array['table_id_key']=>$ship_insert_id,
								'location'=>'Worldwide');
								xtc_db_perform($key_array['table'].'_locations',$sql_insert_array);
						}
					}
				}
			}
	}

	function draw_shippingmethods_select($class,$site_id){
		$string = '';
		switch($class){
			case 'default':
				$saved = $this->get_shippingcosts_value($class,$item_shippingcosts);
				break;
		}

		$source = ($_GET['source'])?$_GET['source']:$class; // workaround fuer default

		$codes['national'] = array(0=>array('id'=>'','text'=>TEXT_SELECT));
		$codes['international'] = array(0=>array('id'=>'','text'=>TEXT_SELECT));
		$codes_favorites_query = xtc_db_query("SELECT * FROM ebay_shippingmethods WHERE site='".$site_id."' ORDER BY source");
		while($codes_favorites = xtc_db_fetch_array($codes_favorites_query)){
			$text = ($codes_favorites['name'] != '') ? $codes_favorites['name'] : $codes_favorites['shippingmethod'];
			$codes[ $codes_favorites['source'] ][] = array('id'=>$codes_favorites['shippingmethod'],'text'=>$text);
		}
		/*
		$st = new ShippingServiceCodeType;
		$keys = array_keys(get_class_vars('ShippingServiceCodeType'));
		for($si=7;$si<sizeOf($keys);$si++){
			if(!ereg("^_",$keys[$si]) )
				$codes[] = array('id'=>$keys[$si],'text'=>$keys[$si]);
		}*/
		
		$shipsWithinDays = array(0=>array('id'=>"0",'text'=>"Auswahl Zeitraum"));
		$shipsWithinDays[] = array('id'=>"1",'text'=>'1 Werktag');
		$shipsWithinDays[] = array('id'=>"2",'text'=>'2 Werktage');
		$shipsWithinDays[] = array('id'=>"3",'text'=>'3 Werktage');
		$shipsWithinDays[] = array('id'=>"4",'text'=>'4 Werktage');
		$shipsWithinDays[] = array('id'=>"5",'text'=>'5 Werktage');
		$shipsWithinDays[] = array('id'=>"10",'text'=>'10 Werktage');
		$shipsWithinDays[] = array('id'=>"15",'text'=>'15 Werktage');
		$shipsWithinDays[] = array('id'=>"20",'text'=>'20 Werktage');
		
		if(!xtc_not_null($_GET['source']) and $class != 'default'){
			$messageStack->add_session('Es wurde keine Quelle der Versandkosten &uuml;bergeben. Bitte an den Administrator wenden.','error');
			xtc_redirect('start.php');
		}
		$this->get_shippingcosts_value($source,$item_shippingcosts);
		
		$ships = array();
		for($i=0;$i<3;$i++){
			$ships[] = array('shipService'=>xtc_draw_pull_down_menu('shipService'.$i,$codes['national'],$item_shippingcosts['national'][$i]['shipService']),
					'shipFee'=>xtc_draw_input_field('shipFee'.$i,$item_shippingcosts['national'][$i]['shipFee'],'size="10" maxlength="10"'),
					'shipAdditionalFee'=>xtc_draw_input_field('shipAdditionalFee'.$i,$item_shippingcosts['national'][$i]['shipAdditionalFee'],'size="10" maxlength="10"'),
					'shipsWithinDays'=>xtc_draw_pull_down_menu('shipsWithinDays'.$i,$shipsWithinDays,$item_shippingcosts['national'][$i]['shipsWithinDays'])
			);
		}
		
		$details = $this->get_ebay_details('ShippingLocationDetails');
		foreach($details->ShippingLocationDetails as $type){
		    $keys[] = array(
			'id'=>$type->ShippingLocation,
			'text'=>$type->Description.' ('.$type->ShippingLocation.')'
		    );
		}
		
		$shipsInt = array();
		for($i=0;$i<5;$i++){
			$codesReg = array();
			for($si=0;$si<sizeOf($keys);$si++){
				$checked = false;
				if(!stristr($keys[$si]['text'],'worldwide')){
					if(isset($item_shippingcosts['international'][$i]) and is_array($item_shippingcosts['international'][$i]['shipIntlRegion'])){
						if(in_array($keys[$si]['id'],$item_shippingcosts['international'][$i]['shipIntlRegion'])){
							$checked = true;
						}
					}
					$codesReg[] = xtc_draw_checkbox_field('shipIntlRegion'.$i.'[]',$keys[$si]['id'],$checked).$keys[$si]['text'];
				}
			}
			$shipsInt[] = array('shipIntlRegion'=>$codesReg,
					'shipIntlWorldwide'=>xtc_draw_checkbox_field('Worldwide'.$i,'Worldwide',$item_shippingcosts['international'][$i]['shipIntlWorldwide']).'Worldwide',
					'shipServiceIntl'=>xtc_draw_pull_down_menu('shipServiceIntl'.$i,$codes['international'],$item_shippingcosts['international'][$i]['shipServiceIntl']),
					'shipFeeIntl'=>xtc_draw_input_field('shipFeeIntl'.$i,$item_shippingcosts['international'][$i]['shipFeeIntl'],'size="10" maxlength="10"'),
					'shipAdditionalFeeIntl'=>xtc_draw_input_field('shipAdditionalFeeIntl'.$i,$item_shippingcosts['international'][$i]['shipAdditionalFeeIntl'],'size="10" maxlength="10"')
			);
		}
		$string = xtc_draw_hidden_field('shippingmethods','1').'
		<p><b>Inlandsversandkosten</b> (Bieten Sie bis zu 3 Versandarten an)</p>

		<table cellpadding="3" cellspacing="0" border="0" style="border-style:solid;border-width:1px;" width="100%">
		<tr class="dataTableHeadingRow">
			<td class="dataTableHeadingContent">Versandart</td>
			<td class="dataTableHeadingContent">Kosten</td>
			<td class="dataTableHeadingContent">Jeder weitere Artikel</td>
		</tr>';
		foreach($ships as $k=>$ship){
			$string .= '<tr class="dataTableRow">
			<td valign="top" class="smallText">
			'.$ship['shipService'].'
			</td>
			<td valign="top" class="smallText">
			'.DEFAULT_CURRENCY.' '.$ship['shipFee'].'
			</td>
			<td valign="top" class="smallText">
			'.DEFAULT_CURRENCY.' '.$ship['shipAdditionalFee'].'
			</td>
		</tr>
		<tr class="dataTableRow">
			<td colspan="3" class="smallText">
				Bearbeitungszeit f�r den Inlandsversand
				'.$ship['shipsWithinDays'].'
			</td>
		</tr>
		<tr>
			<td colspan="3" class="main"><image src="images/pixel_trans.gif" border="0" width="1" height="4"></td>
		</tr>';
		}
		$string .= '</table>
		<br>

		<p><b>Internationale Versandkosten</b> (Bieten Sie bis zu 3 Versandarten an)</p>

		<table cellpadding="3" cellspacing="0" border="0" style="border-style:solid;border-width:1px;" width="100%">
		<tr class="dataTableHeadingRow">
			<td class="dataTableHeadingContent">Versandart</td>
			<td class="dataTableHeadingContent">Kosten</td>
			<td class="dataTableHeadingContent">Jeder weitere Artikel</td>
		</tr>';
		foreach($shipsInt as $k=>$ship){
			$string .= '<tr class="dataTableRow">
			<td valign="top" class="smallText">
			'.$ship['shipServiceIntl'].'
			</td>
			<td valign="top" class="smallText">'.DEFAULT_CURRENCY.' '.$ship['shipFeeIntl'].'</td>
			<td valign="top" class="smallText">'.DEFAULT_CURRENCY.' '.$ship['shipAdditionalFeeIntl'].'</td>
		</tr>
		<tr class="dataTableRow">
			<td colspan="3">
				<table border="0" cellspacing="0" cellpadding="4">
				<tr>
					<td valign="top" class="smallText"><b>Nach</b></td>
					<td valign="top">
					<table border="0" cellspacing="0" cellpadding="0">
					<tr>';
			foreach($ship['shipIntlRegion'] as $count=>$region){
				if(($count+1)%3 == 1)
					$string .= '</tr><tr>';
				
				$string .= '<td valign="top" class="smallText" style="white-space: nowrap;">'.$region.'</td>';
			}
			$string .= '</table>
					</td><td valign="top" class="smallText">
					<b>oder</b> '.$ship['shipIntlWorldwide'].'
					</td>
				</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="3" class="main"><image src="images/pixel_trans.gif" border="0" width="1" height="4"></td>
		</tr>';
		}
		$string .= '</table>
		<br>';
		return $string;
	}
	// es muss xtc_get_countries_allocations.inc.php includet werden
	function is_valid_shippingmethod_country($countries_id,$countries_iso_code_2,$region){
		$allocations = xtc_get_countries_allocations($region);
		// region ist kein land sondern kontinent/gruppe
		if(sizeOf($allocations)>0){
			for($i=0;$i<sizeOf($allocations);$i++){
				if($countries_id == $allocations[$i])
					return true;
			}
		// region ist spezielles land
		}else{
			if($region == $countries_iso_code_2)
				return true;
		}
		return false;
	}
	
	function get_UUID($size=32) {
		$next_query = xtc_db_query("SELECT UUID FROM ebay_uuid");
		$next = xtc_db_fetch_array($next_query);
		$next_id = $next['UUID']+1;
		xtc_db_query("UPDATE ebay_uuid SET UUID='".$next_id."'");

		$EMPTYS = 32-strlen(UUID_PREFIX)-strlen($next_id);
		$uuid_str = UUID_PREFIX;
		for($i=0;$i<$EMPTYS;$i++){
			$uuid_str .= '0';
		}
		$uuid_str .= $next_id;
		return $uuid_str;
	}

    public function revise_auction($auction_id,$new_itemtype){
		$ea_obj = \YES4Trade\Model\ebay_auctions::get_by_id(intval($auction_id),[
			'user','site','type'
		]);
    	if($ea_obj === null){
    		return false;
    	}
    	$auction_data = $ea_obj->toArray();
		$ea = new ebay_auction( $auction_id );

        $site_id = $this->get_site_id_from_name($auction_data['site']);
		if(gettype($new_itemtype->Variations) == 'object'){
			$comments_variations = [];
			foreach($new_itemtype->Variations->Variation as $Variation){
				foreach($ea->getVariations() as $eav){
					if($eav->getSKU() == $Variation->SKU){
						$ea_variation_qty = $eav->getQuantity();
					}
				}
				if(!isset($ea_variation_qty)){
					if(gettype($Variation->VariationSpecifics)=='null'){
						throw new Exception('Quantity Revise Variation not found in YES');
					}else{
						// neue Variante in running_auctions hinzufuegen
						$ea_variation_qty = 0; 
					}
				}
				if(gettype($Variation->Delete)!='null' and $Variation->Delete === True){
					// bei loeschen auf 0 setzen
					$comments_variations[ $Variation->SKU ] = sprintf('eBay Quantity Revise Varianten Auction #%s: von %d in %d Stk',
						$ea->getEbayId(),$ea_variation_qty,0
					);
				}else{
					$comments_variations[ $Variation->SKU ] = sprintf('eBay Quantity Revise Varianten Auction #%s: von %d in %d Stk',
						$ea->getEbayId(),$ea_variation_qty,$Variation->Quantity
					);
				}
			}
		}else{
			if($new_itemtype->Quantity !== null){
				$comments = sprintf('eBay Quantity Revise Auction #%s: von %d in %d Stk',
					$ea->getEbayId(), $ea->getQuantity(),intval($new_itemtype->Quantity)
				);
			}
		}

		$ebaycaller = new \YES4Trade\Model\ebaycalls();
		if($auction_data['type'] == 'FixedPriceItem'){
			$callName = 'ReviseFixedPriceItem';
		}else{
			$callName = 'ReviseItem';
		}
		$reviseItem = new \stdClass();
		$reviseItem->Item = $new_itemtype;

		$seller = $auction_data['user'];
		if(self::oauth2_refreshtoken_exists($seller)){
				if(!self::oauth2_usertoken_exists($seller) or self::get_oauth2_usertoken_lifetime($seller) < 1){
					try{
						self::refresh_oauth2_usertoken($seller);
					}catch(Exception $e){
						$api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
					}
				}
		}


		$res = $ebaycaller->tradingQuery(
			$seller,$callName,$site_id,
			json_decode(json_encode($reviseItem), true)
		);
        if($this->isGood($res)){
            if($res->Ack == 'Failure'){
                return implode("<br />",$this->getResponseErrors($res));
            }
            if(isset($comments) and $comments != ''){
                product::add_history_static(intval($ea->getProductsId()), $comments);
            }
            if(isset($comments_variations) and is_countable($comments_variations) and sizeOf($comments_variations)){
                foreach($comments_variations as $pID=>$cv){
                    product::add_history_static(intval($pID), $cv);
                }
            }
            return '';
        }else{
            return implode('<br />',$this->getResponseErrors($res));
        }
        return '';
    }

    function revise_variation_auction($auction_id,$new_itemtype){
		$ea_obj = \YES4Trade\Model\ebay_auctions::get_by_id(intval($auction_id),[
			'user','site','type','status'
		]);
    	if($ea_obj === null or intval($ea_obj->status) !== 0){
    		return false;
    	}
    	$auction_data = $ea_obj->toArray();

		$site_id = $this->get_site_id_from_name($auction_data['site']);

		if($auction_data['type'] == 'FixedPriceItem'){
			$callName = 'ReviseFixedPriceItem';
		}else{
			$callName = 'ReviseItemRequestType';
		}
		$reviseItem = new \stdClass();
		$reviseItem->Item = $new_itemtype;
		$ebaycaller = new \YES4Trade\Model\ebaycalls();

		$seller = $auction_data['user'];
		if(self::oauth2_refreshtoken_exists($seller)){
				if(!self::oauth2_usertoken_exists($seller) or self::get_oauth2_usertoken_lifetime($seller) < 1){
					try{
						self::refresh_oauth2_usertoken($seller);
					}catch(Exception $e){
						$api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
					}
				}
		}


		$res = $ebaycaller->tradingQuery(
			$seller,
			$callName,
			$site_id,
			json_decode(json_encode($reviseItem), true)
		);
		if($this->isGood($res)){
			if($res->Ack == 'Failure'){
				return implode("<br />",$this->getResponseErrors($res));
			}
			return '';
		}else{
			return implode('<br />',$this->getResponseErrors($res));
		}
    }


	function get_products_auction_types($pID){
		return \YES4Trade\Model\ebay_auctions::get_auction_types_and_quantity_by_products_id(intval($pID));
	}

	function get_characteristics($table,$index,$id){
		$characteristics = array();
		$query_raw = sprintf("SELECT * FROM %s WHERE %s='%s'",$table,$index,$id);
		$query = xtc_db_query($query_raw);
		$hide_index = $table.'_id';
		while($row = xtc_db_fetch_array($query)){
			unset($row[$hide_index]);
			unset($row[$index]);
			$characteristics[] = $row;
		}
		return $characteristics;
	}

	function copy_characteristics($characteristics,$target,$index,$target_id){
		if(!is_array($characteristics) or sizeOf($characteristics)==0){
			return false;
		}
		foreach($characteristics as $k=>$insert_sql_array){
			$insert_sql_array[$index] = $target_id;
			xtc_db_perform($target,$insert_sql_array);
		}
	}

	function get_itemspecifics($class,$id=-1,&$item_specifics,$include_recommendations = true){
		switch($class){
			case 'default':
				$table = 'ebay_default_itemspecifics';
				break;
			case 'sammler':
				$table = 'ebay_sammler_itemspecifics';
				$index = 'ebay_sammler_id';
				break;
			case 'ebay_product':
				$table = 'ebay_products_itemspecifics';
				$index = 'ebay_products_id';
				break;
			case 'auction':
				$table = 'ebay_auctions_itemspecifics';
				$index = 'ebay_auctions_id';
				break;
		}
		if($id >= 0){
			$query_raw = sprintf("SELECT * FROM %s WHERE %s='%s' ORDER BY is_name",$table,$index,$id);
		}else{
			$query_raw = sprintf("SELECT * FROM %s ORDER BY is_name",$table);
		}
		$query = xtc_db_query($query_raw);
		while($row = xtc_db_fetch_array($query)){
			$item_specifics[] = array('name'=>xtc_db_prepare_input($row['is_name']),'value'=>xtc_db_prepare_input($row['is_value']));
		}

		// SPEZIAL HANDLING FUER EBAY VORSCHLAEGE
		if($class == 'ebay_product' and $include_recommendations){
			$query = xtc_db_query(sprintf(
				"SELECT * FROM ebay_products_itemspecifics_recommendations WHERE ebay_products_id='%s'",
				$id
			));
			while($row = xtc_db_fetch_array($query)){
				$item_specifics[] = array('name'=>xtc_db_prepare_input($row['is_name']),'value'=>xtc_db_prepare_input($row['is_value']));
			}
		}
	}

	function get_itemspecifics_recommendations($id,$mode = 'ebay_product'){
		$item_specifics = array();
		switch($mode){
			case 'ebay_product':
				$query = xtc_db_query(sprintf(
					"SELECT * FROM ebay_products_itemspecifics_recommendations WHERE ebay_products_id='%s'",
					$id
				));
				break;
			case 'sammler':
				$query = xtc_db_query(sprintf(
					"SELECT * FROM ebay_sammler_itemspecifics_recommendations WHERE ebay_sammler_id='%s'",
					$id
				));
				break;
		}
		while($row = xtc_db_fetch_array($query)){
			$item_specifics[] = array('name'=>xtc_db_prepare_input($row['is_name']),'value'=>xtc_db_prepare_input($row['is_value']));
		}
		return $item_specifics;
	}

	function draw_itemspecifics_select($class,$id=0,$array_id = -1){
		$string = '';
		switch($class){
			case 'default':
				$this->get_itemspecifics($class,-1,$item_specifics);
				break;
			case 'sammler':
				$this->get_itemspecifics($class,$id,$item_specifics);
				break;
			case 'ebay_product':
				$this->get_itemspecifics($class,$id,$item_specifics,false);
				break;
			case 'auction':
				$this->get_itemspecifics($class,$id,$item_specifics);
				break;
		}
                if(is_countable($item_specifics)){
                    for($i=0;$i<sizeOf($item_specifics);$i++){
                            $string .= '			<ul class="clear_block" id="'.$i.'">'.
                                            '				<li class="clear"><img src="images/minus.gif" align="left" border="0" class="remove_itemspecific" />&nbsp;'.EBAY_ITEMSPECIFICS_NAME.'<br /><input name="is_name_'.$i.(($array_id >= 0)?'['.$array_id.']' : '').'" size="30" maxlength="64" type="text" value="'.htmlspecialchars($item_specifics[$i]['name']).'" /></li><br clear="all" />'.
                                            '				<li class="clear">'.EBAY_ITEMSPECIFICS_VALUE.'<br /><input name="is_value_'.$i.(($array_id >= 0)?'['.$array_id.']' : '').'" size="30" maxlength="255" type="text" value="'.htmlspecialchars($item_specifics[$i]['value']).'" /></li>'.
                                            '			</ul><br clear="all" />';
                    }
                }
		if($array_id < 0){
			$string .= '<script type="text/javascript">moreFieldsHandlerCounter = '.$i.';</script>';
		}else{
			$string .= '<script type="text/javascript">moreFieldsHandlerArrayCounter[\'NR'.$array_id.'\'] = '.$i.';</script>';
		}
		$string .= '<input type="hidden" name="save_itemspecifics" value="1" /><a href="javascript:void(moreFieldsHandler'.(($array_id >= 0)?'Array':'').'(\'is_readroot\',\'is_writeroot\''.(($array_id >= 0) ? ','.$array_id : '').'));"><img src="images/plus.gif" border="0" /></a>';
		$string .= '<span id="is_writeroot"></span>';
		$string .= '<div id="is_readroot" style="display:none;border:0px;padding-left:0px;margin-left:0px;background-color: #CEEAFF;">'.
					'			<ul class="clear_block">'.
					'				<li class="clear">'.EBAY_ITEMSPECIFICS_NAME.'<br /><input name="is_name'.(($array_id >= 0)?'['.$array_id.']' : '').'" size="30" maxlength="64" type="text"></li><br clear="all" />'.
					'				<li class="clear">'.EBAY_ITEMSPECIFICS_VALUE.'<br /><input name="is_value'.(($array_id >= 0)?'['.$array_id.']' : '').'" size="30" maxlength="255" type="text"></li>'.
					'			</ul>'.
					'	<br clear="all"/>'.
					'	<a onclick="removeFieldsHandler(this.parentNode);"><img src="images/icons/cross.gif" border="0" /></a>'.
					'	</div>';
		return $string;
	}

	function get_api_errors($cs,$res){
		$error_msg = '<div class=\"main\">';
                foreach($res->getErrors() as $err){
                    $errps = array();
                    foreach($err->getErrorParameters() as $errp){
                        $errps[] = sprintf("%s: %s",$errp->getValue(),current($errp->attributeValues));
                    }
                    $error_msg .= sprintf("<b>%s</b><br />%s<br /><font color=\"red\">%s</font><br /><font style=\"size: 0.8em;color: #666;\">%s Code: %s</font><br /><br />",
                            $err->getShortMessage(),
                            $err->getLongMessage(),
                            implode(', ',$errps),
                            $err->getErrorClassification(),
                            $err->getErrorCode());
                }
		return html_entity_decode($error_msg.'</div>');
	}

	/**
	 * Aktualisiert den Status in Tabelle ebay_auctions wenn eine Auktion von Hand
	 * beendet wurde. 
         * 
         * Fuer die specials_ebay_revise Funktionalitaet wird ausserdem der
         * Eintrag in der Tabelle specials_ebay_revise entfernt
	 *
	 * @param string $ebay_auctions_id
	 */
	function set_end_auction($ebay_auctions_id){
		\YES4Trade\Model\ebay_auctions::update_ebay_auction([
			'status'=>2,
			'id'=>intval($ebay_auctions_id)
		]);
		\YES4Trade\Model\ebay_auctions_price_revise_auctions::delete_by_ebay_auctions_id(intval($ebay_auctions_id));
		xtc_db_query(sprintf(
			"DELETE FROM specials_ebay_revise WHERE ebay_auctions_id='%s'",
			$ebay_auctions_id
		));
	}
	
	public function set_outofstock($auction_id,$variation_sku = Null){
		$record = $this->_getTimerAuctionDetails($auction_id);
		$ebay_id = $record['ebay_id'];
		$ebaycalls = new \YES4Trade\Model\ebaycalls();
		$is = [
			'ItemID' => $ebay_id,
			'Quantity' => 0
		];
		if($variation_sku !== Null) {
			$is['SKU'] = $variation_sku;
		}else{
			if($record['status'] != 0){
				return array(
					'text'=>sprintf(YES_TEXT_HISTORY_AUCTION_ALWAYS_CANCELLED,$ebay_id),
					'status'=>'error'
				);
			}
		}
		$body = [
			'InventoryStatus'=>[$is]
		];
		$seller = $record['user'];
		if(self::oauth2_refreshtoken_exists($seller)){
				if(!self::oauth2_usertoken_exists($seller) or self::get_oauth2_usertoken_lifetime($seller) < 1){
					try{
						self::refresh_oauth2_usertoken($seller);
					}catch(Exception $e){
						$api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
					}
				}
		}
		$res = $ebaycalls->tradingQuery($seller,
			'ReviseInventoryStatus',
			$this->get_site_id_from_name($record['site']),
			$body
		);
		if($this->isGood($res)){
		    return array('text'=>'','status'=>'success');
		}else{
		    $error = implode('<br />',$this->getResponseErrors($res));
		    return array('text'=>$error,
				'status'=>'error',
				'error_code'=>0
		    );
		}
	}

	function ebay_end_auction($auction_id){
		$record = $this->_getTimerAuctionDetails($auction_id);
		$ebay_id = $record['ebay_id'];
		$products_id = $record['products_id'];
		if($record['status'] != 0){
			return array('text'=>sprintf(YES_TEXT_HISTORY_AUCTION_ALWAYS_CANCELLED,$ebay_id),'status'=>'error');
		}

		// NEUES HANDLING -> select_set_multiple
		if($products_id > 0){
			$einstellmenge = $record['quantity']+$record['revise_counter'];
		}
		if($ebay_id != ''){
			$ebaycalls = new \YES4Trade\Model\ebaycalls();
			$seller = $record['user'];
			if(self::oauth2_refreshtoken_exists($seller)){
					if(!self::oauth2_usertoken_exists($seller) or self::get_oauth2_usertoken_lifetime($seller) < 1){
						try{
							self::refresh_oauth2_usertoken($seller);
						}catch(Exception $e){
							$api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
						}
					}
			}
			$res = $ebaycalls->tradingQuery($seller,
				'GetItem',
				$this->get_site_id_from_name($record['site']),
				[
					'ItemID'=>$ebay_id
				]
			);
			$bids = 0;
			$auction_status = '';
			if($this->isGood($res)){
				$itemR = $res->Item;
				$sellingStatus = $itemR->SellingStatus;
				$bids = $sellingStatus->BidCount;
				$auction_status = $sellingStatus->ListingStatus;
				$sold = (int)$sellingStatus->QuantitySold;
			}else{
				/**
				 * wir brauchen trotzdem den wert "sold" - da vertrauen wir
				 * auf unseren DB wert aus ebay_auctions
				 */
				$sold = (int)$record['revise_counter'];
			}
			$yes_ended = false;
			// HIER ZB SIND DIE DURCH EBAY BEENDETEN AUKTIONEN
			if($auction_status == 'Completed'){
				switch($record['type']){
					case 'StoresFixedPrice':
					case 'FixedPriceItem':
						$yes_ended = true;
						$auction_products = $this->get_auction_variationset_products($auction_id);
						$this->set_end_auction($auction_id);
						if(sizeOf($auction_products)){
							for($vpi=0;$vpi<sizeOf($auction_products);$vpi++){
								$variation_update_qty = $auction_products[$vpi]['quantity'];
								$staffel_comment = '';
								if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
									$ea = new ebay_auction($auction_id);
									if($ea->has_staffelpreise()){
										$variation_update_qty = $variation_update_qty*$ea->get_staffelpreis_quantity_from_sku($auction_products[$vpi]['sku']);
										$staffel_comment = ' Staffelpreis Menge '.$ea->get_staffelpreis_quantity_from_sku($auction_products[$vpi]['sku']);
									}
								}
								yes_update_products_in_auction_quantity($auction_products[$vpi]['products_id'],
									yes_products_calc_in_auction_quantity(intval($auction_products[$vpi]['products_id'])), 
									sprintf(YES_TEXT_SQ_CANCEL_AUCTION,$ebay_id,$variation_update_qty)
										.$staffel_comment,
									true // overwrite!
								);
							}
						}else{
								yes_update_products_in_auction_quantity($products_id,
									yes_products_calc_in_auction_quantity(intval($products_id)), 
									sprintf(YES_TEXT_SQ_CANCEL_AUCTION,$ebay_id,$record['quantity']),
									true // overwrite
								);
						}

						if(intval(constant('EBAY_PRODUCTS_HISTORY')) == 1){
							$this->save_history($record['ebay_products_id'],sprintf(YES_TEXT_HISTORY_AUCTION_CANCEL,$ebay_id),$_SESSION['customer_id']);
						}
						return array(
							'text'=>sprintf(YES_TEXT_HISTORY_AUCTION_CANCEL,$ebay_id),
							'status'=>'success'
						);
						break;
				}
			}
			if(!$yes_ended){
				if($bids == 0){
					$ebaycalls = new \YES4Trade\Model\ebaycalls();

					$seller = $record['user'];
					if(self::oauth2_refreshtoken_exists($seller)){
							if(!self::oauth2_usertoken_exists($seller) or self::get_oauth2_usertoken_lifetime($seller) < 1){
								try{
									self::refresh_oauth2_usertoken($seller);
								}catch(Exception $e){
									$api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
								}
							}
					}

					$res = $ebaycalls->tradingQuery($seller,
						'EndItem',
						$this->get_site_id_from_name($record['site']),
						[
							'ItemID'=>$ebay_id,
							'EndingReason'=>'Incorrect'
						]
					);
					if($this->isGood($res)){
						switch($record['type']){
							case 'StoresFixedPrice':
							case 'FixedPriceItem':
								$auction_products = $this->get_auction_variationset_products($auction_id);
								$this->set_end_auction($auction_id);
								if(is_countable($auction_products) and sizeOf($auction_products)){
									for($vpi=0;$vpi<sizeOf($auction_products);$vpi++){
										$variation_update_qty = $auction_products[$vpi]['quantity'];
										$staffel_comment = '';
										if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
											$ea = new ebay_auction($auction_id);
											if($ea->has_staffelpreise()){
												$variation_update_qty = $variation_update_qty*$ea->get_staffelpreis_quantity_from_sku($auction_products[$vpi]['sku']);
												$staffel_comment = ' Staffelpreis Menge '.$ea->get_staffelpreis_quantity_from_sku($auction_products[$vpi]['sku']);
											}
										}
										yes_update_products_in_auction_quantity($auction_products[$vpi]['products_id'],
											yes_products_calc_in_auction_quantity(intval($auction_products[$vpi]['products_id'])),
											sprintf(YES_TEXT_SQ_CANCEL_AUCTION,$ebay_id,$variation_update_qty)
												.$staffel_comment,
											true // overwrite!
										);
									}
								}else{
									yes_update_products_in_auction_quantity($products_id,
										yes_products_calc_in_auction_quantity(intval($products_id)),
										sprintf(YES_TEXT_SQ_CANCEL_AUCTION,$ebay_id,$record['quantity']),
										true // overwrite
									);
								}
								break;
						}

						if(intval(constant('EBAY_PRODUCTS_HISTORY')) == 1){
							$this->save_history($record['ebay_products_id'],
								sprintf(YES_TEXT_HISTORY_AUCTION_CANCEL,$ebay_id),
								$_SESSION['customer_id']
							);
						}
						return array(
							'text'=>sprintf(YES_TEXT_HISTORY_AUCTION_CANCEL,$ebay_id),
							'status'=>'success'
						);
					}else{
						$error = current($res->Errors);
						switch($error->ErrorCode){
							case '1047':
								break;
							case '17':
								$auction_products = $this->get_auction_variationset_products($auction_id);
								$this->set_end_auction($auction_id);
								if(sizeOf($auction_products)){
									for($vpi=0;$vpi<sizeOf($auction_products);$vpi++){
										$variation_update_qty = $auction_products[$vpi]['quantity'];
										$staffel_comment = '';
										if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
											$ea = new ebay_auction($auction_id);
											if($ea->has_staffelpreise()){
												$variation_update_qty = $variation_update_qty*$ea->get_staffelpreis_quantity_from_sku($auction_products[$vpi]['sku']);
												$staffel_comment = ' Staffelpreis Menge '.$ea->get_staffelpreis_quantity_from_sku($auction_products[$vpi]['sku']);
											}
										}
										yes_update_products_in_auction_quantity($auction_products[$vpi]['products_id'],
											yes_products_calc_in_auction_quantity(intval($auction_products[$vpi]['products_id'])), 
											sprintf(YES_TEXT_SQ_CANCEL_AUCTION,$ebay_id,$variation_update_qty)
												.$staffel_comment,
											true // overwrite!
										);
									}
								}else{
									yes_update_products_in_auction_quantity($products_id,
											yes_products_calc_in_auction_quantity(intval($products_id)), 
											sprintf(YES_TEXT_SQ_CANCEL_AUCTION,$ebay_id,$record['quantity']),
											true // overwrite!
									);
								}
								break;
						}
						return array(
							'text'=>$this->getResponseErrors($res),
							'status'=>'error',
							'error_code'=>$error->ErrorCode
						);
					}
				}else{
					return array(
						'text'=>sprintf(YES_TEXT_MESSAGE_AUCTION_CANCEL_ERROR,$ebay_id),
						'status'=>'error'
					);
				}
			}
		}else{
			return array(
				'text'=>YES_TEXT_MESSAGE_NO_AUCTION_FOUND,
				'status'=>'error'
			);
		}
	}

        
	function set_auction_lock($id,$lock_status){
		if(intval($id)>0){
			\YES4Trade\Model\ebay_auctions::update_ebay_auction([
				'locked'=>intval($lock_status),
				'id'=>intval($id)
			]);
			return true;
		}
		return false;
	}

	function set_ebay_products_lock($id, $lock_status,$lock_timer = false){
		if(xtc_not_null($id)){
			xtc_db_query(sprintf("UPDATE ebay_products SET locked='%s' WHERE id='%s'",
					$lock_status,$id
			));
			if($lock_timer){
				// gibt keine timer mehr ...
			}
			return true;
		}
		return false;
	}

	function get_iso2_from_ebay_countryname($value){
            if(!function_exists('yes_get_iso2_from_ebay_countryname')){
                require_once(DIR_FS_INC.'yes_get_iso2_from_ebay_countryname.inc.php');
            }
            return yes_get_iso2_from_ebay_countryname($value);
	}

	/**
	 * Wir erhalten in den ebay transactions meistens "Invalid Request" bei der
	 * Telefonnummer. Diese fangen wir hier ab und speichern dann ''
	 *
	 * @param string $value
	 * @return string
	 */
	public static function get_phone_number_from_transactionrecord($value){
		if(empty($value) or $value == 'Invalid Request')
			return '';
		return $value;
	}
	
	public static function get_variationset_products($ebay_products_id){
		$products = array();
		$query = xtc_db_query(sprintf(
			"SELECT products_id, quantity,ev.sku FROM ebay_variations ev LEFT JOIN ebay_variations_sets evs USING(ebay_variations_sets_id) WHERE evs.ebay_products_id='%s'",
			$ebay_products_id
		));
		while($record = xtc_db_fetch_array($query)){
			$products[] = $record;
		}
		return $products;
	}

	public static function get_auction_variationset_products($ebay_auctions_id){
		$products = array();
		$eav_list = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id(intval($ebay_auctions_id),[
			'products_id', 'quantity','quantity_sold','sku','price','ean','isbn'
		]);
		foreach($eav_list as $eav){
			$products[] = $eav->toArray();
		}
		return $products;
	}

	public static function get_products_status($pID){
		$query = xtc_db_query(sprintf(
			"SELECT products_status FROM products WHERE products_id='%s'",
			$pID
		));
		$record = xtc_db_fetch_array($query);
		return (int)$record['products_status'];
	}
	
	function get_ebay_product_running_auctions_num($ebay_products_id){
	    
	}

    function get_ebay_details($detail_name='',$ebay_user = EBAY_USER, $site_name = EBAY_SITE){
		$ebaycalls = new \YES4Trade\Model\ebaycalls();
		$seller = $ebay_user;
		if(self::oauth2_refreshtoken_exists($seller)){
				if(!self::oauth2_usertoken_exists($seller) or self::get_oauth2_usertoken_lifetime($seller) < 1){
					try{
						self::refresh_oauth2_usertoken($seller);
					}catch(Exception $e){
						$api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
					}
				}
		}

		return $ebaycalls->tradingQuery(
			$seller,
			'GeteBayDetails',
			$this->get_site_id_from_name($site_name),
			['DetailName'=>$detail_name]
		);
    }
    

    /**
     * Habe die Funktion rausgeschmissen, da eh keiner mehr libri verwendet
     * 05/2020
     */
    public function ebay_add_item_from_ebay_product( $ep ){
    }
    
    public function get_ebay_auction_variation_sku($ebay_id,$products_id){
	$query = xtc_db_query(sprintf(
		"SELECT eav.sku FROM ebay_auctions ea LEFT JOIN ebay_auctions_variations eav ON ea.id=eav.ebay_auctions_id WHERE ea.ebay_id='%s' and eav.products_id='%s'",
		$ebay_id,$products_id
	));
	$record = xtc_db_fetch_array($query);
	return $record['sku'];
    }
    
    public function is_ebay_mpn_alias($mpn,$site_id){
	$cache = true;
	$lifetime = 60*60*24;
	$query = yes_db_query(sprintf(
		"SELECT mpn_alias FROM ebay_mpn_aliases WHERE site='%s'",
		$site_id
	), $cache, $lifetime);
	foreach($query as $row){
	    if($row['mpn_alias'] == $mpn){
		return true;
	    }
	}
	return false;
    }
    
    public function get_ebay_mpn_default_name($site_id,$category_id){
	$cache = true;
	$lifetime = 60*60*24;
	$first_entry = ''; // falls kein default gesetzt ist
	$query = xtc_db_query(sprintf(
		"SELECT mpn_alias FROM ebayapi_favorites WHERE favorite_ebayid='%s' AND site='%s' AND mpn_alias != ''",
		$category_id,$site_id
	));
	if(xtc_db_num_rows($query)){
	    $record = xtc_db_fetch_array($query);
	    return $record['mpn_alias'];
	}
	$query = yes_db_query(sprintf(
		"SELECT mpn_alias,is_default FROM ebay_mpn_aliases WHERE site='%s'",
		$site_id
	), $cache, $lifetime);
	foreach($query as $row){
	    if($first_entry == '')
		$first_entry = $row['mpn_alias'];
	    if($row['is_default'] == 1)
		return $row['mpn_alias'];
	}
	return $first_entry;
    }

    public function is_ebay_brand_alias($brand,$site_id){
	$cache = true;
	$lifetime = 60*60*24;
	$query = yes_db_query(sprintf(
		"SELECT brand_alias FROM ebay_brand_aliases WHERE site='%s'",
		$site_id
	), $cache, $lifetime);
	foreach($query as $row){
	    if($row['brand_alias'] == $brand){
		return true;
	    }
	}
	return false;
    }
    
    public function get_ebay_brand_default_name($site_id,$category_id){
	$cache = true;
	$lifetime = 60*60*24;
	$first_entry = ''; // falls kein default definiert ist
	$query = xtc_db_query(sprintf(
		"SELECT brand_alias FROM ebayapi_favorites WHERE favorite_ebayid='%s' AND site='%s' AND brand_alias != ''",
		$category_id,$site_id
	));
	if(xtc_db_num_rows($query)){
	    $record = xtc_db_fetch_array($query);
	    return $record['brand_alias'];
	}
	$query = yes_db_query(sprintf(
		"SELECT brand_alias,is_default FROM ebay_brand_aliases WHERE site='%s'",
		$site_id
	), $cache, $lifetime);
	foreach($query as $row){
	    if($first_entry == '')
		$first_entry = $row['brand_alias'];
	    if($row['is_default'] == 1)
		return $row['brand_alias'];
	}
	return $first_entry;
    }
    
    public function draw_seller_profile_select($class,$name,$default){
	$ebay_user = xtc_get_ebay_users();
	$return = array(array('id'=>'','text'=>TEXT_SELECT));
	foreach($ebay_user as $user){
	    $query = xtc_db_query(sprintf("SELECT * FROM ebay_seller_profiles WHERE ebay_user='%s' AND ProfileType='%s'",
		    $user['id'],strtoupper($class)
	    ));
	    while($record = xtc_db_fetch_array($query)){
		$return[] = array(
		    'id'=>$record['ProfileID'],
		    'text'=>$record['ProfileID'].': '.$record['ProfileName'].' ('.$user['id'].')'
		);
	    }
	}
	return xtc_draw_pull_down_menu($name,$return,$default);
    }

    public function get_picture_details($pID,$epID,$gallerypic,$gallery,$gallery_plus,$galleryfeaturedduration,$galleryfeatured,$external_product_id){
        $e_pictureurl = $this->get_e_pictureurl($gallerypic);
        $mo_pics = $this->get_mo_pics($gallerypic, $pID, $epID);
		$pics = new \stdClass();
		
        if($gallery == 1){
            if(defined('EBAY_EXTERNAL_PRODUCTS_ID_USE_NO_GALLERY_PIC') and EBAY_EXTERNAL_PRODUCTS_ID_USE_NO_GALLERY_PIC == 'True' and $external_product_id != '' && EBAY_AUTOMATIC_ISBN == 'true'){
                // keine uebergabe von bildern
                $pics->GalleryType = 'Gallery';
            }else{
                $pics->GalleryType = 'Gallery';
                $pics->PictureURL[] = $e_pictureurl;
                foreach($mo_pics as $kmop=>$mop){
                    $pics->PictureURL[] = $mop;
                }
            }
        }else if($gallery_plus == 1){
            // PREMIUM ANGEBOT
            if(defined('EBAY_EXTERNAL_PRODUCTS_ID_USE_NO_GALLERY_PIC') and EBAY_EXTERNAL_PRODUCTS_ID_USE_NO_GALLERY_PIC == 'True' and $external_product_id != '' && EBAY_AUTOMATIC_ISBN == 'true'){
                // keine uebergabe von bildern
                $pics->GalleryType = 'Plus';
            }else{
                $pics->GalleryType = 'Plus';
                $pics->GalleryURL = $e_pictureurl;
                $pics->PictureURL[] = $e_pictureurl;
                foreach($mo_pics as $kmop=>$mop){
                    $pics->PictureURL[] = $mop;
                }
            }
        }else{
            if(defined('EBAY_EXTERNAL_PRODUCTS_ID_USE_NO_GALLERY_PIC') and EBAY_EXTERNAL_PRODUCTS_ID_USE_NO_GALLERY_PIC == 'True' and $external_product_id != '' && EBAY_AUTOMATIC_ISBN == 'true'){
                // keine uebergabe von bildern
            }else{
                $pics->PictureURL[] = $e_pictureurl;
                foreach($mo_pics as $mop){
                    $pics->PictureURL[] = $mop;
                }
            }
        }
        return $pics;
    }
    
    private function get_e_pictureurl($gallerypic){
        if(stristr($gallerypic,'http://')) {
                return $gallerypic;
        }else{
                return (!empty($gallerypic)) ? HTTP_SERVER.'images/product_images/'.EBAY_AUCTION_IMAGE_PATH.'/' . $gallerypic : '';
        }
    }
    
    private function get_gal_url($gallerypic){
        if(stristr($gallerypic,'http://')) {
                return $gallerypic;
        }
        $url = (!empty($gallerypic)) ? HTTP_SERVER.'images/product_images/'.EBAY_AUCTION_IMAGE_PATH.'/' . $gallerypic : '';
        if(EXTERN_EBAYPICTURE_SERVER == 1){
            return $url;
        }
        if($this->check_image_exists($gallerypic)){
                return HTTP_SERVER.'images/product_images/'.EBAY_AUCTION_IMAGE_PATH.'/'.$gallerypic;
        }else{
                return $url;
        }
    }
    
    private static function check_image_exists($img){
        if(strstr(strtolower($img),'http')){
            return true;
        }
        return is_file(DIR_FS_CATALOG.'images/product_images/'.EBAY_AUCTION_IMAGE_PATH.'/'.$img);
    }
    
    private function get_mo_pics($_GALLERYPIC,$pID,$epID){
        // BOF MORE PICTURE URLS - TICKET 1675
        $http_img_basepath = HTTP_SERVER.'images/product_images/'.EBAY_AUCTION_IMAGE_PATH.'/';
        $mo_pics = array();
        $pic_double = $this->get_pics_double($pID,true);
        if(!sizeOf($pic_double)){
            return $mo_pics;
        }
        $evsID = $this->get_ebay_variations_sets_id_from_ebay_products_id($epID);
        if($evsID > 0){
		// BEI VARIANTENAUKTIONEN SOLL LAUT VORGABEN VON BURAK KEINE SAMMLERPRODUKT
		// EIGENEN ARTIKELBILDER MEHR AN EBAY UEBERGEBEN WERDEN
		// DAS HAT ZUR FOLGE DAS AUCH KEIN GALLERYFEATURED MEHR UEBERGEBEN WIRD
		// TROTZ BEDENKEN MUSSTE ICH ES SO EINBAUEN - Ticket 2601
		return array();
	}

        // EOF - Variantenbilder
        foreach($pic_double as $mop){
            if($mop == $_GALLERYPIC) {
                continue;
            }
            // BOF - TEMPLATE EXCLUDE PICTURES - ticket 1785
            if($this->has_image_template_exclude($epID,$mop)){
                continue;
            }
            // EOF - TEMPLATE EXCLUDE PICTURES - ticket 1785
            if($this->check_image_exists($mop)){
                if(strstr(strtolower($mop),'http')){
                    $mo_pics[] = $mop;
                }else{
                    $mo_pics[] = HTTP_SERVER.'images/product_images/'.EBAY_AUCTION_IMAGE_PATH.'/'.$mop;
                }
            }
        }
        return $mo_pics;
        // EOF MORE PICTURE URLS - TICKET 1675
    }

    /**
     * Weiss nicht genau wozu das mal angedacht war. Diese Funktion liefert ein
     * Array zurueck welches alle Produktbilder enthaelt. Dabei ist keins 
     * doppelt vorhanden
     * 
     * @param int $pID products_id
     * @param int $epID sammlerprodukt id
     */
    private function get_pics_double($pID){
        $pic_double = array();
        $pic_query = xtc_db_query("SELECT image_name FROM products_images WHERE products_id='".$pID."' order by image_nr");
        while($pics = xtc_db_fetch_array($pic_query)){
                if(!in_array($pics["image_name"],$pic_double) ){
                        $pic_double[] = $pics["image_name"];
                }
        }
        return $pic_double;
    }
    
    private static function has_image_template_exclude($epID,$img){
        if($epID == 0){
            return false;
        }
        $q = xtc_db_query("SELECT id FROM ebay_template_excludes WHERE ebay_products_id='".$epID."' && pic='".$img."'");
        if(xtc_db_num_rows($q)){
            return true;
        }
        return false;
    }
    
    /**
     * Wenn eine ID groesse 0 zurueckgegeben wird, ist gleichzeitig geprueft
     * ob es ein Variantenset ist
     * 
     * @param int $epID Sammlerprodukt ID
     */
    public static function get_ebay_variations_sets_id_from_ebay_products_id($epID){
        $query = yes_db_query(sprintf(
                "SELECT ebay_variations_sets_id FROM ebay_variations_sets WHERE ebay_products_id='%s'",
                $epID
        ));
        if(!yes_db_num_rows($query)){
            return 0;
        }
        $record = current($query);
        return $record['ebay_variations_sets_id'];
    }
    
    private static function get_variations_sets_pictures_base_title($ebay_variations_sets_id){
        $query = xtc_db_query(sprintf(
                "SELECT nvl_name FROM ebay_variationspecificssets WHERE ebay_variations_sets_id='%s' ORDER BY variations_pictures_base DESC LIMIT 1",
                $ebay_variations_sets_id
        ));
        $record = xtc_db_fetch_array($query);
        return xtc_db_prepare_input($record['nvl_name']);
    }
    
    /**
     * gibt ein Array aller URLs zurueck fuer ein ebay_variations_pictures_set
     * @param int $ebay_variations_pictures_sets_id ebay_variations_pictures_sets_id
     * @return Array
     */
    private static function get_ebay_variations_pictures_sets_urls($ebay_variations_pictures_sets_id){
        $ebay_variations_pictures_sets_urls_array = array();
        $query = xtc_db_query(sprintf(
                "SELECT PictureURL FROM ebay_variations_pictures_sets_urls WHERE ebay_variations_pictures_sets_id='%s' ORDER BY sort_order,PictureURL",
                $ebay_variations_pictures_sets_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $ebay_variations_pictures_sets_urls_array[] = $record['PictureURL'];
        }
        return $ebay_variations_pictures_sets_urls_array;
    }
    
    private static function get_ebay_variations_pictures_id_array($ebay_variations_sets_id){
        $vp = array();
        $query = xtc_db_query(sprintf(
                "SELECT ebay_variations_pictures_id FROM ebay_variations_pictures WHERE ebay_variations_sets_id='%s'",
                $ebay_variations_sets_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $vp[] = $record['ebay_variations_pictures_id'];
        }
        return $vp;
    }
    
    private static function get_ebay_variations_pictures_sets_array($ebay_variations_pictures_id){
        $vpset = array();
        $query = xtc_db_query(sprintf(
                "SELECT * FROM ebay_variations_pictures_sets WHERE ebay_variations_pictures_id='%s'",
                $ebay_variations_pictures_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $vpset[] = $record;
        }
        return $vpset;
    }

    private static function getVariationSpecificPictureSetType_array_from_VariationSpecificPictureSetArray($VariationSpecificPictureSetArray){
        $VariationSpecificPictureSetType_array = array();
        foreach($VariationSpecificPictureSetArray as $VariationSpecificPictureSet){
			$VariationSpecificPictureSetType = new \stdClass();
			$VariationSpecificPictureSetType->PictureURL = [];
			$VariationSpecificPictureSetType->VariationSpecificValue = $VariationSpecificPictureSet['VariationSpecificValue'];
			foreach($VariationSpecificPictureSet['PictureURL'] as $url){
				if(stristr($url,'http:')){
					$url = str_replace('http:','https:',$url);
				}
				$VariationSpecificPictureSetType->PictureURL[] = $url;
			}
			$VariationSpecificPictureSetType_array[] = $VariationSpecificPictureSetType;
        }
        return $VariationSpecificPictureSetType_array;
    }
    
    public function get_variation_pictures_type($vpictures_array){
		$PicturesType = new \stdClass();
        $VariationSpecificName = current(array_keys($vpictures_array));
        $PicturesType->VariationSpecificName = $VariationSpecificName;
        foreach($vpictures_array as $VariationSpecificPictureSetArray){
            $VariationSpecificPictureSetType_array = $this->getVariationSpecificPictureSetType_array_from_VariationSpecificPictureSetArray($VariationSpecificPictureSetArray);
            if(sizeOf($VariationSpecificPictureSetType_array)){
                $PicturesType->VariationSpecificPictureSet = $VariationSpecificPictureSetType_array;
            }
        }
        return $PicturesType;
    }
    
    public function get_variations_pictures_array_from_ebay_variations_sets_id($ebay_variations_sets_id){
        $vpictures_array = array();
        $vpss_merkmal = $this->get_variations_sets_pictures_base_title($ebay_variations_sets_id);
        $_vp = $this->get_ebay_variations_pictures_id_array($ebay_variations_sets_id);
        $VariationSpecificPictureSets = array();
        foreach($_vp as $evpID){
            $vpset = $this->get_ebay_variations_pictures_sets_array($evpID);
            foreach($vpset as $vps){
                $VariationSpecificPictureSet = array(
                    'VariationSpecificValue' => xtc_db_prepare_input($vps['VariationSpecificValue'])
                );
                $ebay_variations_pictures_sets_urls = $this->get_ebay_variations_pictures_sets_urls($vps['ebay_variations_pictures_sets_id']);
                if(!sizeOf($ebay_variations_pictures_sets_urls)){
                    continue;
                }
                $VariationSpecificPictureSet['PictureURL'] = $ebay_variations_pictures_sets_urls;
                $VariationSpecificPictureSets[] = $VariationSpecificPictureSet;
            }
        }
        if(!sizeOf($VariationSpecificPictureSets)){
            return $vpictures_array;
        }
        $vpictures_array[ $vpss_merkmal ] = $VariationSpecificPictureSets;
        return $vpictures_array;
    }
    
    public function getItemCall($ebay_id, $ebay_user, $site, $outputselector=''){
		$site_id = $this->get_site_id_from_name($site);
		$body = [
			'ItemID' => $ebay_id,
		];
		if($outputselector != ''){
			if(strstr($outputselector,'ItemSpecifics')){
				$body['IncludeItemSpecifics'] = true;
			}
			$body['OutputSelector'] = $outputselector;
		}
		$ebaycalls = new \YES4Trade\Model\ebaycalls();
		$seller = $ebay_user;
		if(self::oauth2_refreshtoken_exists($seller)){
				if(!self::oauth2_usertoken_exists($seller) or self::get_oauth2_usertoken_lifetime($seller) < 1){
					try{
						self::refresh_oauth2_usertoken($seller);
					}catch(Exception $e){
						$api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
					}
				}
		}
		$res = $ebaycalls->tradingQuery(
			$seller, 
			'GetItem',
			$site_id,
			$body
		);
		if(!$this->isGood($res)){
	    	die('get_ebay_details() error: '.$this->getResponseErrors($res));
		}
		return $res;
    }
    
    public function getActiveListingCall($ebay_user, $page, $outputselector=''){
        $site_id = $this->get_site_id_from_name(EBAY_SITE);
		$ebaycaller = new \YES4Trade\Model\ebaycalls();
		$seller = $ebay_user;
		if(self::oauth2_refreshtoken_exists($seller)){
				if(!self::oauth2_usertoken_exists($seller) or self::get_oauth2_usertoken_lifetime($seller) < 1){
					try{
						self::refresh_oauth2_usertoken($seller);
					}catch(Exception $e){
						$api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
					}
				}
		}
		$body = [
			'ActiveList'=>[
				'Include'=>true,
				'Pagination'=>[
					'EntriesPerPage' => 200,
					'PageNumber' => (int)$page
				]
			]
		];
		if($outputselector != ''){
			if(strstr($outputselector,'ItemSpecifics')){
				$body['IncludeItemSpecifics'] = true;
			}
			$body['OutputSelector'] = $outputselector;
		}

		$res = $ebaycaller->tradingQuery($seller,
			'GetMyeBaySelling',
			$site_id,
			$body
		);
		if(!$this->isGood($res)){
	    	die('GetMyeBaySelling() error: '.$this->getResponseErrors($res));
		}
		return $res;
    }
    
    public function get_auction_sellershippingprofile(ebay_auction $auction){
        $output = 'Item.SellerProfiles.SellerShippingProfile';
        $response = $this->getItemCall($auction->getEbayId(), 
                $auction->getUser(), 
                $auction->getSite(),
                $output
        );
        $profile = $response->Item->SellerProfiles->SellerShippingProfile;
        return array(
            'id'=>$profile->ShippingProfileID,
            'text'=>$profile->ShippingProfileName
        );
    }
    
    /**
     * Erzeugt bzw liefert den oAuth App Token
     * 
     * @return json array ERROR=>'', TOKEN=''
     */
    public function sdk_getOAuthToken(){
		$token_file = main::get_secure_path().DIRECTORY_SEPARATOR.'ebay-sdk-oauth.token';
		$token_expires = 7200;
		if(file_exists($token_file)){
			$file_mdate = filemtime($token_file);
			if( time()-$file_mdate < $token_expires){
				return(json_encode(array(
					'ERROR'=>'',
					'TOKEN'=>file_get_contents($token_file),
				)));
			}
			unlink($token_file);
		}
		$ini_conf = ebayApi::get_ebay_config_ini();
		$api_mode = (defined('EBAY_TESTMODE') and constant('EBAY_TESTMODE')=='1') ? 'test':'prod';
		$link = ($api_mode == 'test') ? 'https://api.sandbox.ebay.com/identity/v1/oauth2/token' :
			'https://api.ebay.com/identity/v1/oauth2/token';

		$token = base64_encode($ini_conf['ebay-config']['app-key-'.$api_mode].':'.$ini_conf['ebay-config']['cert-id-'.$api_mode]);
		$scope = 'https://api.ebay.com/oauth/api_scope';
		$client = new \GuzzleHttp\Client();
		$res = $client->request('POST',$link,[
			'headers'=>[
				'Authorization' => 'Basic ' . $token,
				'Content-Type' => 'application/x-www-form-urlencoded',
			],
			'form_params'=>[
				'grant_type'=>'client_credentials',
				'scope'=>$scope,
			]
		]);
		$json = json_decode((string)$res->getBody());
		touch($token_file);
		file_put_contents($token_file,$json->access_token);

        return json_encode(array(
            'ERROR'=>'',
            'TOKEN'=>$json->access_token
        ));
    }
    
    public function sdk_taxonomy_caller( $token, $mode, $params = [] ){

		$client = new \GuzzleHttp\Client();
		$call_params = [
			'headers'=>[
				'Authorization'=>'Bearer '.$token,
			]
		];
		switch($mode){
			case 'GetItemAspectsForCategory':
				$category_tree_id = $params['CATEGORY_TREE_ID'];
				$category_id = $params['CATEGORY_ID'];
				$url = (defined('EBAY_TESTMODE') and constant('EBAY_TESTMODE') == '1') ? 
					'https://api.sandbox.ebay.com/commerce/taxonomy/v1/category_tree/'.$category_tree_id.'/get_item_aspects_for_category?category_id='.$category_id:
					'https://api.ebay.com/commerce/taxonomy/v1/category_tree/'.$category_tree_id.'/get_item_aspects_for_category?category_id='.$category_id;
				break;
			case 'GetADefaultCategoryTreeId':
				$marketplace = $params['SITE_ID'];
				$url = (defined('EBAY_TESTMODE') and constant('EBAY_TESTMODE') == '1') ? 
					'https://api.sandbox.ebay.com/commerce/taxonomy/v1/get_default_category_tree_id?marketplace_id='.$marketplace :
					'https://api.ebay.com/commerce/taxonomy/v1/get_default_category_tree_id?marketplace_id='.$marketplace;
				break;
		}
		$res = $client->request('GET',
			$url, $call_params
		);
		return json_decode((string)$res->getBody());
    }

    public static function get_sdk_sitecode_from_site(string $site){
        if(stristr($site,'united king')){
            return 'EBAY_UK';
        }
        if(stristr($site,'united states')){
            return 'EBAY_US';
        }
        if(stristr($site,'sterreich')){
            return 'EBAY_AT';
        }
        switch($site){
            case 'Germany': return 'EBAY_DE';
            case 'Austria': return 'EBAY_AT';
            case 'Switzerland': return 'EBAY_CH';
            case 'US': return 'EBAY_US';
        }
        die('Unknown SDK Site '.$site);
    }
    
    public static function get_ebay_seller_environment($user){
        $query = xtc_db_query(sprintf(
                "SELECT environment FROM ebay_auth WHERE user='%s'",
                $user
        ));
        if(!xtc_db_num_rows($query)){
            throw new Exception(sprintf('get_ebay_seller_environment() unknown user "%s"',
                    $user
            ));
        }
        $record = xtc_db_fetch_array($query);
        return $record['environment'];
    }
    
    public static function check_oauth2_usertoken(string  $seller ){
        $file = self::get_oauth2_usertoken_filename($seller);
        if(!file_exists($file)){
            //main::log_process('oauth2','check_oauth2_usertoken '.$seller.' File '.$file.' not exists');
            return false;
        }
        if( self::is_oauth2_user_token_expired( $seller ) ){
            //main::log_process('oauth2','check_oauth2_usertoken '.$seller.' expired');
            return false;
        }
        return true;
    }
    
    /**
     * Refresh or Create Usertoken?
     * 
     * Gibt true zurueck wenn der OAUTH2 Usertoken refreshed werden kann
     * Bei false muss ein neuer OAUTH2 Usertoken erzeugt werden
     * @return boolean
     */
    public static function refresh_or_create_oauth2_usertoken(string $seller ){
        if(!self::oauth2_usertoken_exists($seller)){
            //main::log_process('oauth2', "refresh_or_create_oauth2_usertoken(".$seller.") oauth2_usertoken_exists() returns false");
            return false;
        }
        // neu 22.7.24
        //if(self::is_oauth2_user_token_expired($seller)){
        if(self::is_oauth2_refresh_token_expired($seller)){
            //main::log_process('oauth2', "refresh_or_create_oauth2_usertoken(".$seller.") is_oauth2_refresh_token_expired() returns true");
            return false;
        }
        return true;
    }
    
    public static function is_oauth2_refresh_token_expired( string $seller ){
        $lifetime = self::get_oauth2_refreshtoken_expires( $seller );
        if( $lifetime < 1 ){
            return true;
        }
        return false;
    }
    
    public static function is_oauth2_user_token_expired( string $seller ){
        $lifetime = self::get_oauth2_usertoken_lifetime( $seller );
        if( $lifetime < 1 ){
            return true;
        }
        return false;
    }
    
    public static function get_oauth2_usertoken_json( string $seller ){
        $file = self::get_oauth2_usertoken_filename($seller);
        if(!file_exists($file)){
            throw new Exception('cant read OAUTH2 Usertoken File');
        }
        return json_decode( file_get_contents( $file ));
    }
    
    public static function get_oauth2_refreshtoken_json( string $seller ){
        $file = self::get_oauth2_refreshtoken_filename($seller);
        if(!file_exists($file)){
            throw new Exception('cant read OAUTH2 Refreshtoken File');
        }
        return json_decode( file_get_contents( $file ));
    }

	public static function delete_oauth2_files( string $seller ):void{
        $file = self::get_oauth2_refreshtoken_filename($seller);
        if(file_exists($file)){
            unlink($file);
        }
        $file = self::get_oauth2_usertoken_filename($seller);
        if(file_exists($file)){
            unlink($file);
        }
	}

    
    public static function oauth2_usertoken_exists( string $seller ){
        $token_file = self::get_oauth2_usertoken_filename( $seller );
        if(!file_exists($token_file)){
            return false;
        }
        return true;
    }
    
    public static function oauth2_refreshtoken_exists( string $seller ){
        $token_file = self::get_oauth2_refreshtoken_filename( $seller );
        if(!file_exists($token_file)){
            return false;
        }
        return true;
    }
    
    public static function get_oauth2_usertoken(string $seller){
        if(!self::oauth2_usertoken_exists( $seller )){
            throw new Exception('CREATE');
        }
        if(self::is_oauth2_user_token_expired( $seller )){
            throw new Exception('REFRESH');
        }
        $json = self::get_oauth2_usertoken_json($seller);
        return $json->access_token;
    }
    
    public static function get_oauth2_refreshtoken_filename( string $seller ){
        $seller_safe = preg_replace( '/[^a-z0-9]+/', '-', strtolower( $seller ) );
        return str_replace('ebay-sdk-oauth.refreshtoken','ebay-sdk-oauth.'.$seller_safe.'.refreshtoken',OAUTH2_REFRESHTOKEN_FILE);
    }
    
    public static function get_oauth2_usertoken_filename(string $seller){
        $seller_safe = preg_replace( '/[^a-z0-9]+/', '-', strtolower( $seller ) );
        return str_replace('ebay-sdk-oauth.usertoken','ebay-sdk-oauth.'.$seller_safe.'.usertoken',OAUTH2_USERTOKEN_FILE);
    }
    
    public static function get_oauth2_refreshtoken_filename_creation_time( string $seller ){
        $file = self::get_oauth2_refreshtoken_filename( $seller );
        if(!file_exists($file)){
            return -1;
        }
        return filemtime($file);
    }
    
    public static function get_oauth2_usertoken_filename_creation_time( string $seller ){
        $file = self::get_oauth2_usertoken_filename( $seller );
        if(!file_exists($file)){
            return -1;
        }
        return filemtime($file);
    }
    
    public static function refresh_oauth2_usertoken(string $seller ){
        if( self::is_oauth2_refresh_token_expired( $seller )){
            unlink(self::get_oauth2_usertoken_filename($seller));
            unlink(self::get_oauth2_refreshtoken_filename($seller));
            //main::log_process('oauth2','refresh_oauth2_usertoken '.$seller.' is_oauth2_refresh_token_expired(). Delete usertoken and refreshtoken for '.$seller );
            return self::create_oauth2_usertoken($seller);
        }
        $json = self::get_oauth2_refreshtoken_json($seller);
		$file = self::get_oauth2_usertoken_filename($seller);

		$ebaycalls = new \YES4Trade\Model\ebaycalls;
		$response_obj = $ebaycalls->getAccessTokenFromRefreshToken( $json->refresh_token );
		$response = json_encode($response_obj);
		if(is_file($file)){
        	unlink($file);
		}
        file_put_contents($file, $response);
		$jsonObj = json_decode($response);
		return $jsonObj->access_token;
    }
    
    public static function get_oauth2_refreshtoken_expires( string $seller ){
        if(!self::oauth2_refreshtoken_exists( $seller )){
            return -1;
        }
        $json = self::get_oauth2_refreshtoken_json( $seller );
        $refreshtoken_file_created = self::get_oauth2_refreshtoken_filename_creation_time( $seller );
        return $refreshtoken_file_created + $json->refresh_token_expires_in - time();
    }
    
    public static function get_oauth2_usertoken_lifetime( $seller ){
        if(!self::oauth2_usertoken_exists( $seller )){
            //main::log_process('oauth2','get_oauth2_usertoken_lifetime '.$seller.' return -1 because !self::oauth2_usertoken_exists('.$seller.')' );
            return -1;
        }
        $json = self::get_oauth2_usertoken_json( $seller );
        $usertoken_file_created = self::get_oauth2_usertoken_filename_creation_time( $seller );
        /*
        printf('<li>created: %s, expires: %s, rest: %s',
                date('H:i:s',$usertoken_file_created),
                date('H:i:s',$usertoken_file_created+$json->expires_in),
                (int)((time()-($usertoken_file_created + $json->expires_in))/60)
        );*/
        $return = ($usertoken_file_created + $json->expires_in)-time();
        //main::log_process('oauth2','get_oauth2_usertoken_lifetime '.$seller.': (usertoken_file_created: '.$usertoken_file_created.' + json->expires_in: '.$json->expires_in.') - time() '.time().' = ' . $return );
        return $return;
    }
    
    public static function oauth2_get_user_token( string $consent_token, $service, string $file, $code = 'authorization_code'){
		$ebaycalls = new \YES4Trade\Model\ebaycalls();
		try{
			$response = $ebaycalls->getAccessAndRefreshToken($consent_token);
		}catch(Exception $e){
			die($e->getMessage());
		}
		$refresh_file = str_replace('.usertoken','.refreshtoken',$file);
		file_put_contents($refresh_file, json_encode($response));
		file_put_contents($file, json_encode($response));
		return json_encode($response);        
    }
    
    public static function create_oauth2_usertoken(string $seller, string $consent_token = ''){
        $sandbox = (defined('EBAY_TESTMODE') and EBAY_TESTMODE == '1') ?true : false;
        $file = self::get_oauth2_usertoken_filename($seller);
        $refresh_file = str_replace('.usertoken','.refreshtoken',$file);
        if(file_exists($file)){
            //main::log_process('oauth2','create_oauth2_usertoken - unlink '.$file);
            unlink($file);
        }
        if(file_exists($refresh_file)){
            //main::log_process('oauth2','create_oauth2_usertoken - unlink refresh file '.$refresh_file);
            unlink($refresh_file);
        }
        if(!empty($consent_token)){
            return self::oauth2_get_user_token($consent_token, $service, $file, 'authorization_code');
        }
        try{
            $state = 'yes4trade';
            if($sandbox === true){
                $state = 'local-'.$state;
            }
			$ebaycalls = new \YES4Trade\Model\ebaycalls();
			$response = $ebaycalls->getRedirectURL();
        }catch(Exception $e){
            //main::log_process('oauth2','create_oauth2_usertoken - [Error] '.$e->getMessage());
            $msg = sprintf("Error @ redirectUrlForUser():\r\n\r\n%s\r\n",$e->getMessage());
            if(php_sapi_name() === 'cli'){
                die($msg);
            }else{
                throw new Exception($msg);
            }
        }
        if(php_sapi_name() === 'cli'){
            die(sprintf("PHP Cli Mode\r\nUser Token fuer Seller %s muss aktualisiert werden. Bitte folgende URL im Browser aufrufen:\r\n\r\n%s\r\n",
                    $seller,$response
            ));
        }
        //main::log_process('oauth2','create_oauth2_usertoken - [Success] do oauth2_redirect to '.$response);
        xtc_redirect(xtc_href_link('token.php','action=oauth2_redirect&auth2_url='.urlencode($response).'&seller='.$seller));
    }
    
    public static function get_oauth2_usertoken_scopes(){
        return [
            'https://api.ebay.com/oauth/api_scope/sell.fulfillment',
            'https://api.ebay.com/oauth/api_scope/sell.inventory',
            'https://api.ebay.com/oauth/api_scope/sell.finances',
            'https://api.ebay.com/oauth/api_scope/sell.marketing',
            'https://api.ebay.com/oauth/api_scope/sell.account',            
        ];
    }
    
    /**
	 * holt die ebay_auctions.id anhand einer ebay_id
	 * gibt -1 zurueck wenn die ebay_id nicht in ebay_auctions gespeichert ist ist
     * @param string $ebay_id
     * 
     * @return int
     */
    public function get_ebay_auctions_id_from_ebay_id( string $ebay_id ){
		$ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($ebay_id,['id']);
        if($ea === null){
            return -1;
        }
        return intval($ea->id);
    }
    
    public function get_item_transaction_status( string $ebay_id, string $transaction_id ){
		$exists = true;
        $eaID = $this->get_ebay_auctions_id_from_ebay_id($ebay_id);
        if($eaID < 0){
            $exists = false;
        }
        if($exists){
            $ea = new ebay_auction( $eaID );
		}
		$query = xtc_db_query(sprintf(
			"SELECT site, orders_id,seller FROM ebay_transactions WHERE transactionid='%s' AND ebayid='%s'",
			$transaction_id,$ebay_id
		));
		if(!xtc_db_num_rows($query)){
			return array(
				'EBAY_ID'=>$ebay_id,
				'TRANSACTION_ID'=>$transaction_id,
				'ERROR'=>'Unbekannte Transaktion '.$transaction_id
			);
			$exists = false;
		}
        if($exists){
			$record = xtc_db_fetch_array($query);
        	$siteID = $this->get_site_id_from_name($record['site']);
        	$user = $ea->getUser();
        }else{
			$record = xtc_db_fetch_array($query);
        	$siteID = $this->get_site_id_from_name($record['site']);
        	$user = $record['seller'];
        }
		$ebaycaller = new \YES4Trade\Model\ebaycalls();
		$seller = $user;
		if(self::oauth2_refreshtoken_exists($seller)){
				if(!self::oauth2_usertoken_exists($seller) or self::get_oauth2_usertoken_lifetime($seller) < 1){
					try{
						self::refresh_oauth2_usertoken($seller);
					}catch(Exception $e){
						$api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
					}
				}
		}
		$res = $ebaycaller->tradingQuery($seller,
			'GetItemTransactions',
			$siteID,
			[
				'ItemID' => $ebay_id,
				'OutputSelector' => 'TransactionArray.Transaction.Status',
				'TransactionID' => $transaction_id
			]
		);
        if(!$this->isGood($res)){
            return array(
                'EBAY_ID'=>$ebay_id,
                'TRANSACTION_ID'=>$transaction_id,
                'ERROR'=>implode('<br />',$this->getResponseErrors($res))
            );
        }
        if($res->Ack == 'Failure'){
            return array(
                'EBAY_ID'=>$ebay_id,
                'TRANSACTION_ID'=>$transaction_id,
                'ERROR'=>implode('<br />',$this->getResponseErrors($res,false))
            );
        }
        $tr = $res->TransactionArray->Transaction;
        return array(
            'ERROR'=>'',
            'EBAY_ID'=>$ebay_id,
            'TRANSACTION_ID'=>$transaction_id,
            'CheckoutStatus'=>$tr->Status->CheckoutStatus,
            'CompleteStatus'=>$tr->Status->CompleteStatus,
            'eBayPaymentStatus'=>$tr->Status->eBayPaymentStatus,
            'LastTimeModified'=>$tr->Status->LastTimeModified,
            'PaymentMethodUsed'=>$tr->Status->PaymentMethodUsed,
            'PaymentHoldStatus'=>$tr->Status->PaymentHoldStatus,
        );
    }

    public static function getKeymanagementFilename( $seller ){
        return main::get_secure_path().'EBAY_KEYMNG-'.main::filesanitize($seller, true).'.json';
    }
    
    public static function getKeymanagementValuesObject($seller){
        $keymanagement_file = self::getKeymanagementFilename($seller);
        if(!is_file($keymanagement_file)){
            $err = new stdClass();
            $err->error = true;
            return $err;
        }
        $kv = self::readKeymanagementValues($seller);
        if($kv->expirationTime < time()){
            unlink($keymanagement_file);
            $err = new stdClass();
            $err->error = true;
            return $err;
        }
        return $kv;
    }
    
    public static function readKeymanagementValues($seller){
        $keymanagement_file = self::getKeymanagementFilename($seller);
        return json_decode( file_get_contents($keymanagement_file));
    }
    
    public static function saveKeymanagementValues($responseObject, $seller){
        $keymanagement_file = self::getKeymanagementFilename($seller);
        if(is_file($keymanagement_file)){
            unlink($keymanagement_file);
        }
        if (file_put_contents($keymanagement_file, json_encode($responseObject))){
            return true;
        }
        throw new Exception('Cant save Keymanagement Values');
    }
    
    function get_products_id_from_transaction( $Transaction ){
        $variation = false;
        $sku = '';
        $use_dummy_pid = false;
        $transaction_pID = -1;
        if(gettype($Transaction->Variation) !== 'NULL'){
            $sku = $Transaction->Variation->SKU;
            $title = $Transaction->Variation->VariationTitle;
            $variation = true;
            $query = xtc_db_query(sprintf(
                "SELECT eav.products_id FROM ebay_auctions ea LEFT JOIN ebay_auctions_variations eav ON ea.id=eav.ebay_auctions_id WHERE ea.ebay_id='%s' AND eav.sku='%s'",
                $Transaction->Item->ItemID, $sku
            ));
            if(xtc_db_num_rows($query)){
                $record = xtc_db_fetch_array($query);
                $transaction_pID = $record['products_id'];
            }
        }else{
            $sku = $Transaction->Item->SKU;
            $title = $Transaction->Item->Title;
			$ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id((string)$Transaction->Item->ItemID,['products_id']);
            if($ea !== null){
                $transaction_pID = intval($ea->products_id);
            }
        }
        if( $transaction_pID < 0 ){
            // AUKTION NICHT IN YES
            if(defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID') and EBAY_DEFAULT_DUMMY_PRODUCTS_ID > 0 and (!defined('EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU') or EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU != 'true')){
                $use_dummy_pid = true;
                $transaction_pID = EBAY_DEFAULT_DUMMY_PRODUCTS_ID;
            }elseif(defined('EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU') and EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU == 'true'){
                $transaction_pID = $sku;
            }
        }
        $check_pid_query = xtc_db_query(sprintf(
            "SELECT products_id FROM products WHERE products_id='%d'",
            intval($transaction_pID)
        ));
        if(!xtc_db_num_rows($check_pid_query)){
            $use_dummy_pid = true;
            if(!defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID')){
                throw new Exception(sprintf(
                    'Unbekannte SKU "%s" in Auktion %s - es konnte keine pID ermittelt werden und es wurde keine EBAY_DEFAULT_DUMMY_PRODUCTS_ID hinterlegt.',
                    $sku, $Transaction->Item->ItemID,
                ));
            }
            $transaction_pID = EBAY_DEFAULT_DUMMY_PRODUCTS_ID;
            // Query neu starten da ermittelte pID geaendert ist
            $check_pid_query = xtc_db_query(sprintf(
                    "SELECT products_id FROM products WHERE products_id='%d'",
                    intval($transaction_pID)
            ));
        }
        if(!xtc_db_num_rows($check_pid_query)){
            throw new Exception(sprintf(
                'Unbekannte SKU "%s" in Auktion %s - es konnte keine pID ermittelt werden bzw die ermittelte pID %d ist nicht in YES gespeichert.',
                $sku, $Transaction->Item->ItemID,intval($transaction_pID)
            ));
        }
        $yes_product_data = xtc_db_fetch_array($check_pid_query);
        return $yes_product_data['products_id'];

    }
}
