<?php
class default_products_master_key extends products_master_key {
	var $default_products_master_keys_id;
	
	public function getDefault_products_master_keys_id() {
		return $this->default_products_master_keys_id;
	}

	public function setDefault_products_master_keys_id($default_products_master_keys_id) {
		$this->default_products_master_keys_id = $default_products_master_keys_id;
	}

	function __construct($default_products_master_key_id=-1){
		if($default_products_master_key_id > 0){
			$this->setDefault_products_master_keys_id($default_products_master_key_id);
			$query = xtc_db_query(sprintf(
				"SELECT dpmk.sort_order,dpmk.description FROM default_products_master_keys dpmk WHERE default_products_master_keys_id=%s",
				$this->getDefault_products_master_keys_id()
			));
			$record = xtc_db_fetch_array($query);
			$this->setSort_order($record['sort_order']);
			$this->setDescription($record['description']);
		}
	}
	
	function get_keys($lang_id){
		$keys = array();
		$query = xtc_db_query(sprintf(
			"SELECT default_products_master_keys_description_id,title FROM default_products_master_keys_description WHERE default_products_master_keys_id=%s AND language_id='%s'",
			$this->getDefault_products_master_keys_id(),$lang_id
		));
		while($record = xtc_db_fetch_array($query)){
			$keys[] = array(
				'id'=>$record['default_products_master_keys_description_id'],
				'text'=>$record['title']
			);
		}
		return $keys;
	}
	
	function get_key_values($description_key_id,$lang_id){
		$values = array(array('id'=>'','text'=>TEXT_SELECT));
		$query = xtc_db_query(sprintf(
			"SELECT title FROM default_products_master_slave_values WHERE default_products_master_keys_description_id='%s' AND language_id='%s'",
			$description_key_id,$lang_id
		));
		while($record = xtc_db_fetch_array($query)){
			$values[] = array(
				'id'=>$record['title'],
				'text'=>$record['title']
			);
		}
		return $values;
	}
	
	function add($description, $sort_order){
		$insert_sql_array = array(
			'sort_order'=>$sort_order,
			'description'=>$description
		);
		xtc_db_perform('default_products_master_keys',$insert_sql_array);
		return xtc_db_insert_id();
	}
	
	function add_key($dpmkID,$title,$lang_id){
		$insert_sql_array = array(
			'default_products_master_keys_id'=>$dpmkID,
			'title'=>$title,
			'language_id'=>$lang_id
		);
		xtc_db_perform('default_products_master_keys_description',$insert_sql_array);
		return xtc_db_insert_id();
	}
	
	function add_value($dpmk_desc_ID,$title,$lang_id){
		$insert_sql_array = array(
			'default_products_master_keys_description_id'=>$dpmk_desc_ID,
			'title'=>$title,
			'language_id'=>$lang_id
		);
		xtc_db_perform('default_products_master_slave_values',$insert_sql_array);
	}
}
