<?php

class import_helper
{
	var $row_scheme = array();
	var $language_id = 2;
        var $languages;
	function __construct($row_scheme = array()){
		$this->row_scheme = $row_scheme;
                $this->languages = xtc_get_languages();
	}
	
	public function process_row($row){
		$return_array = array();
		foreach($row as $col=>$content){
			switch($this->row_scheme[ $col ]){
				case 'products_id':
					$return_array[$this->row_scheme[ $col ]] = $content; 
					break;
				case 'category_path':
					$path = explode("\t",$content); 
					if(sizeOf($path)){
						foreach($path as $category_name){
							$categories_id = $this->get_categories_id_from_name($category_name);
							if($categories_id < 1){
								$categories_id = $this->create_category();
							}
						}
					}
					break;
			}
		}
		return $return_array;
	}

	public function get_categories_id_from_name($category_name,$parent_id){
		$query = xtc_db_query(sprintf(
			"SELECT cd.categories_id FROM categories c LEFT JOIN categories_description cd USING(categories_id) WHERE cd.categories_name='%s' AND cd.language_id='%s' AND c.parent_id='%s'",
			$category_name,$this->language_id,$parent_id
		));
		if(!xtc_db_num_rows($query)){
			return 0;
		}
		$record = xtc_db_fetch_array($query);
		return $record['categories_id'];
	}

	public function create_category($category_name,$parent_id,$status){
            $new = new \YES4Trade\Model\category([
                'parent_id'=>$parent_id,
                'categories_status'=>$status,
                'date_added'=>date('Y-m-d H:i:s'),
            ]);
            $categories_id = $new->create();
            foreach($this->languages as $lang){
                $new = new \YES4Trade\Model\categories_description([
                    'categories_id'=>$categories_id,
                    'language_id'=>$lang['id'],
                    'categories_name'=>$category_name
                ]);
                $new->create();
            }
            return $categories_id;
	}
        
        public function get_products_vpe_id_from_name($name,$debug = false){
            if($debug){
                printf("get_products_vpe_id_from_name(%s)\r\n",$name);
            }
            $query = xtc_db_query(sprintf(
                    "SELECT products_vpe_id FROM products_vpe WHERE products_vpe_name='%s' AND language_id='%s'",
                    $name, $this->language_id
            ));
            if(!xtc_db_num_rows($query)){
                return 0;
            }
            $record = xtc_db_fetch_array($query);
            return $record['products_vpe_id'];
        }
        
        public function create_products_vpe($name, $debug = false){
            if($debug){
                printf("create_products_vpe(%s)\r\n",$name);
            }
            $pvpeID = 0;
            foreach($this->languages as $lang){
                if($pvpeID == 0){
                    $query = xtc_db_query(
                        "SELECT MAX(products_vpe_id) as lastID FROM products_vpe"
                    );
                    $record = xtc_db_fetch_array($query);
                    $pvpeID = $record['lastID']+1;
                }
                $insert_sql_array = array(
                    'products_vpe_id'=>$pvpeID,
                    'language_id'=>$lang['id'],
                    'products_vpe_name'=>$name
                );
                xtc_db_perform('products_vpe',$insert_sql_array);
            }
            return $pvpeID;
        }
        
        public static function get_price_netto($price, $tax, $debug=false){
            if($price <=0){
                return 0;
            }
            $tax_val = (100+$tax)/100;
            $netto = $price / $tax_val;
            if($debug){
                printf("get_price_netto(%s, %s) = %s (@%s tax)\r\n",$price, $tax, $netto,$tax_val);
            }
            return $netto;
        }
}
