<?php
/* --------------------------------------------------------------
   $Id: table_block.php,v 1.7 2017/04/24 16:18:58 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(table_block.php,v 1.5 2003/06/02); www.oscommerce.com 
   (c) 2003	 nextcommerce (table_block.php,v 1.8 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

  class tableBlock {
    var $table_border = '';
    var $table_width = '100%';
    var $table_cellspacing = '';
    var $table_cellpadding = '';
    var $table_parameters = '';
    var $table_row_parameters = '';
    var $table_data_parameters = '';
    function __construct(){
    }

    function get_init_js(){
	  return( "<script type=\"text/javascript\">".
		'$().ready(function(){
			$(\'a.ajax_toggle_content\').click(function(){
				var ajc_link = $(this).attr(\'id\');
				var toggle_img = $(this).prev();
				var div_name = \'atc_\'+$(toggle_img).attr(\'id\');
				var content = $(\'#\'+div_name).html();
				if( content != null && content != \'\'){
					$(\'#\'+div_name).html(\'\');
					  $(toggle_img).attr(\'src\',\'images/plus.gif\');
				}else{
					$(\'#\'+div_name).load(ajc_link, function(response) {
					  $(toggle_img).attr(\'src\',\'images/minus.gif\');
					});
				}
			});
		});
	  </script>');
    }
    // php8 bugfix
    
    private function get_td_html( $column, $single_row_mode = false ){
        if(isset($column['th']) and $column['th'] == true){
            $tableBox_string = '    <th ';
        }else{
            $tableBox_string = '    <td ';
        }
        if (isset($column['align']) and $column['align'] != '') {
            $tableBox_string .= ' align="' . $column['align'] . '"';
        }
        if (isset($column['params']) and $column['params'] != '') {
            $tableBox_string .= ' ' . $column['params'];
        } elseif ($this->table_data_parameters != '') {
            $tableBox_string .= ' ' . $this->table_data_parameters;
        }
        $tableBox_string .= '>';

        // BOF mario 02.09.12 - CONTENT ANZEIGEN ON CLICK
        if (isset($column['ajax_toggle_content']) and is_countable($column['ajax_toggle_content']) and sizeOf($column['ajax_toggle_content']) ){
            if($single_row_mode === true){
                $tableBox_string .= sprintf('<img src="images/plus.gif" border="0" alt="" class="ajax_toggle_content_image" id="%s" align="left" /><a href="javascript:;" class="ajax_toggle_content" id="%s">',
                    $column['ajax_toggle_content']['unique_id'],
                    $column['ajax_toggle_content']['link']
                );
            }else{
                $tableBox_string .= sprintf('<a href="javascript:;" class="ajax_toggle_content" id="%s">',
                    $column['ajax_toggle_content']['link']
                );
            }
        }
        // EOF mario 02.09.12 - CONTENT ANZEIGEN ON CLICK

        if (isset($column['form']) and $column['form'] != '') {
            $tableBox_string .= $column['form'];
        }
        $tableBox_string .= $column['text'];

        if($single_row_mode === true){
            // BOF mario 02.09.12 - CONTENT ANZEIGEN ON CLICK
            if (isset($column['ajax_toggle_content']) and is_countable($column['ajax_toggle_content']) and sizeOf($column['ajax_toggle_content'])){
                $tableBox_string .= sprintf(
                    '</a><div id="atc_%s"></div>',
                    $column['ajax_toggle_content']['unique_id']
                );
            }
            // EOF mario 02.09.12 - CONTENT ANZEIGEN ON CLICK
        }else{
            // BOF mario 02.09.12 - CONTENT ANZEIGEN ON CLICK
            if (isset($column['ajax_toggle_content']) and is_countable($column['ajax_toggle_content']) and sizeOf($column['ajax_toggle_content']) ){
                $tableBox_string .= sprintf('</a>');
            }
            // EOF mario 02.09.12 - CONTENT ANZEIGEN ON CLICK
        }


        if (isset($column['form']) and $column['form'] != '') {
            $tableBox_string .= '</form>';
        }
        if(isset($column['th']) and $column['th'] == true){
            return $tableBox_string .'</th>' . "\n";
        }
        return $tableBox_string .'</td>' . "\n";
    }
    
    function tableBlock_draw($contents,$init_js = false) {
        $tableBox_string = '';
        if($init_js == 1){
            $tableBox_string .= $this->get_init_js();
	    }
        $form_set = false;
        if (isset($contents['form'])) {
            $tableBox_string .= $contents['form'] . "\n";
            $form_set = true;
            xtc_array_shift($contents);
        }
        $header = false;
        $header_parsed = false;
        if(isset($contents[0]) and is_countable($contents[0])){
            foreach($contents[0] as $r){
                if(isset($r['th']) and $r['th'] === true){
                    $header = true;
                }
            }
        }
        // padding und co via css
        $tableBox_string .= '<table ';
        if(!empty($this->table_border)){
            $tableBox_string .= 'border="' . $this->table_border . '"';
        }
        if($this->table_width != ''){
            $tableBox_string .= ' width="' . $this->table_width . '"';
        }
        if ($this->table_parameters != '') {
            $tableBox_string .= ' ' . $this->table_parameters;
        }
        $tableBox_string .= '>' . "\n";

        for ($i = 0, $n = sizeof($contents); $i < $n; $i++) {
            if($header and !$header_parsed){
                $tableBox_string .= '<thead>';
            }else{
                if(!isset($tbody_parsed)){
                    $tableBox_string .= '<tbody>';
                    $tbody_parsed = true;
                }
            }
            $tableBox_string .= '  <tr';
            if ($this->table_row_parameters != '') {
                $tableBox_string .= ' ' . $this->table_row_parameters;
            }
            if (isset($contents[$i]['params']) and $contents[$i]['params'] != '') {
                $tableBox_string .= ' ' . $contents[$i]['params'];
            }
            $tableBox_string .= '>' . "\n";
            if (!isset($contents[$i][0])) {
                $contents[$i][0] = '';
            }
            if (is_array($contents[$i][0])) {
                for ($x = 0, $y = sizeof($contents[$i]); $x < $y; $x++) {
                    if (isset($contents[$i][$x]['text'])){
                        $tableBox_string .= $this->get_td_html($contents[$i][$x]);
                    }
                }
            } else {
                $tableBox_string .= $this->get_td_html($contents[$i],true);
            }
            $tableBox_string .= '  </tr>' . "\n";
            if($header and !$header_parsed){
                $tableBox_string .= '</thead>';
                $header_parsed = true;
            }
            
        }
        $tableBox_string .= '</tbody>';
        $tableBox_string .= '</table>' . "\n";
        if ($form_set) {
            $tableBox_string .= '</form>' . "\n";
        }
        return $tableBox_string;
    }
}

