<?php
// KANN NACH V2 AKTIVIERUNG WEG
function get_csv_file_name($versender='') {
	$crypt_name = yes_get_sha1_from_string( 'vom_'.date('d_m_Y')."-".date('H_i_s') );
	if($versender != '') {
		$save_as_name = 'PAKETLISTE-'.$versender.'_'.$crypt_name.".csv";
	}else{
		$save_as_name = 'KOMPLETTPAKETLISTE_'.$crypt_name.".csv";
	}
	return $save_as_name;
}
// KANN NACH V2 AKTIVIERUNG WEG
function paketliste_csv($versender='',$pre_write_mode = false,$shipping_id_array = array() ){
	if($versender != '') {
		if(sizeOf($shipping_id_array)){
			$query = xtc_db_query("SELECT * FROM shippings WHERE status='0' and csv_status=0 and versender='".xtc_db_input($versender)."' and id IN(".implode(',',$shipping_id_array).") order by name1,customers_id");
		}else{
			$query = xtc_db_query("SELECT * FROM shippings WHERE status='0' and csv_status=0 and versender='".xtc_db_input($versender)."' order by name1,customers_id");
		}
	}else{
		if(sizeOf($shipping_id_array)){
			$query = xtc_db_query("SELECT * FROM shippings WHERE status='0' and csv_status=0 and id IN(".implode(',',$shipping_id_array).") ORDER BY name1,customers_id");
		}else{
			$query = xtc_db_query("SELECT * FROM shippings WHERE status='0' and csv_status=0 ORDER BY name1,customers_id");
		}
	}
        
	$crypt_dir = yes_get_sha1_from_string( date('Y-m-d') );
	$path = \main::get_exportdata_path().$crypt_dir;
	if(!is_dir($path)){
		mkdir($path);
		//chmod($path,0777);
	}
	if($pre_write_mode){
		$datei = 'VORAB_PRODUKTLISTE.csv';
	}else{
		$datei = get_csv_file_name($versender);
	}
	$filename = $path.'/'.$datei;
	
	$fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
	fclose($fh);
	$csv = new CSVfile($filename);
	$csv->open("w");
	
	$data[] = 'Versender';
	$data[] = 'Anzahl Pakete';
	$data[] = 'Bestellung/Datum';
	$data[] = 'Empf�nger Firma';
	$data[] = 'Empf�nger Name';
	$data[] = 'Empf�nger Strasse';
	$data[] = 'Empf�nger Adresszusatz';
	$data[] = 'Empf�nger PLZ Ort';;
	$data[] = 'Empf�nger Land';;
	$data[] = 'Betrag';
	$data[] = 'Produkte';
	$data[] = 'Rechnungsbetrag';
	$data[] = 'Gewicht';
	$csv->addRow($data);
	while($shipping = xtc_db_fetch_array($query)){
            
		// enth Produkte der bestellung auslesen
		if($shipping['orders_id'] > 0){
			$products = '';
			if($shipping['reclamations_id'] == 0){
				if(yes_count_shippable_order_products($shipping['orders_id']) < 1){
					continue;
				}
			}
			$order = new order($shipping['orders_id']);
			if(is_array($order->products)){
				$zaehler = 1;
				foreach($order->products as $k => $product) {
					$pqty = $product['qty'] - $product['quantity_shipped'] - $product['not_ship'];
					$products .= $pqty . ' x ' . $product['name']. ' = ' . $product['final_price'];
					if($zaehler < sizeOf($order->products)){
						$products .= ', ';
					}
					$zaehler++;
				}
			}
			foreach($order->totals as $k=>$total){
				if($total['class'] == 'ot_total'){
					$total = $total['text'];
				}
			}
			// preisanzeige
			$zaehler = 1;
			$paytext = '';
			foreach($order->totals as $key=>$val){
				$paytext .= $val['title'].' '.$val['text'];
				if($zaehler < sizeOf($order->totals)) {
					$paytext .= ' / ';
				}
				$zaehler++;
			}

			if($order->info['date_payment'] > 0) {
				$paydate = ' Gebucht: '.yes_strftime('%d.%m.%y',strtotime($order->info['date_payment']));
			}else{
				if( xtc_is_shipping_before_payment($order->info['payment_method']) ){
					$paydate = 'Bezahlart: '.$order->info['payment_method'];
				}else{
					$paydate_query = xtc_db_query("SELECT date_added FROM orders_status_history WHERE orders_id='".$shipping['orders_id']."' && orders_status_id='".ORDERS_STATUS_BEZAHLT."'");
					$paydate_res = xtc_db_fetch_array($paydate_query);
					if(xtc_not_null($paydate_res['date_added'])) {
						$paydate = ' Gebucht: '.yes_strftime('%d.%m.%y',strtotime($paydate_res['date_added']));
					}else{
						$paydate = '';
					}
				}
			}
			$payment_query = xtc_db_query("SELECT ip.buchungstag,ip.betrag FROM incoming_payments ip, payment_orders po WHERE ip.id=po.payment_id and po.orders_id='".$shipping['orders_id']."'");
			if(xtc_db_num_rows($payment_query) > 0){
				while($payment = xtc_db_fetch_array($payment_query)) {
					$paydate .= ' Z.-Eing vom '.$payment['buchungstag'].': '.number_format($payment['betrag'],2,',','').' und ';
				}
				$paydate = substr($paydate,0,(strlen($paydate)-5));
			}

			$orders_id = ($shipping['ebay_id'] != '') ? $shipping['orders_id'] . ' (' . $shipping['ebay_id'].')' : $shipping['orders_id'];
		}else{ // reklamationen
			$reclamation = new reclamation($shipping['reclamations_id']);
			$products = '';
			if(is_array($reclamation->products)){
				$zaehler = 1;
				foreach($reclamation->products as $k => $product) {
					$products .= $product['qty'] . ' x ' . $product['name'];
					if($zaehler < sizeOf($reclamation->products)){
						$products .= ', ';
					}
					$zaehler++;
				}
			}
			$total = '0';
			// preisanzeige
			$zaehler = 1;
			$paytext = 'Reklamation';
			
			$reclamations_id = ($shipping['ebay_id'] != '') ? 'R'.$shipping['reclamations_id'] . ' (' . $shipping['ebay_id'].')' : 'R'.$shipping['reclamations_id'];
		}		
		$data = array();
		$data[] = $shipping['versender'];
		$data[] = $shipping['packages'];
		if($shipping['orders_id'] > 0){
			$data[] = $orders_id.$paydate;
		}else{
			$data[] = $reclamations_id;
		}
		
		$data[] = sprintf('"%s"',str_replace('"',"'",$shipping['company']));
		$data[] = sprintf('"%s"',str_replace('"',"'",$shipping['name1'].( ($shipping['name2'] != '') ? ', '.$shipping['name2'] : '' )));
		$data[] = sprintf('"%s"',str_replace('"',"'",$shipping['street1']));
		$data[] = sprintf('"%s"',str_replace('"',"'",$shipping['street2']));
		$data[] = $shipping['postcode'].' '.$shipping['city'];
		$data[] = $shipping['country_name'];
		if($shipping['orders_id'] > 0){
			if(isset($shipping['betrag']))
				$data[] = number_format(($shipping['betrag']/100),2,',','');
			else
				$data[] = '0';
		}else{
			$data[] = '0';
		}
		$data[] = sprintf('"%s"',str_replace('"',"'",$products));
		$data[] = sprintf('"%s"',str_replace('"',"'",$paytext));
		$data[] = ($shipping['weight']/10);
		$csv->addRow($data);
		if($versender != ''){ // cvs geschrieben status setzen
			xtc_db_query("UPDATE shippings SET csv_status='1' WHERE id='".$shipping['id']."'");
		}
		
	} // end foreach shippings
	$csv->close();
	return $crypt_dir.'/'.$datei;
}

function hermes_csv() {
	$query = xtc_db_query("SELECT * FROM shippings WHERE status='0' and versender='Hermes' order by customers_id");

	$crypt_file = yes_get_sha1_from_string( date('d_m_Y')."-".date('H_i_s') );
	$save_as_name = 'HERMES-BESTELLSCHEIN-'.$crypt_file.".csv";
	
	$crypt_dir = yes_get_sha1_from_string( date('Y-m-d') );
	$path = \main::get_exportdata_path().$crypt_dir;
	if(!is_dir($path)){
		mkdir($path);
		//chmod($path,0777);
	}
	$filename = $path.'/'.$save_as_name;
	
	$fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
	fclose($fh);
	$csv = new CSVfile($filename);
	$csv->open("w");

	$data[] = 'Bestellung';
	$data[] = 'Datum';
	$data[] = 'Kundennummer';
	$data[] = 'Empf�nger Firma';
	$data[] = 'Empf�nger Name';
	$data[] = 'Empf�nger Strasse';
	$data[] = 'Empf�nger Adresszusatz';
	$data[] = 'Empf�nger PLZ Ort';;
	$data[] = 'Empf�nger Land';;
	$data[] = 'Betrag';
	$data[] = 'Produkte';
	$data[] = 'Rechnungsbetrag';
	$csv->addRow($data);

	while($shipping = xtc_db_fetch_array($query)){	
		// enth Produkte der bestellung auslesen
		
		if($shipping['orders_id'] > 0){
			$order = new order($shipping['orders_id']);
			$products = '';
		
			if($shipping['reclamations_id'] == 0){
				if(yes_count_shippable_order_products($shipping['orders_id'])<1){
					continue;
				}
			}
			if(is_array($order->products)){
				$zaehler = 1;
				foreach($order->products as $k => $product) {
					$storage_query = xtc_db_query('SELECT nummer FROM storage_numbers WHERE products_id=\''.$product['id'].'\' && storage_id=\''.HERMES_LAGER_ID.'\'');
					$storage = xtc_db_fetch_array($storage_query);
					
					$pqty = $product['qty'] - $product['quantity_shipped'] - $product['not_ship'];
					
					$products .= '(Lager-Nummer: '.$storage['nummer'].') '.$pqty . ' x ' . $product['name']. ' = ' . $product['final_price'];
					if($zaehler < sizeOf($order->products)){
						$products .= ', ';
					}
					$zaehler++;
				}
			}
			foreach($order->totals as $k=>$total){
				if($total['class'] == 'ot_total'){
					$total = $total['text'];
				}
			}
			// preisanzeige
			$zaehler = 1;
			$paytext = '';
			foreach($order->totals as $key=>$val){
				$paytext .= $val['title'].' '.$val['text'];
				if($zaehler < sizeOf($order->totals)) {
					$paytext .= ' / ';
				}
				$zaehler++;
			}
			
			if($order->info['date_payment'] > 0) {
				$paydate = 'Z-Eing.: '.yes_strftime('%d.%m.%y',strtotime($order->info['date_payment']));
			}else{
				$paydate_query = xtc_db_query("SELECT date_added FROM orders_status_history WHERE orders_id='".$shipping['orders_id']."' && orders_status_id='".ORDERS_STATUS_BEZAHLT."'");
				$paydate_res = xtc_db_fetch_array($paydate_query);
				$paydate = 'Bezahlt: '.yes_strftime('%d.%m.%y',strtotime($paydate_res['date_added']));
			}
			
			
			$orders_id = ($shipping['ebay_id'] != '') ? $shipping['orders_id'] . ' (' . $shipping['ebay_id'].')' : $shipping['orders_id'];
		}else{ // reklamationen
			$reclamation = new reclamation($shipping['reclamations_id']);
			$products = '';
		
			if(is_array($reclamation->products)){
				$zaehler = 1;
				foreach($reclamation->products as $k => $product) {
					$storage_query = xtc_db_query('SELECT nummer FROM storage_numbers WHERE products_id=\''.$product['id'].'\' && storage_id=\''.HERMES_LAGER_ID.'\'');
					$storage = xtc_db_fetch_array($storage_query);
					$products .= '(Lager-Nummer: '.$storage['nummer'].') '.$product['qty'] . ' x ' . $product['name']. ' = ' . $product['final_price'];
					if($zaehler < sizeOf($reclamation->products)){
						$products .= ', ';
					}
					$zaehler++;
				}
			}
			$total = '0';
			// preisanzeige
			$zaehler = 1;
			$paytext = 'Reklamation';
			$reclamations_id = ($shipping['ebay_id'] != '') ? 'R'.$shipping['reclamations_id'] . ' (' . $shipping['ebay_id'].')' : 'R'.$shipping['reclamations_id'];
		}		
		$data = array();
		if($shipping['orders_id'] > 0){
			$data[] = $orders_id;
		}else{
			$data[] = $reclamations_id;
		}
		$data[] = $paydate;
		$data[] = $shipping['customers_id'];
		$data[] = $shipping['company'];
		$data[] = $shipping['name1'].( ($shipping['name2'] != '') ? ', '.$shipping['name2'] : '' );
		$data[] = $shipping['street1'];
		$data[] = $shipping['street2'];
		$data[] = $shipping['postcode'].' '.$shipping['city'];
		$data[] = $shipping['country_name'];
		if($shipping['orders_id'] > 0)
			$data[] = number_format(($shipping['betrag']/100),2,',','');
		else
			$data[] = '0';
		$data[] = sprintf('"%s"',str_replace('"',"'",$products));
		$data[] = $paytext;
		$csv->addRow($data);
	} // end foreach shippings
	$csv->close();
	return $crypt_dir.'/'.$save_as_name;
}
