function hitmeister_category_config(categoryID){
	//console.log('hitmeister.php?action=configure_import_product_data_scheme&categoryID='+categoryID);
	$('#hitmeister-dialog').dialog({
		title: 'Export Konfiguration',
		modal: true,
		width: '600px',
		height: 'auto'
	}).load('hitmeister.php?action=configure_import_product_data_scheme&categoryID='+categoryID);
}
function import_hitmeister_cats(offset){
	$.ajax({
		url: 'hitmeister.php?action=save_cats&offset='+offset,
		dataType: 'json',
		success: function(json){
			if(json.ERROR != ''){
				$('#hitmeister_categories_status').html('<h3>'+HITMEISTER_CATEGORY_UPDATE_FAILED+'</h3>'+json.ERROR);
				return false;
			}
			if(json.DONE == 1){
				$('#hitmeister_categories_status').html('<h3>'+HITMEISTER_CATEGORY_UPDATE_FINISHED+'</h3>');
                                window.location.href = 'hitmeister.php#hitmeister-categories-menu';
				return true;
			}
			$('#hitmeister_categories_status').append('<br /><i>'+json.OFFSET+HITMEISTER_CATEGORY_UPDATE_STATE_PRE+(parseInt(json.OFFSET)+parseInt(json.LIMIT))+HITMEISTER_CATEGORY_UPDATE_STATE_AFTER+'</i>');
			import_hitmeister_cats(parseInt(json.OFFSET)+parseInt(json.LIMIT));
		},
		error: function(){
			$('#hitmeister_categories_status').html('<h3>'+HITMEISTER_CATEGORY_UPDATE_FAILED+'</h3>');
		}
	});
}
function hitmeister_inline_error(str){
	console.log(str);
}

function check_imported_csv_file(id_file){
	$('#hitmeister-dialog').dialog({
		modal: true,
		width: 'auto',
		height: 'auto',
		title: 'Hitmeister Import Check'
	}).load('hitmeister.php?action=chk_import&id_file='+encodeURIComponent(id_file),function(){
		$('li.not_chk').each(function(){
			var currLi = $(this);
			$.ajax({
				url: 'hitmeister.php?action=product_data_status&ean='+$(this).attr('id'),
				dataType: 'json',
				success: function(json){
					if(json.ERROR != ''){
						currLi.removeClass('not_chk').addClass('has_err').append(' '+json.ERROR);
					}else{
						currLi.removeClass('not_chk').addClass('checked').append(json.MSG);
					}
				},error: function(){
					currLi.removeClass('not_chk').addClass('has_err').append(' '+HITMEISTER_CATEGORY_UPDATE_UNKNOWN);
				}
			});
			
		});
	});
}
function cleanup_multiple_values( input_name ){
	var k = 0;
	$('table#import_yes_product_table tbody tr td#input input[name="'+input_name+'"]').each(function(){
		if(k > 0){
			if($(this).next().attr('id') == 'display_maxlength'){
				$(this).next().remove();
			}
			$(this).remove();
		}else{
			$(this).val('');
		}
		k++;
	});
	var k = 0;
	$('table#import_yes_product_table tbody tr td#input select[name="'+input_name+'"]').each(function(){
		if(k > 0){
			if($(this).next().attr('id') == 'display_maxlength'){
				$(this).next().remove();
			}
			$(this).remove();
		}
		k++;
	});
	var k = 0;
	$('table#import_yes_product_table tbody tr td#input textarea[name="'+input_name+'"]').each(function(){
		if(k > 0){
			if($(this).next().attr('id') == 'display_maxlength'){
				$(this).next().remove();
			}
			$(this).remove();
		}
		k++;
	});
	return true;
}

function hitmeister_add_minus_symbol_for_multiple_items_in_add_form(){
	$('table#import_yes_product_table tbody tr td#input').each(function(){
		var input_td = $(this);
		childs = input_td.children('.input_field');
		var clen = childs.length;
		if(clen > 1){
			actiontd = input_td.parent().find('td#action');
			if(!actiontd.find('#remove').length){
				actiontd.append('<span class="ui-icon ui-icon-minus" id="remove"></span>');
				input_td.parent().find('td#action #remove').on('click', function(){
					if(input_td.children('.input_field').length > 1){
						if(input_td.children('.input_field').last().next().attr('id') == 'display_maxlength'){
							input_td.children('.input_field').last().next().remove();
						}
						input_td.children('.input_field').last().remove();
					}
					if(input_td.children().length == 1){
						$(this).remove();
					}
				}).css('cursor','pointer');
			}
		}
	});
}

function hitmeister_maxlength_display(){
	$('table#import_yes_product_table tbody tr td#input .input_field').each(function(){
		var maxL = $(this).attr('maxlength');
		if (typeof maxL !== typeof undefined && maxL !== false) {
			if( $(this).next().attr('id') != 'display_maxlength'){
				var curL = $(this).val().length;
				$(this).after('<div id="display_maxlength">'+curL+'/'+maxL+'</div>').on("input", function(){
					var curL = $(this).val().length;
					$(this).next().text(curL + '/' + maxL);
				});
			}else{
				var curL = $(this).val().length;
				$(this).next().text(curL + '/' + maxL);
			}
		}
	});
}
function hitmeister_unit_update(formObj){
	$.ajax({
		url: 'hitmeister.php',
		data: $(formObj).serialize(),
		dataType: 'json',
		success: function(json){
			if(json.MSG != ''){
				alert(json.MSG);
				return false;
			}
			$('#hitmeister-dialog').dialog('close');
                        if($('table#hitmeister_seller_units_table tbody tr#'+json.ID_UNIT+' td[id="'+json.PART+'"]').length){
                            $('table#hitmeister_seller_units_table tbody tr#'+json.ID_UNIT+' td[id="'+json.PART+'"]').text(json.VALUE).attr('title',json.VALUE.replace('"',"'"));
                        }else{
                            $('table#hitmeister_seller_units_table tbody tr#'+json.ID_UNIT+' td#product_detail a#'+json.PART).text(json.VALUE+'*').attr('title',json.VALUE.replace('"',"'"));
                        }
		},
		error: function(){
			alert('hitmeister_unit_update() error');
		}
	});
}
function hitmeister_delete_unit( id_unit ){
	if(!confirm(HITMEISTER_REALLY_DELETE_UNIT)){
		return false;
	}
	$.ajax({
		url: 'hitmeister.php',
		data: {'action':'delete_unit','id':id_unit},
		dataType: 'json',
		success: function(json){
			if(json.MSG != ''){
				alert(json.MSG);
				return false;
			}
			// PART, ID_UNIT, VALUE
			$('table#hitmeister_seller_units_table tbody tr#'+id_unit).remove();
			return false;
		},
		error: function(){
			alert('hitmeister_delete_unit() error');
		}
	});
}

	
function multiple_order_unit_action_handler(){
	if($('input[name="id_order_unit"]:checked').length > 0){
		$('select[name="multiple_order_unit_action"]').show();
	}else{
		$('select[name="multiple_order_unit_action"]').hide();
	}
}

function performCategorySelect(value, text){
    if($('input#hitmeister_categories_id').length){
            $('input#hitmeister_categories_id').val(value);
            $('a#hitmeister_category_config_link').remove();
            $('#selected_hitmeister_category').html(text).append(
                    '<a href="javascript: hitmeister_category_config('+value+')" id="hitmeister_category_config_link"><input type="button" class="ui-button ui-corner-all ui-state-highlight" value="'+HITMEISTER_SAVE_CATEGORY_EXPORT_CONFIG+'" /></a>'
            );
    }else{
            alert('Hitmeister Kategorie: '+value);
    }
}
