<?php
/* --------------------------------------------------------------
   $Id: stats_shopping_carts.php,v 1.8 2020/09/16 15:54:07 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(stats_products_purchased.php,v 1.27 2002/11/18); www.oscommerce.com 
   (c) 2003	 nextcommerce (stats_products_purchased.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
require(DIR_FS_INC.'xtc_get_customer_status_value.inc.php');
require(DIR_FS_INC.'yes_multisort.inc.php');
require(DIR_WS_CLASSES . 'currencies.php');
require(DIR_WS_CLASSES . 'order.php');
require(DIR_WS_CLASSES . 'yes_lister_table_heading_sort.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
$currencies = new currencies();
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
define('KASSE_DEFAULT_CUSTOMER',KASSE_USER);

if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'export'){
    $export_data = array();
    foreach($_REQUEST['basket_item'] as $val){
	$parts = explode('_',$val);
	$cID = (int)xtc_db_input($parts[0]);
	$pID = (int)xtc_db_input($parts[1]);
	if($cID > 0 and $pID > 0){
	    $email_query = xtc_db_query(sprintf(
		    "SELECT customers_email_address FROM %s WHERE customers_id='%s'",
		    TABLE_CUSTOMERS,$cID
	    ));
	    $email = xtc_db_fetch_array($email_query);
	    if(!empty($email['customers_email_address'])){
		$export_data[ $pID ][] = $email['customers_email_address'];
	    }
	}
    }
    if(sizeOf($export_data)){
	$csv_string = '';
	foreach($export_data as $cID => $emails){
	    $csv_string .= sprintf("%s;%s\r\n",$cID,implode(';',$emails));
	}
	header("Content-type: text/csv");
	header("Content-Disposition: attachment; filename=shopping_cart_products_emails.csv");
	header("Pragma: no-cache");
	header("Expires: 0");
	die($csv_string);
    }else{
	$messageStack->add_session('Export: No data available','error');
	xtc_redirect(xtc_href_link('stats_shopping_carts.php'));
    }
}
if(isset($_GET['hide']) and $_GET['hide'] != ''){
    switch($_GET['hide']){
        case '1Month':
            $to = date('Ymd',time() - (60*60*24*30) );
            break;
        case '3Month':
            $to = date('Ymd',time() - (60*60*24*30*3) );
            break;
        case '1Year':
            $to = date('Ymd',time() - (60*60*24*30*12) );
            break;
        case '2Year':
            $to = date('Ymd',time() - (60*60*24*30*24) );
            break;
    }
    $query = xtc_db_query(sprintf(
            "DELETE FROM customers_basket WHERE CONVERT(customers_basket_date_added, SIGNED INTEGER) <= '%s'",
            $to
    ));
}

// yes accounting  
$items = array();
$sql = "SELECT c.customers_status,c.customers_email_address,cb.* FROM customers_basket cb LEFT JOIN customers c USING(customers_id)";
$query = xtc_db_query(
    $sql
);
$_items = array();
$pid_filter = (isset($_GET['products_id']) and $_GET['products_id'] != '') ? $_GET['products_id'] : false;
$pid_filter_carts = [];
while($record = xtc_db_fetch_array($query)){
    if($record['customers_status'] == 0 or $record['customers_status'] == NULL or $record['customers_status'] == ''){
	$record['customers_status'] = DEFAULT_CUSTOMERS_STATUS_ID_GUEST;
    }
    if($pid_filter and $record['products_id'] == $pid_filter){
        $pid_filter_carts[] = $record['customers_id'];
    }
    $_items[] = $record;
}
if(sizeOf($_items)){
    foreach($_items as $record){
	$record['customers_basket_date_added_raw'] = $record['customers_basket_date_added'];
	$record['customers_basket_date_added'] = substr($record['customers_basket_date_added'],0,4).'-'.
		substr($record['customers_basket_date_added'],4,2).'-'.
		substr($record['customers_basket_date_added'],6,2);
	$record['customers_basket_date_added'] = xtc_date_short($record['customers_basket_date_added']);
	if(!isset($items[$record['customers_id']])){
	    $items[$record['customers_id']] = array(
		'name'=>  trim(xtc_get_editor_name($record['customers_id'])),
		'id'=>$record['customers_id'],
		'products'=>array(),
		'xtPrice'=>new xtcPrice(DEFAULT_CURRENCY,$record['customers_status']),
		'total'=>0,
                'customers_basket_date_added_raw'=>$record['customers_basket_date_added_raw'],
                'product_num'=>0,
	    );
	}
        $properties_valid = true;
        $properties_array = array();
        if(strstr($record['products_id'],'{')){
            $properties_array = yes_get_products_properties_values_from_shopping_cart_id($record['products_id']);
        }
        $recpID = xtc_get_prid($record['products_id']);
        $smarty_properties = array();
        foreach($properties_array as $ppvID){
            $pquery = xtc_db_query(sprintf(
                    "SELECT products_properties_id,title FROM products_properties_values ppv LEFT JOIN products_properties_values_description ppvd USING(products_properties_values_id) WHERE ppv.products_properties_values_id='%s' AND language_id='%s'",
                    $ppvID,$_SESSION['languages_id']
            ));
            $prec = xtc_db_fetch_array($pquery);
            $ppquery = xtc_db_query(sprintf(
                    "SELECT title FROM products_properties_description WHERE products_properties_id='%s' AND language_id='%s'",
                    $prec['products_properties_id'],$_SESSION['languages_id']
            ));
            $pprec = xtc_db_fetch_array($ppquery);
            $smarty_properties[] = array(
                'id'=>$ppvID,
                'value'=>$prec['title'],
                'title'=>$pprec['title']
            );
        }
        $record['properties'] = $smarty_properties;
        $record['properties_valid'] = $properties_valid;
	$record['products_name'] = xtc_get_products_name($recpID);
	$tax_class = yes_eu_oss_get_products_tax_class_id($recpID, STORE_COUNTRY);
	$record['price'] = $items[$record['customers_id']]['xtPrice']->xtcGetPrice($record['products_id'], false, 1, $tax_class);
	$items[$record['customers_id']]['products'][] = $record;
        // BUGFIX - Ticket 3153
	$items[$record['customers_id']]['total'] += $record['price']*$record['customers_basket_quantity'];
	$items[$record['customers_id']]['product_num'] += 1;
        if(KASSE_DEFAULT_CUSTOMER != $record['customers_id']){
            $items[$record['customers_id']]['crm_link'] = xtc_href_link(FILENAME_CUSTOMERS, 'action=crm&cID='.$record['customers_id']);
            $items[$record['customers_id']]['email'] = $record['customers_email_address'];
        }
    }
    if($pid_filter){
        $filtered = [];
        foreach($items as $cID=>$data){
            if(!in_array($cID,$pid_filter_carts)){
                continue;
            }
            $filtered[$cID] = $data;
        }
        $items = $filtered;
    }
    $order_by = (isset($_GET['order_by'])) ? $_GET['order_by'] : 'date_added';
    $sort_order =  (isset($_GET['sort_order'])) ? $_GET['sort_order'] : 'DESC';
    switch($order_by){
        default:
            $order_by_sql = 'customers_basket_date_added_raw';
            break;
        case 'product':
            $order_by_sql = 'product_num';
            break;
        case 'price':
            $order_by_sql = 'total';
            break;
    }
    $desc = ($sort_order == 'DESC')?SORT_DESC:SORT_ASC;
    $items = yes_multisort($items,$order_by_sql,$desc);
}

require_once(DIR_WS_CLASSES.'graph.php');
if(defined('YES_PATH_TO_TTF_FONTS'))
	$path_to_fonts = YES_PATH_TO_TTF_FONTS; // path to where fonts are stored
else
	$path_to_fonts = '/usr/X11R6/lib/X11/fonts/TTF/'; // path to where fonts are stored
    
$graph = new graph(600,500);
$carts = array();
$total_carts = [];
$top_ten_query = xtc_db_query("SELECT customers_id,products_id,customers_basket_quantity FROM customers_basket");
while($record = xtc_db_fetch_array($top_ten_query)){
    $carts[ $record['customers_id'] ][ $record['products_id'] ] += $record['customers_basket_quantity'];
}
if(sizeOf($carts)){
    foreach($carts as $customers_id => $products ){
	$query = xtc_db_query(sprintf(
		"SELECT customers_status FROM %s WHERE customers_id = '%s'",
		TABLE_CUSTOMERS,$customers_id
	));
	$record = xtc_db_fetch_array($query);
	$xtPrice = new xtcPrice(DEFAULT_CURRENCY, $record['customers_status']);
	$total_cart = 0;
	foreach($products as $pID => $qty){
	    $total_cart += $xtPrice->getPprice($pID) * $qty;
	    
	}
	$name = xtc_get_editor_name($customers_id);
	if(strlen($name) > 20){
	    $name = substr($name,0,17).'...';
	}
	$total_carts[ '['.$customers_id.'] ' . $name ] = $total_cart;
    }
}
asort($total_carts);

$_carts = array_reverse($total_carts);
$_carts = array_splice($_carts,0,10);
$y_max_right =  10;
foreach($_carts as $customer=>$total){
	$graph->x_data[] = $customer;
	$graph->y_data['alpha'][ ] = $total;
	if( $total > $y_max_right){
		$y_max_right = $total + 5;
	}
}
$graph->parameter['file_name'] = \main::get_exportdata_path().'start_products_stats.png';
$graph->parameter['path_to_fonts'] = $path_to_fonts;

$graph->parameter['title']             = 'Warenkorb Gesamtwerte Top 10';
$graph->parameter['title_size']        = 11;
$graph->parameter['y_label_right']     = 'Wert';
$graph->parameter['x_label']     = 'Kunde';
$graph->parameter['y_decimal_right']   =  0;
$graph->parameter['x_grid']            = 'none';
$graph->parameter['x_axis_angle']      =  90;
$graph->parameter['y_min_right']       =  0;
$graph->parameter['y_max_right']       =  $y_max_right;
$graph->parameter['y_axis_gridlines']  =  10;
$graph->parameter['y_axis_text_right'] =  2;  //print a tick every 2nd grid line

$graph->y_format['alpha'] = array('colour' => 'red', 'bar' => 'fill', 'legend' => 'Gesamt', 'bar_size' => 1.0, 'y_axis' =>'right');

//$graph->y_data['alpha'] = array(6, 7,  5,  4,  8,  9);
//$graph->y_data['beta']  = array(2, 2,  4,  7,  4,  5);

$graph->y_order = array('alpha');
if(sizeOf($total_carts)){
    $graph->draw_stack();
    $grafik1 = array('src'=>$graph->parameter['file_name'].'.png'); 
    $graph = new graph(600,500);
    $total_products = array();
    if(!sizeOf($carts)){

    }
    foreach($carts as $customers_id => $products ){
        foreach($products as $pID => $qty){
            $name = '['.$pID.'] '.xtc_get_products_name($pID);
            if(strlen($name) > 20){
                $name = substr($name,0,17).'...';
            }
            $total_products[ $name ] += $qty;
        }
    }
    asort($total_products);
    $_carts = array_reverse($total_products);
    $_carts = array_splice($_carts,0,10);
    $y_max_right =  10;
    foreach($_carts as $product=>$total){
            $graph->x_data[] = $product;
            $graph->y_data['alpha'][ ] = $total;
            if( $total > $y_max_right){
                    $y_max_right = $total + 5;
            }
    }
    $graph->parameter['file_name'] = \main::get_exportdata_path().'cart_top_ten_products.png';
    $graph->parameter['path_to_fonts'] = $path_to_fonts;

    $graph->parameter['title']             = 'Warenkorb Beliebteste Artikel Top 10';
    $graph->parameter['title_size']        = 11;
    $graph->parameter['y_label_right']     = 'Anzahl';
    $graph->parameter['x_label']     = 'Artikel';
    $graph->parameter['y_decimal_right']   =  0;
    $graph->parameter['x_grid']            = 'none';
    $graph->parameter['x_axis_angle']      =  90;
    $graph->parameter['y_min_right']       =  0;
    $graph->parameter['y_max_right']       =  $y_max_right;
    $graph->parameter['y_axis_gridlines']  =  10;
    $graph->parameter['y_axis_text_right'] =  2;  //print a tick every 2nd grid line

    $graph->y_format['alpha'] = array('colour' => 'red', 'bar' => 'fill', 'legend' => 'Gesamt', 'bar_size' => 1.0, 'y_axis' =>'right');

    //$graph->y_data['alpha'] = array(6, 7,  5,  4,  8,  9);
    //$graph->y_data['beta']  = array(2, 2,  4,  7,  4,  5);

    $graph->y_order = array('alpha');

    $graph->draw_stack();
    $grafik2 = array('src'=>$graph->parameter['file_name'].'.png'); 
}    
yes_draw_pre_header();
yes_draw_header(TITLE);
$buttons = array();
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'ITEMS'=>$items,
    'IMAGE_STATS_TOTAL'=>xtc_image($grafik1['src']),
    'IMAGE_STATS_PRODUCTS'=>xtc_image($grafik2['src']),
    'TEXT_GENERATE_ORDER_FROM_CART'=>TEXT_GENERATE_ORDER_FROM_CART,
    'TEXT_ORDERS_ID_CREATED'=>TEXT_ORDERS_ID_CREATED,
    'CONFIRM_ADD_ITEMS_TO_ORDER'=>CONFIRM_ADD_ITEMS_TO_ORDER,
    'SORTING_ORDER_BY'=>$order_by,
    'SORTING_SORT_ORDER'=>$sort_order,
    'SORT_BASELINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('sort_order','order_by'))),
    'PID_FILTER_BASELINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('products_id'))),
    'PID_FILTER'=>(isset($_GET['products_id'])) ? $_GET['products_id'] : '',
    'TEXT_HIDE_CARTS'=>TEXT_HIDE_CARTS,
    'HIDE_FILTER'=>xtc_draw_pull_down_menu('hide',array(
        array('id'=>'','text'=>TEXT_SELECT),
        array('id'=>'1Month','text'=>'1 '.TEXT_MONTH),
        array('id'=>'3Month','text'=>'3 '.TEXT_MONTHS),
        array('id'=>'1Year','text'=>'1 '.TEXT_YEAR),
        array('id'=>'2Year','text'=>'2 '.TEXT_YEARS),
    ),''),
    'REALLY_DELETE_SHOPPING_CARTS'=>REALLY_DELETE_SHOPPING_CARTS
));

$smarty->display('stats_shopping_carts.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
