<?php
/* -----------------------------------------------------------------------------------------
   $Id: checkout_shipping_address.php,v 1.14 2020/02/19 13:44:24 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(checkout_shipping_address.php,v 1.14 2003/05/27); www.oscommerce.com
   (c) 2003	 nextcommerce (checkout_shipping_address.php,v 1.14 2003/08/17); www.nextcommerce.org 

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');
//yes_debug($_GET);exit;
$popup = (isset($_GET['popup']) and $_GET['popup'] == 1) ? true : false;
    // create smarty elements
$smarty = new yesSmarty;
// include boxes
if(!$popup){
    $YesBoxes->load( $smarty, basename(__FILE__) );
}
// include needed functions
require_once(DIR_FS_INC . 'xtc_count_customer_address_book_entries.inc.php');
require_once(DIR_FS_INC . 'xtc_address_label.inc.php');
require_once(DIR_FS_INC . 'xtc_get_address_format_id.inc.php');
require_once(DIR_FS_INC . 'xtc_address_format.inc.php');
require_once(DIR_FS_INC . 'xtc_get_country_name.inc.php');
require_once(DIR_FS_INC . 'xtc_get_countries.inc.php');
require_once(DIR_FS_INC . 'xtc_get_zone_code.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_hidden_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_radio_field.inc.php');

$link_checkout_shipping = FILENAME_CHECKOUT_SHIPPING;
$order = new order('',$xtcPrice);
$no_customer_id = false;
if(isset($_SESSION['payment']) and $_SESSION['payment'] == 'yes_ppp'){
    $no_customer_id = !isset($_SESSION['customer_id']);
    if($no_customer_id){
        $pp = new \YES4Trade\Model\paypal_api();
        $pp_order = $pp->getOrder($pp->getOrderToken());
        $order->customer = \YES4Trade\Model\paypal_api::get_yes_orders_customer_array($pp_order);
        $order->delivery = \YES4Trade\Model\paypal_api::get_yes_orders_delivery_array($pp_order);
    }
}

// if the customer is not logged on, redirect them to the login page
if (!isset($_SESSION['customer_id']) and !$no_customer_id) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}

// if there is nothing in the customers cart, redirect them to the shopping cart page
if ($_SESSION['cart']->count_contents() < 1) {
    xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}


// if the order contains only virtual products, forward the customer to the billing page as
// a shipping address is not needed
if ($order->content_type == 'virtual') {
    $_SESSION['shipping'] = false;
    $_SESSION['sendto'] = false;
    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
}
$allowed_shipping_countries = main::get_allowed_delivery_countries();
if(isset($_GET['action']) and $_GET['action'] == 'remove_dhl_postfiliale'){
    unset($_SESSION['dhl_postfiliale']);
    $cust = \YES4Trade\Model\customers::get_by_customers_id(intval($_SESSION['customer_id']),[
        'customers_default_address_id'
    ]);
    if($cust !== null and $cust !== false){
        $_SESSION['sendto'] = $cust->customers_default_address_id;
    }
    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING));
}
if(isset($_GET['action']) and $_GET['action'] == 'set_packstation_address'){
    $keys =  ['street','streetNo','zip','city','name'];
    $error = '';
    foreach($keys as $key){
        if(!isset($_GET[$key]) or empty($_GET[$key])){
            $error = 'Packstation Adresse kann nicht gespeichert werden.';
        }
    }
    if($error != ''){
        die(json_encode(array(
            'ERROR'=>$error,
            'MSG'=>''
        )));
    }
    $items = \YES4Trade\Model\address_book::get_by_customers_id(
        (int)$_SESSION['customer_id'], [
            "entry_company"=>$_GET['name'],
            "entry_postcode"=>$_GET['zip']
        ]
    );
    if(sizeOf($items)){
        $item = current($items);
        $abID = $item->address_book_id;
    }else{
        $street = '';
        if(isset($_GET['street'])){
            $street .= $_GET['street'];
        }
        if(isset($_GET['streetNo'])){
            $street .= ' '.$_GET['streetNo'];
        }
        $new = new \YES4Trade\Model\address_book([
            'customers_id' => (int)$_SESSION['customer_id'],
            'entry_firstname'=>$_SESSION['customer_first_name'],
            'entry_lastname'=>$_SESSION['customer_last_name'],
            'entry_company' => (isset($_GET['name']))?$_GET['name']:'',
            'entry_street_address' => $street,
            'entry_postcode' => (isset($_GET['zip']))?$_GET['zip']:'',
            'entry_city' => (isset($_GET['city']))?$_GET['city']:'',
            'entry_country_id' => 81
        ]);
        $abID = $new->create();
    }
    $_SESSION['sendto'] = $abID;
        
//        $_SESSION['shipping'] = $_GET['dhl_shipping_method'];
    $_SESSION['dhl_postfiliale'] = [
        'customers_id' => $_SESSION['customer_id'],
        'entry_name'=>$_SESSION['customer_first_name'].' '.$_SESSION['customer_last_name'],
        'entry_company'=>xtc_db_prepare_input($_GET['name']),
        'entry_street_address' => xtc_db_prepare_input($_GET['street'].' '.$_GET['streetNo']),
        'entry_postcode' => xtc_db_prepare_input($_GET['zip']),
        'entry_city' => xtc_db_prepare_input($_GET['city']),
        // germany
        'entry_country_id' => 81,
        'address_book_id' => $abID,
    ];
    die(json_encode(array(
        'ERROR'=>'',
        'MSG'=>sprintf('%s<br />%s<br />%s %s<br />%s %s<br />Germany',
            $_SESSION['dhl_postfiliale']['entry_name'],
            $_GET['name'],$_GET['street'],$_GET['streetNo'],
            $_GET['zip'],$_GET['city']
        )
    )));
}
$error = false;
$process = false;
$json = (isset($_POST['mode']) and $_POST['mode'] == 'json') ? true : false;
if (isset($_POST['action']) && ($_POST['action'] == 'submit')) {
    // process a new shipping address
    if (xtc_not_null($_POST['firstname']) && xtc_not_null($_POST['lastname']) && xtc_not_null($_POST['street_address'])) {
      $process = true;

      if (ACCOUNT_GENDER == 'true') $gender = xtc_db_prepare_input($_POST['gender']);
      if (ACCOUNT_COMPANY == 'true') $company = xtc_db_prepare_input($_POST['company']);
      $firstname = xtc_db_prepare_input($_POST['firstname']);
      $lastname = xtc_db_prepare_input($_POST['lastname']);
      $street_address = xtc_db_prepare_input($_POST['street_address']);
      if (ACCOUNT_SUBURB == 'true') $suburb = xtc_db_prepare_input($_POST['suburb']);
      $postcode = xtc_db_prepare_input($_POST['postcode']);
      $city = xtc_db_prepare_input($_POST['city']);
      $country = xtc_db_prepare_input($_POST['country']);
      if (ACCOUNT_STATE == 'true') {
        $zone_id = xtc_db_prepare_input($_POST['zone_id']);
        $state = xtc_db_prepare_input($_POST['state']);
      }
      $error_array = array();
      if (ACCOUNT_GENDER == 'true') {
        if ( ($gender != 'm') && ($gender != 'f') ) {
          $error = true;
	  if($json){
	    $error_array[] = ENTRY_GENDER_ERROR;
	  }else{
	    $messageStack->add('checkout_address', ENTRY_GENDER_ERROR);
	  }
        }
      }

      if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
        $error = true;
	if($json){
	    $error_array[] = ENTRY_FIRST_NAME_ERROR;
	}else{
	    $messageStack->add('checkout_address', ENTRY_FIRST_NAME_ERROR);
	}
      }

      if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
        $error = true;
	if($json){
	    $error_array[] = ENTRY_LAST_NAME_ERROR;
	}else{
	    $messageStack->add('checkout_address', ENTRY_LAST_NAME_ERROR);
	}
      }

      if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
        $error = true;
	if($json){
	    $error_array[] = ENTRY_STREET_ADDRESS_ERROR;
	}else{
	    $messageStack->add('checkout_address', ENTRY_STREET_ADDRESS_ERROR);
	}
      }

      if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
        $error = true;
	if($json){
	    $error_array[] = ENTRY_POST_CODE_ERROR;
	}else{
	    $messageStack->add('checkout_address', ENTRY_POST_CODE_ERROR);
	}
      }

      if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {
        $error = true;
	if($json){
	    $error_array[] = ENTRY_CITY_ERROR;
	}else{
	    $messageStack->add('checkout_address', ENTRY_CITY_ERROR);
	}
      }

      if (ACCOUNT_STATE == 'true') {
        $zone_id = 0;
        $parameters = ['country'=>(int)$country];
        $check_query_raw = sprintf(
            "select count(*) as total from %s where zone_country_id = :country",
            TABLE_ZONES
        );
        $check = yes_query($check_query_raw, $parameters, true);
        $entry_state_has_zones = ($check['total'] > 0);
        if ($entry_state_has_zones == true) {
            $parameters = [
                'country'=>(int)$country,
                'zone_name'=>$state . '%',
                'zone_code'=>'%' . $state . '%'
            ];
            $zone_query_raw = sprintf(
                "select distinct zone_id from %s where zone_country_id = :country and (zone_name like :zone_name or zone_code like :zone_code)",
                TABLE_ZONES
            );
            $zone_query = yes_query($zone_query_raw, $parameters);
            if (sizeOf($zone_query) == 1) {
                $zone = current($zone_query);
                $zone_id = $zone['zone_id'];
            } else {
                $error = true;
                if($json){
                    $error_array[] = ENTRY_STATE_ERROR_SELECT;
                }else{
                    $messageStack->add('checkout_address', ENTRY_STATE_ERROR_SELECT);
                }
            }
        } else {
          if (strlen($state) < ENTRY_STATE_MIN_LENGTH) {
            $error = true;
	    if($json){
		$error_array[] = ENTRY_STATE_ERROR;
	    }else{
		$messageStack->add('checkout_address', ENTRY_STATE_ERROR);
	    }
          }
        }
      }

      if ( (is_numeric($country) == false) || ($country < 1) ) {
        $error = true;
	if($json){
	    $error_array[] = ENTRY_COUNTRY_ERROR;
	}else{
            $messageStack->add('checkout_address', ENTRY_COUNTRY_ERROR);
	}
      }

      if ($error == false) {
        if(!$no_customer_id){
            $sql_data_array = array(
                'customers_id' => (int)$_SESSION['customer_id'],
                'entry_firstname' => $firstname,
                'entry_lastname' => $lastname,
                'entry_street_address' => $street_address,
                'entry_postcode' => $postcode,
                'entry_city' => $city,
                'entry_country_id' => (int)$country
            );

            if (ACCOUNT_GENDER == 'true') {
                $sql_data_array['entry_gender'] = $gender;
            }
            if (ACCOUNT_COMPANY == 'true') {
                $sql_data_array['entry_company'] = $company;
            }
            if (ACCOUNT_SUBURB == 'true') {
                $sql_data_array['entry_suburb'] = $suburb;
            }
            if (ACCOUNT_STATE == 'true') {
            if ($zone_id > 0) {
                $sql_data_array['entry_zone_id'] = (int)$zone_id;
                $sql_data_array['entry_state'] = '';
            } else {
                $sql_data_array['entry_zone_id'] = 0;
                $sql_data_array['entry_state'] = $state;
            }
            }
        if($json){
            foreach($sql_data_array as $k=>$v){
                    if(!is_int($v)){
                        $sql_data_array[$k] = yes_decode_string($v);
                    }
            }
        }
        $new = new \YES4Trade\Model\address_book($sql_data_array);
        $abID = $new->create();
        $_SESSION['sendto'] = $abID;
    }else{
        // update paypal address
        if(isset($_SESSION['payment']) and $_SESSION['payment'] == 'yes_ppp'){
            $pp = new \YES4Trade\Model\paypal_api();
            $response = $pp->updateOrderShippingAdress( $pp->getOrderToken(), $_POST);
            if($response !== true){ 
                $err = urlencode('Paypal Fehler bei Adress Aktualisierung');
                xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART, 'error_message='.$err));
            }else{
                $pporder = $pp->getOrder( $pp->getOrderToken());
            }
            $json = json_decode($response,true);
            $det = [];
            if(isset($json['name']) and $json['name'] == 'UNPROCESSABLE_ENTITY'){
                foreach($json['details'] as $det){
                    $det[] = sprintf('[%s] %s',$det['issue'],$det['description']);
                }
            }
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING));		
        }
    }
	if(!$json){
	    xtc_redirect(xtc_href_link($link_checkout_shipping, '', 'SSL'));
	}
      }
      if($json){
	  $msg = implode("\r\n",$error_array);
	  header('Content-Type: text/html; charset='.CHARSET);
	  die(json_encode(array(
	      'MSG'=>yes_encode_string($msg)
	  )));
      }
    // process the selected shipping destination
    } elseif (isset($_POST['address'])) {
      $reset_shipping = false;
      if (isset($_SESSION['sendto'])) {
        if ($_SESSION['sendto'] != $_POST['address']) {
          if (isset($_SESSION['shipping'])) {
            $reset_shipping = true;
          }
        }
      }

      $_SESSION['sendto'] = $_POST['address'];
      unset($_SESSION['dhl_postfiliale']);
      
      $anz = \YES4Trade\Model\address_book::count_by_customers_id_and_address_book_id(
            (int) $_SESSION['customer_id'], (int) $_SESSION['sendto']
      );
      if ($anz == 1) {
            if ($reset_shipping == true) {
                unset($_SESSION['shipping']);
            }
            xtc_redirect(xtc_href_link($link_checkout_shipping, '', 'SSL'));
      } else {
            unset($_SESSION['sendto']);
      }
    } else {
      $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
      if($json){
	  
      }else{
	xtc_redirect(xtc_href_link($link_checkout_shipping, '', 'SSL'));
      }
    }
  }
  // if no shipping destination address was selected, use their own address as default
  if (!isset($_SESSION['sendto'])) {
    $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
  }

  $breadcrumb->add(NAVBAR_TITLE_1_CHECKOUT_SHIPPING_ADDRESS, xtc_href_link($link_checkout_shipping, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2_CHECKOUT_SHIPPING_ADDRESS, xtc_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL'));

  $addresses_count = xtc_count_customer_address_book_entries();

if(!$popup){
   require(DIR_WS_INCLUDES . 'header.php');
}
  $smarty->assign('FORM_ACTION',xtc_draw_form('checkout_address', xtc_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL'), 'post', 'onSubmit="return check_form_optional(checkout_address);"'));

  if ($messageStack->size('checkout_address') > 0) {
  $smarty->assign('error',$messageStack->output('checkout_address'));


  }

  if ($process == false) {
    if(!$no_customer_id){
        $smarty->assign('ADDRESS_LABEL',xtc_address_label($_SESSION['customer_id'], $_SESSION['sendto'], true, ' ', '<br />'));
    }else{
        $smarty->assign('ADDRESS_LABEL',xtc_address_label_no_customer_id($order->delivery, true, ' ','<br />'));
    }
    if ($addresses_count > 1) {
	$address_content_array = array();
	$address_content='<table class="address_book_table" border="0" width="100%" cellspacing="0" cellpadding="0">';
	$radio_buttons = 0;
        $items = \YES4Trade\Model\address_book::get_by_customers_id((int)$_SESSION['customer_id']);
        foreach($items as $it){
            //while ($addresses = xtc_db_fetch_array($addresses_query)) {
	    $format_id = xtc_get_address_format_id($it->entry_country_id);
            $country_allowed = false;
            foreach($allowed_shipping_countries as $asc){
                if($asc['id'] == $it->entry_country_id){
                    $country_allowed = true;
                    break;
                }
            }
	    $address_content.=' <tr>
                <td colspan="2">
                    <table border="0" width="100%" cellspacing="2" cellpadding="4">
                ';

	    if ($it->address_book_id == $_SESSION['sendto']) {
	      $address_content.= '                  <tr id="defaultSelected" class="moduleRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
	    } else {
	      $address_content.= '                  <tr class="moduleRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
	    }
	    $address_content.= '
                    <td class="main" colspan="2"><b>'. $it->entry_firstname . ' ' . $it->entry_lastname.'</b></td>
                    <td class="main" align="right">';
            if($country_allowed){
                $address_content .= xtc_draw_radio_field('address', $it->address_book_id, ($it->address_book_id == $_SESSION['sendto']));
            }else{
                $address_content .= '<a style="text-decoration: none;" href="javascript:;" onclick="javascript: alert(\''.TEXT_INVALID_DELIVERY_COUNTRY.'\')"><span title="'.TEXT_INVALID_DELIVERY_COUNTRY.'">&#10067;</span></a>';
            }
            $address_conv = [];
            $address_raw = $it->toArray();
            foreach($address_raw as $ark=>$arv){
                $arkn = str_replace('entry_','',$ark);
                $address_conv[ $arkn ] = $arv;
            }
            $address_content .= '</td>
                  </tr>
                  <tr>
                    <td colspan="3"><table border="0" cellspacing="0" cellpadding="2">
                      <tr>
                        <td width="10">'.  xtc_draw_separator('pixel_trans.gif', '10', '1').'</td>
                        <td class="main">'.  xtc_address_format($format_id, $address_conv, true, ' ', ', ').'</td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>';
            $address_content_array[] = array(
                'ADDRESS'=>$address_conv,
                'INPUT'=>xtc_draw_radio_field('address', $it->address_book_id, ($it->address_book_id == $_SESSION['sendto'])),
                'ADDRESS_FORMATTED'=>xtc_address_format($format_id, $address_conv, true, ' ', ', ')
            );
            $radio_buttons++;
      }
	$address_content.='</table>';
	$smarty->assign(array(
	    'BLOCK_ADDRESS'=>$address_content,
	    'ADDRESSES'=>$address_content_array
	));
    }
}
if ($addresses_count < MAX_ADDRESS_BOOK_ENTRIES) {
    require(DIR_WS_MODULES . 'checkout_new_address.php');
}
$smarty->assign('BUTTON_CONTINUE',xtc_draw_hidden_field('action', 'submit') . xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE));

if ($process == true) {
    $smarty->assign('BUTTON_BACK','<a href="' . xtc_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL') . '">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>');
}

$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
$main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/checkout_shipping_address.html');
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
if(!$popup){
    $smarty->caching = 0;
    if (!defined('RM')) $smarty->load_filter('output', 'note');
        $smarty->display(CURRENT_TEMPLATE . '/index.html');
}else{
    echo $main_content;
}
include ('includes/application_bottom.php');
