<?php
use PhpParser\Lexer\Emulative;
use PhpParser\Parser\Php8;
use PhpParser\PhpVersion;
use PhpParser\NodeTraverser;
use PhpParser\Node;
use PhpParser\NodeVisitorAbstract;
include('includes/application_top.php');


// wenn true wird configure.php neu geschrieben
// nach dem erweitern der .env
$recreate_config_file = false;

$known_keys = ['HTTP_SERVER','HTTPS_SERVER','ENABLE_SSL','DIR_WS_CATALOG','DIR_FS_DOCUMENT_ROOT','DIR_FS_CATALOG','DIR_WS_IMAGES','DIR_WS_ORIGINAL_IMAGES','DIR_WS_THUMBNAIL_IMAGES','DIR_WS_INFO_IMAGES','DIR_WS_POPUP_IMAGES','DIR_WS_ICONS','DIR_WS_INCLUDES','DIR_WS_FUNCTIONS','DIR_WS_CLASSES','DIR_WS_MODULES','DIR_WS_LANGUAGES','DIR_WS_DOWNLOAD_PUBLIC','DIR_FS_DOWNLOAD','DIR_FS_DOWNLOAD_PUBLIC','DIR_FS_INC','DB_SERVER','DB_SERVER_USERNAME','DB_SERVER_PASSWORD','DB_DATABASE','USE_PCONNECT','STORE_SESSIONS','DIR_FS_ADMIN','COMMENTS_IN_CHECKOUT_PROCESS','YES_SYSTEM_HOME_DIRECTORY','USE_YES_ERROR_HANDLER','HTTP_CATALOG_SERVER','HTTPS_CATALOG_SERVER','ENABLE_SSL_CATALOG','DIR_WS_ADMIN','DIR_FS_CATALOG_IMAGES','DIR_FS_CATALOG_ORIGINAL_IMAGES','DIR_FS_CATALOG_THUMBNAIL_IMAGES','DIR_FS_CATALOG_INFO_IMAGES','DIR_FS_CATALOG_POPUP_IMAGES','DIR_FS_CATALOG_EBAYCATEGORY_IMAGES','DIR_WS_CATALOG_IMAGES','DIR_WS_CATALOG_ORIGINAL_IMAGES','DIR_WS_CATALOG_THUMBNAIL_IMAGES','DIR_WS_CATALOG_INFO_IMAGES','DIR_WS_CATALOG_POPUP_IMAGES','DIR_WS_BOXES','DIR_FS_LANGUAGES','DIR_FS_CATALOG_MODULES','DIR_FS_BACKUP','YES_PATH_TO_TTF_FONTS','XHTML_VALID', 'ADVANCED_SHOP_SEARCH_ONLY_MASTER', 'YES_EXT_MODUS_TAX_RATE_PERCENT','PRODUCTS_LISTING_NO_SLAVES'];
$files = [
    'includes/configure.php',
    'admin/includes/configure.php'
];

// DIESE UNTERSCHEIDEN SICH
$special = [
    'DIR_WS_CATALOG'=>['shop'=>'','admin'=>'']
];

// fuegt eine Zeile in der .env hinzu
function extendEnv($key, $value):void{
    $env_file = '.env';
    $dotenv = \Dotenv\Dotenv::createImmutable(main::get_secure_path(),basename($env_file));
    $dotenv->load();
    if(isset($_ENV[$key]) and $_ENV[$key] == $value){
        printf("Die Konfiguration %s mit dem Wert %s ist bereits vorhanden.\n", $key, $value);
        return;
    }
    if(!file_put_contents(\main::get_secure_path().$env_file, 
         sprintf("%s='%s'%s",$key, $value,PHP_EOL),
         FILE_APPEND
    )){
        print_r( error_get_last() )."\n";
        printf("Die Konfiguration %s mit dem Wert %s konnte nicht zum .env hinzugefuegt werden.\n", $key, $value);
    };
}

function extractDefineKeys(string $filepath): array {
    $lexer  = new Emulative();
    $parser = new Php8($lexer);

    $code = file_get_contents($filepath);
    $ast  = $parser->parse($code);

    $traverser = new NodeTraverser();
    $collector = new class extends NodeVisitorAbstract {
        public array $keys = [];

        public function enterNode(Node $node) {
            // Prüfen ob es ein define()-Aufruf ist
            if (
                $node instanceof Node\Expr\FuncCall &&
                $node->name instanceof Node\Name &&
                strtolower((string)$node->name) === 'define'
            ) {
                // Ersten Parameter prüfen
                if (
                    isset($node->args[0]->value) &&
                    $node->args[0]->value instanceof Node\Scalar\String_
                ) {
                    $this->keys[] = $node->args[0]->value->value;
                }
            }
        }
    };

    $traverser->addVisitor($collector);
    $traverser->traverse($ast);

    return $collector->keys;
}

/** DB CONFIG AUS configure.php DATEIEN ENTFERNEN
$remove_keys = ['DB_SERVER','DB_SERVER_USERNAME','DB_SERVER_PASSWORD','DB_DATABASE'];
$config_file = realpath(__DIR__).DIRECTORY_SEPARATOR.'includes/configure2.php';
$content = explode("\n",file_get_contents($config_file));
$new_content = [];
foreach($content as $c){
    $remove = false;
    foreach($remove_keys as $rk){
        $check_str = [
            sprintf("'%s'",$rk),
            sprintf('"%s"',$rk),
        ];
        foreach($check_str as $cs){
            if(str_contains($c,$cs)){
                $remove = true;
                extendEnv($rk, constant($rk));
            }
        }
    }
    if($remove === false){
        $new_content[] = $c;
    }
}

if($recreate_config_file === true){
    if(sizeOf($new_content)){
        unlink($config_file);
    }
    if(!file_put_contents($config_file,implode($new_content))){
        $error = error_get_last();
        die($error['message']."\nKann $config_file nicht neu schreiben\n");
    }
    chmod($config_file,0444);
    die(basename($config_file).' replaced and .env extended');
}else{
    die('.env extended');
}
exit;
*/

// --- Beispielaufruf ---
$keys = extractDefineKeys($files[0]);
$keys2 = extractDefineKeys($files[0]);
$r1 = array_diff($keys,$known_keys);
$r2 = array_diff($keys2,$known_keys);
if(sizeOf($r1) or sizeOf($r2)){
    echo "Folgende KEYS sind nicht bekannt:\n";
}else{
    die("KEINE UNBEKANNTEN KONFIGURATIONEN\n");
}
if(sizeOf($r1)){
    echo "\tSHOP CONFIG: ".implode(', ',$r1)."\n";
}
if(sizeOf($r2)){
    echo "\tADMIN CONFIG: ".implode(', ',$r2)."\n";
}
exit;
