<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_db_perform.inc.php,v 1.4 2020/03/25 08:32:08 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(database.php,v 1.19 2003/03/22); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_db_perform.inc.php,v 1.3 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
function yes_db_perform(string $table, array $data, string $action = 'insert', array $where_parameters = array(), string $link = 'db_link'){
    global $$link;
    $vals = [];
    
    switch(strtolower($action)){
        case 'update': // update
            foreach ($data as $field => $v){
                if(strtolower($v) == 'now()' or strtolower($v) == 'null'){
                    $vals[] = $field . "=$v";
                }else{
                    $vals[] = $field . "=:".$field;
                }
            }
            $wp = [];
            foreach($where_parameters as $k=>$v){
                $wp[] = $k.'=:'.$k;
            }
            
            $sql = sprintf("UPDATE %s SET %s WHERE %s",
                $table, implode(',',$vals),
                implode(' AND ',$wp)
            );
            $rows = $$link->prepare($sql);
            foreach ($data as $k => $l){
                if(strtolower($l) == 'now()' or strtolower($l) == 'null'){
                    // Nix $rows->bindValue($k, $l);
                }else{
                    $rows->bindValue(':' . $k, $l);
                }
            }
            foreach ($where_parameters as $k => $l){
                $rows->bindValue(':'.$k, $l);
            }
            break;
        default:
            foreach ($data as $field => $v){
                if(strtolower($v) == 'now()' or strtolower($v) == 'null'){
                    $vals[] = $v;
                }else{
                    $vals[] = ":".$field;
                }
            }
            $fields = implode(',', array_keys($data));
            $sql = sprintf("INSERT INTO %s (%s) VALUES (%s)",
                $table, $fields, implode(',',$vals)
            );
            $rows = $$link->prepare($sql);
            foreach ($data as $k => $l){
                if(strtolower($l) == 'now()' or strtolower($l) == 'null'){
                    // Nix $rows->bindValue($k, $l);
                }else{
                    $rows->bindValue(':' . $k, $l);
                }
            }
            break;
    }
    return $rows->execute();
}
   
  function xtc_db_perform($table, $data, $action = 'insert', $parameters = '', $link = 'db_link') {
//    reset($data);
    if ($action == 'insert') {
      $query = 'insert into ' . $table . ' (';
	foreach($data as $columns=>$value){
	        $query .= $columns . ', ';
	}
      $query = substr($query, 0, -2) . ') values (';
	foreach($data as $value){
		switch ((string)$value) {
		  case 'now()':
		    $query .= 'now(), ';
		    break;
		  case 'null':
		    $query .= 'null, ';
		    break;
		  default:
		    $query .= '\'' . xtc_db_input($value) . '\', ';
		    break;
		}
	}
      $query = substr($query, 0, -2) . ')';
    } elseif ($action == 'update') {
      $query = 'update ' . $table . ' set ';
	foreach($data as $columns=>$value){
		switch ((string)$value) {
		  case 'now()':
		    $query .= $columns . ' = now(), ';
		    break;
		  case 'null':
		    $query .= $columns .= ' = null, ';
		    break;
		  default:
		    $query .= $columns . ' = \'' . xtc_db_input($value) . '\', ';
		    break;
		}
	}
      $query = substr($query, 0, -2) . ' where ' . $parameters;
    }
    return xtc_db_query($query, $link);
	 
}
