<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_db_query.inc.php,v 1.16 2017/06/01 11:15:53 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(database.php,v 1.19 2003/03/22); www.oscommerce.com
   (c) 2003	 nextcommerce (xtc_db_query.inc.php,v 1.4 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
   
  // include needed functions
include_once(DIR_FS_INC . 'xtc_db_error.inc.php');
function yes_query(string $sql, array $parameters = [], bool $single_result = false, string $link = 'db_link'){
    global $$link;
    if (defined('STORE_DB_TRANSACTIONS') && STORE_DB_TRANSACTIONS == 'true') {
	$sql_time_start = hrtime(true); 
    }
    $sth = $$link->prepare($sql);
    if(sizeOf($parameters)){
        $sth->execute($parameters);
    }else{
        $sth->execute();
    }
    if (defined('STORE_DB_TRANSACTIONS') && STORE_DB_TRANSACTIONS == 'true') {
	$sql_time_end = hrtime(true);
        $dauerMillisekunden = ($sql_time_end - $sql_time_start) / 1000000;
	$sql_parse_time = $dauerMillisekunden;
	if(main::isDev(true) or $sql_parse_time > 0.4){
            $param_str = '';
            if(sizeOf($parameters)){
                $pstr = [];
                foreach($parameters as $p=>$v){
                    $pstr[] = sprintf("%s: %s",$p,$v);
                }
                $param_str = implode(', ',$pstr);
            }
	    error_log('['.date('Y-m-d H:i:s').'] QUERYTIME: '.$sql_parse_time.' / PDO QUERY ' . $sql . " - Parameters: ".$param_str."\n", 3, STORE_PAGE_PARSE_TIME_LOG);
	}
    }
    if($single_result === true){
        return $sth->fetch(PDO::FETCH_ASSOC);
    }
    return $sth->fetchAll(PDO::FETCH_ASSOC);
}

  function xtc_db_query($query, $link = 'db_link') {
    global $$link;

//    echo '<li>'.$query;
    if (defined('STORE_DB_TRANSACTIONS') && STORE_DB_TRANSACTIONS == 'true') {
	$sql_time_start = explode(' ', microtime());
	$query_str = str_replace(PHP_EOL,' ',str_replace('  ','',$query) );
    }
    
    if (defined('PDO::ATTR_DRIVER_NAME') and version_compare(phpversion(), '7.0', '>=')) {
	$result = $$link->query($query);
    }else{
	$result = mysql_query($query, $$link) or xtc_db_error($query, mysql_errno(), mysql_error());
    }
    
    
    if (defined('PDO::ATTR_DRIVER_NAME') and version_compare(phpversion(), '7.0', '>=')) {
	$error = $$link->errorInfo();
	$result_error = '';
	if (!is_null($error[2])) {
	    $result_error = $error[2];
	    if (defined('STORE_DB_TRANSACTIONS') && STORE_DB_TRANSACTIONS == 'true') {
		error_log('ERROR QUERY' . $query_str . ': ' . $error[2] . "\n", 3, STORE_PAGE_PARSE_TIME_LOG);
	    }
	    if(function_exists('yes_print_exception')){
                foreach($error as $error_it){
                    $result_error .= '<br />'.$error_it;
                }
                throw new Exception('SQL ERROR<br />Query: '.$query.'<br /><br />'.$result_error);
		//yes_print_exception('SQL ERROR<br />Query: '.$query.'<br /><br />'.$result_error);exit;
	    }
	}

    }
    if (defined('STORE_DB_TRANSACTIONS') && STORE_DB_TRANSACTIONS == 'true') {
	$sql_time_end = explode(' ', microtime());
	$sql_parse_time = number_format(($sql_time_end[1] + $sql_time_end[0] - ($sql_time_start[1] + $sql_time_start[0])), 3);
	if(main::isDev(true) || $sql_parse_time > 3){
	    error_log('QUERYTIME: '.$sql_parse_time.' / QUERY ' . $query_str . "\n", 3, STORE_PAGE_PARSE_TIME_LOG);
	}
    }
    if (defined('STORE_DB_TRANSACTIONS') && STORE_DB_TRANSACTIONS == 'true') {
	if (defined('PDO::ATTR_DRIVER_NAME') and version_compare(phpversion(), '7.0', '>=')) {
	}else{
	    $result_error = mysql_error();
	}
    }
    if(isset($result_error) and $result_error != ''){
     error_log('ERROR QUERY' . $query_str . ': ' . $result_error . "\n", 3, STORE_PAGE_PARSE_TIME_LOG);
    }
    return $result;
  }
