<?php

/*
    Sets the language of the forms.

    Translates the return error msg to the language used.
*/

// ============================
// KREDITOR PREDEFINED LANGUAGE VARIABLES
// ============================

// SWEDISH PREDEFINED VARIABLES
define('KREDITOR_LANG_INFO_SE_IMGINVOICE',
    '<img src="images/klarna_invoice_se_logo.png" />');
define('KREDITOR_LANG_INFO_SE_IMGCONSUMERCREDIT',
    '<img src="images/klarna_part_payment_se_logo.png" />');
define('KREDITOR_LANG_INFO_SE_KLARNA', 'Konto - %s/m&aring;n');
define('KREDITOR_LANG_INFO_SE_FIRSTNAME', 'Ditt f&ouml;rnamn');
define('KREDITOR_LANG_INFO_SE_LASTNAME', 'Ditt efternamn');
define('KREDITOR_LANG_INFO_SE_STREETADDRESS', 'Adress');
define('KREDITOR_LANG_INFO_SE_POSTCODE', 'Postnummer');
define('KREDITOR_LANG_INFO_SE_CITY', 'Ort');
define('KREDITOR_LANG_INFO_SE_PHONENUMBER', 'Mobilnummer');
define('KREDITOR_LANG_INFO_SE_EMAIL', 'E-post');
define('KREDITOR_LANG_INFO_SE_CONDITIONS', 'K&ouml;pvillkor');
define('KREDITOR_LANG_INFO_SE_PERSONALNUMBER', 'Personnummer');
define('KREDITOR_LANG_INFO_SE_PAYMENT', 'Betalningsvillkor 14 dagar');
define('KREDITOR_LANG_INFO_SE_ERRORCURRENCY',
    'Klarna accepterar endast betalningar i Svenska kronor (SEK)');
define('KREDITOR_LANG_INFO_SE_CHOOSECONSUMERCREDIT', 'V&auml;lj delbetalning');
define('KREDITOR_LANG_INFO_SE_YEARLYINCOME', '&Aring;rsinkomst');
define('KREDITOR_LANG_INFO_SE_ACCEPTCONDITION1_ACCEPT', 'Jag godk&auml;nner');
define('KREDITOR_LANG_INFO_SE_ACCEPTCONDITION2_LINK',
    'http://www.klarna.com/kontovillkor.pdf');
define('KREDITOR_LANG_INFO_SE_ACCEPTCONDITION3_CONDITIONS', 'k&ouml;pvillkoren');
define('KREDITOR_LANG_INFO_SE_ERRORACCEPTCONDITION', 'V&auml;nligen godk&auml;nn k&ouml;pvillkoren');
define('KREDITOR_LANG_INFO_SE_CHOOSEALTERNATIVES', 'V&auml;lj alternativ adress nedan');
define('KREDITOR_LANG_INFO_SE_PAYMENTTEXT1_PAY', '');
define('KREDITOR_LANG_INFO_SE_PAYMENTTEXT2_EACH', '/m&aring;n');
define('KREDITOR_LANG_INFO_SE_PAYMENTTEXT3_MONTH', ' m&aring;n - ');
define('KREDITOR_LANG_INFO_SE_ERRORINVOICE', 'Fakturera mig-fel');
define('KREDITOR_LANG_INFO_SE_ERRORDIVIDE', 'Dela upp betalningen-fel');
define('KREDITOR_LANG_INFO_SE_ERRORPREPAY', 'F&ouml;rskottsbetalning-fel');
define('KREDITOR_LANG_INFO_SE_FROM', 'fr&aring;n');
define('KREDITOR_LANG_INFO_SE_PARTPAYMENT_FROM', 'Delbetala fr&aring;n');


// FINNISH PREDEFINED VARIABLES       
define('KREDITOR_LANG_INFO_FI_IMGINVOICE',
    '<img src="images/klarna_invoice_fi_logo.png" />');
define('KREDITOR_LANG_INFO_FI_IMGCONSUMERCREDIT',
    '<img src="images/klarna_part_payment_fi_logo.png" />');
define('KREDITOR_LANG_INFO_FIN_KLARNA', 'Tili - %s/kk');
define('KREDITOR_LANG_INFO_FI_FIRSTNAME', 'Etunimi');
define('KREDITOR_LANG_INFO_FI_LASTNAME', 'Sukunimi');
define('KREDITOR_LANG_INFO_FI_STREETADDRESS', 'Osoite');
define('KREDITOR_LANG_INFO_FI_POSTCODE', 'Postinumero');
define('KREDITOR_LANG_INFO_FI_CITY', 'Postitoimipaikka');
define('KREDITOR_LANG_INFO_FI_PHONENUMBER', 'Matkapuhelinnumero');
define('KREDITOR_LANG_INFO_FI_EMAIL', 'S&auml;hk&ouml;posti');
define('KREDITOR_LANG_INFO_FI_CONDITIONS', 'Ostoehdot');
define('KREDITOR_LANG_INFO_FI_PERSONALNUMBER', 'Henkil&ouml;tunnus');
define('KREDITOR_LANG_INFO_FI_PAYMENT', 'Maksuehdot 14 p&auml;iv&auml;&auml;');
define('KREDITOR_LANG_INFO_FI_ERRORCURRENCY',
    'Klarna hyv&auml;ksyy ainoastaan maksuja euroissa (EUR)');
define('KREDITOR_LANG_INFO_FI_CHOOSECONSUMERCREDIT', 'Valitse osamaksu');
define('KREDITOR_LANG_INFO_FI_YEARLYINCOME', 'Vuositulot');
define('KREDITOR_LANG_INFO_FI_ACCEPTCONDITION1_ACCEPT', 'Hyv&auml;ksyn ');
define('KREDITOR_LANG_INFO_FI_ACCEPTCONDITION2_LINK',
    'http://kreditor.se/_fi/_osamaksulla/osamaksulla_tiliehdot.pdf');
define('KREDITOR_LANG_INFO_FI_ACCEPTCONDITION3_CONDITIONS', 'ostoehdot');
define('KREDITOR_LANG_INFO_FI_ERRORACCEPTCONDITION', 'Ole hyv&auml; ja hyv&auml;ksy ostoehdot');
define('KREDITOR_LANG_INFO_FI_CHOOSEALTERNATIVES', 'Valitse toinen osoite t&auml;st&auml; alhaalta');
define('KREDITOR_LANG_INFO_FI_PAYMENTTEXT1_PAY', '');
define('KREDITOR_LANG_INFO_FI_PAYMENTTEXT2_EACH', '/kk ');
define('KREDITOR_LANG_INFO_FI_PAYMENTTEXT3_MONTH', ' kuukautta - ');
define('KREDITOR_LANG_INFO_FI_ERRORINVOICE', 'Lasku-virhe');
define('KREDITOR_LANG_INFO_FI_ERRORDIVIDE', 'Osamaksu-virhe');
define('KREDITOR_LANG_INFO_FI_ERRORPREPAY', 'Ennakkolasku-virhe');
define('KREDITOR_LANG_INFO_FI_FROM', 'alk');
define('KREDITOR_LANG_INFO_FI_PARTPAYMENT_FROM', 'Jaa maksu osiin alk.');

// DANISH PREDEFINED VARIABLES
define('KREDITOR_LANG_INFO_DK_IMGINVOICE',
    '<img src="images/klarna_invoice_dk_logo.png" />');
define('KREDITOR_LANG_INFO_DK_IMGCONSUMERCREDIT',
    '<img src="images/klarna_part_payment_dk_logo.png" />');
define('KREDITOR_LANG_INFO_DK_KLARNA', 'Konto - %s/m&aring;n');
define('KREDITOR_LANG_INFO_DK_FIRSTNAME', 'Dit navn');
define('KREDITOR_LANG_INFO_DK_LASTNAME', 'Dit efternavn');
define('KREDITOR_LANG_INFO_DK_STREETADDRESS', 'Adresse');
define('KREDITOR_LANG_INFO_DK_POSTCODE', 'Postnummer');
define('KREDITOR_LANG_INFO_DK_CITY', 'By');
define('KREDITOR_LANG_INFO_DK_PHONENUMBER', 'Mobilnummer');
define('KREDITOR_LANG_INFO_DK_EMAIL', 'E-mail-adresse');
define('KREDITOR_LANG_INFO_DK_CONDITIONS', 'Vilk&aring;r');
define('KREDITOR_LANG_INFO_DK_PERSONALNUMBER', 'Personnummer');
define('KREDITOR_LANG_INFO_DK_PAYMENT', 'Betaling 14 dage');
define('KREDITOR_LANG_INFO_DK_ERRORCURRENCY',
    'Klarna acceptere kun betaling med danske kroner (DKK)');
define('KREDITOR_LANG_INFO_DK_CHOOSECONSUMERCREDIT', 'V�lg din kredit');
define('KREDITOR_LANG_INFO_DK_YEARLYINCOME', '&Aring;rlig inkomst');
define('KREDITOR_LANG_INFO_DK_ACCEPTCONDITION1_ACCEPT', 'Jeg accepterer ');
define('KREDITOR_LANG_INFO_DK_ACCEPTCONDITION2_LINK',
    'http://www.fakturermig.dk/kontovilkar.pdf');
define('KREDITOR_LANG_INFO_DK_ACCEPTCONDITION3_CONDITIONS', 'disse vilk&aring;r');
define('KREDITOR_LANG_INFO_DK_ERRORACCEPTCONDITION', 'Var god acceptere vilk&aring;rerne');
define('KREDITOR_LANG_INFO_DK_CHOOSEALTERNATIVES', 'V�lg en alternativ adresse nedenfor');
define('KREDITOR_LANG_INFO_DK_PAYMENTTEXT1_PAY', 'Betal ');
define('KREDITOR_LANG_INFO_DK_PAYMENTTEXT2_EACH', ' hver m&aring;ned ');
define('KREDITOR_LANG_INFO_DK_PAYMENTTEXT3_MONTH', ' m&aring;ned');
define('KREDITOR_LANG_INFO_DK_ERRORINVOICE', 'Fakturafejl');
define('KREDITOR_LANG_INFO_DK_ERRORDIVIDE', 'Konsument Kreditfejl');
define('KREDITOR_LANG_INFO_DK_ERRORPREPAY', 'Forskudsbetaling-fel');
define('KREDITOR_LANG_INFO_DK_FROM', 'fra');
define('KREDITOR_LANG_INFO_DK_PARTPAYMENT_FROM', 'delbetala fra');

// NORWEGIAN PREDEFINED VARIABLES
define('KREDITOR_LANG_INFO_NO_IMGINVOICE',
    '<img src="images/klarna_invoice_no_logo.png" />');
define('KREDITOR_LANG_INFO_NO_IMGCONSUMERCREDIT',
    '<img src="images/klarna_part_payment_no_logo.png" />');
	define('KREDITOR_LANG_INFO_NOR_KLARNA', 'Konto - %s/m&aring;n');
define('KREDITOR_LANG_INFO_NO_FIRSTNAME', 'Navn');
define('KREDITOR_LANG_INFO_NO_LASTNAME', 'Etternavn');
define('KREDITOR_LANG_INFO_NO_STREETADDRESS', 'Adresse');
define('KREDITOR_LANG_INFO_NO_POSTCODE', 'Postnummer');
define('KREDITOR_LANG_INFO_NO_CITY', 'Sted');
define('KREDITOR_LANG_INFO_NO_PHONENUMBER', 'Mobilnummer');
define('KREDITOR_LANG_INFO_NO_EMAIL', 'E-post');
define('KREDITOR_LANG_INFO_NO_CONDITIONS', 'Vilk&aring;r');
define('KREDITOR_LANG_INFO_NO_PERSONALNUMBER', 'Personnummer');
define('KREDITOR_LANG_INFO_NO_PAYMENT', 'Betaling 14 dager');
define('KREDITOR_LANG_INFO_NO_ERRORCURRENCY',
    'Klarna aksepterer kun betalinger i norske kroner (NOK)');
define('KREDITOR_LANG_INFO_NO_CHOOSECONSUMERCREDIT', 'Velg forbrukerkreditt');
define('KREDITOR_LANG_INFO_NO_YEARLYINCOME', '&Aring;rlig innkomst');
define('KREDITOR_LANG_INFO_NO_ACCEPTCONDITION1_ACCEPT', 'Jeg godtar');
define('KREDITOR_LANG_INFO_NO_ACCEPTCONDITION2_LINK',
    'http://www.fakturermig.dk/kontovilkar.pdf');
define('KREDITOR_LANG_INFO_NO_ACCEPTCONDITION3_CONDITIONS', 'disse vilk&aring;rene');
define('KREDITOR_LANG_INFO_NO_ERRORACCEPTCONDITION', 'Vennligst godta vilk&aring;rene');
define('KREDITOR_LANG_INFO_NO_CHOOSEALTERNATIVES', 'Velg alternativ adresse nedenfor');
define('KREDITOR_LANG_INFO_NO_PAYMENTTEXT1_PAY', 'Betal ');
define('KREDITOR_LANG_INFO_NO_PAYMENTTEXT2_EACH', ' hver m&aring;ned i ');
define('KREDITOR_LANG_INFO_NO_PAYMENTTEXT3_MONTH', ' m&aring;neder');
define('KREDITOR_LANG_INFO_NO_ERRORINVOICE', 'Fakturafeil');
define('KREDITOR_LANG_INFO_NO_ERRORDIVIDE', 'Forbrukerkreditt-error');
define('KREDITOR_LANG_INFO_NO_ERRORPREPAY', 'Forh&aring;ndsbetaling-fel');
define('KREDITOR_LANG_INFO_NO_FROM', 'fra');
define('KREDITOR_LANG_INFO_NO_PARTPAYMENT_FROM', 'delbetala fra');

// German PREDEFINED VARIABLES
define('KREDITOR_LANG_INFO_DE_IMGINVOICE',
    '<img src="images/klarna_invoice_de_logo.png" />');
define('KREDITOR_LANG_INFO_DE_IMGCONSUMERCREDIT',
    '<img src="images/klarna_partpayment_de_logo.png" />');
define('KREDITOR_LANG_INFO_DE_KLARNA', 'Konto - %s/Monat');
define('KREDITOR_LANG_INFO_DE_FIRSTNAME', 'Vorname');
define('KREDITOR_LANG_INFO_DE_LASTNAME', 'Nachname');
define('KREDITOR_LANG_INFO_DE_STREETADDRESS', 'Strasse / Nr');
define('KREDITOR_LANG_INFO_DE_POSTCODE', 'Postleitzahl');
define('KREDITOR_LANG_INFO_DE_CITY', 'Ort');
define('KREDITOR_LANG_INFO_DE_PHONENUMBER', 'Mobilnummer');
define('KREDITOR_LANG_INFO_DE_PHONENUMBER2', 'Telefonnummer Privat/Festnetz');
define('KREDITOR_LANG_INFO_DE_EMAIL', 'E-Mail');
define('KREDITOR_LANG_INFO_DE_CONDITIONS', 'AGB');
define('KREDITOR_LANG_INFO_DE_PERSONALNUMBER', 'Geburtsdatum (ttmmjjjj)');
define('KREDITOR_LANG_INFO_DE_PAYMENT', 'Zahlungsbedingungen 14 Tage');
define('KREDITOR_LANG_INFO_DE_ERRORCURRENCY',
    'Klarna akzeptiert nur Zahlungen in Euro (EUR)');
define('KREDITOR_LANG_INFO_DE_CHOOSECONSUMERCREDIT', 'Finanzierung w&auml;hlen');
define('KREDITOR_LANG_INFO_DE_YEARLYINCOME', 'Jahreseinkommen');
define('KREDITOR_LANG_INFO_DE_ACCEPTCONDITION1_ACCEPT', 'Ich akzeptiere ');
define('KREDITOR_LANG_INFO_DE_ACCEPTCONDITION2_LINK',
    'http://www.klarna.com/kontovillkor.pdf');
define('KREDITOR_LANG_INFO_DE_ACCEPTCONDITION3_CONDITIONS', 'AGB');
define('KREDITOR_LANG_INFO_DE_ERRORACCEPTCONDITION', 'Bitte akzeptieren Sie die AGB');
define('KREDITOR_LANG_INFO_DE_CHOOSEALTERNATIVES', 'W&auml;hlen Sie eine alternative Adresse weiter unten');
define('KREDITOR_LANG_INFO_DE_PAYMENTTEXT1_PAY', '');
define('KREDITOR_LANG_INFO_DE_PAYMENTTEXT2_EACH', '/Monat');
define('KREDITOR_LANG_INFO_DE_PAYMENTTEXT3_MONTH', ' Monat - ');
define('KREDITOR_LANG_INFO_DE_ERRORINVOICE', 'Klarna Rechnung - Fehler');
define('KREDITOR_LANG_INFO_DE_ERRORDIVIDE', 'Finanzierung - Fehler');
define('KREDITOR_LANG_INFO_DE_ERRORPREPAY', 'Vorkasse - Fehler');
define('KREDITOR_LANG_INFO_DE_FROM', 'von');
define('KREDITOR_LANG_INFO_DE_PARTPAYMENT_FROM', 'Finanzierung ab');
define('KREDITOR_LANG_INFO_DE_GENDER', 'Anrede');
define('KREDITOR_LANG_INFO_DE_DATE', 'Geben Sie bitte ihr Geburtsdatum an');
$eix = (defined('MODULE_PAYMENT_PCKREDITOR_DE_EID')) ? MODULE_PAYMENT_PCKREDITOR_DE_EID :'';
define('MODULE_PAYMENT_PCKREDITOR_INFO_KLARNA', "<script type=\"text/javascript\" src=\"https://integration.klarna.com/js/klarnapart.js\"></script>
                <script>
                    addKlarnaPartPaymentEvent(function() { InitKlarnaPartPaymentElements('klarna_partpayment'," . $eix . ",'de', " . 900 . "); });
                </script>
                    <a href=\"#\" id=\"klarna_partpayment\" onclick=\"ShowKlarnaPartPaymentPopup();return false;\"></a>");

// Dutch PREDEFINED VARIABLES
define('KREDITOR_LANG_INFO_NL_IMGINVOICE',
    '<img src="images/klarna_invoice_nl_logo.png" />');
define('KREDITOR_LANG_INFO_NL_IMGCONSUMERCREDIT',
    '<img src="images/klarna_part_payment_nl_logo.png" />');
define('KREDITOR_LANG_INFO_NL_KLARNA', 'Account - %s/Maand');
define('KREDITOR_LANG_INFO_NL_FIRSTNAME', 'Voornaam');
define('KREDITOR_LANG_INFO_NL_LASTNAME', 'Achternaam');
define('KREDITOR_LANG_INFO_NL_STREETADDRESS', 'Adres');
define('KREDITOR_LANG_INFO_NL_POSTCODE', 'Postnummer');
define('KREDITOR_LANG_INFO_NL_CITY', 'Plaats');
define('KREDITOR_LANG_INFO_NL_PHONENUMBER', 'Mobiel nummer');
define('KREDITOR_LANG_INFO_NL_PHONENUMBER2', 'Telefoonnummer (vaste lijn)');
define('KREDITOR_LANG_INFO_NL_EMAIL', 'E-mailadres');
define('KREDITOR_LANG_INFO_NL_CONDITIONS', 'Algemene Voorwaarden');
define('KREDITOR_LANG_INFO_NL_PERSONALNUMBER', 'Geboortedatum');
define('KREDITOR_LANG_INFO_NL_PAYMENT', 'Betalingsvoorwaarden 14 dagen');
define('KREDITOR_LANG_INFO_NL_ERRORCURRENCY',
    'Klarna accepteert enkel betaling in Euro (EUR)');
define('KREDITOR_LANG_INFO_NL_CHOOSECONSUMERCREDIT', 'Deelbetaling kiezen');
define('KREDITOR_LANG_INFO_NL_YEARLYINCOME', 'Jaarinkomen');
define('KREDITOR_LANG_INFO_NL_ACCEPTCONDITION1_ACCEPT', 'Ik accepteer');
define('KREDITOR_LANG_INFO_NL_ACCEPTCONDITION2_LINK', 'http://www.klarna.com/kontovillkor.pdf');
define('KREDITOR_LANG_INFO_NL_ACCEPTCONDITION3_CONDITIONS', 'Algemene Voorwaarden');
define('KREDITOR_LANG_INFO_NL_ERRORACCEPTCONDITION', 'Gelieve de Algemene Voorwaarden te accepteren');
define('KREDITOR_LANG_INFO_NL_CHOOSEALTERNATIVES', 'Selecteer hieronder alternatief adres');
define('KREDITOR_LANG_INFO_NL_PAYMENTTEXT1_PAY', '');
define('KREDITOR_LANG_INFO_NL_PAYMENTTEXT2_EACH', '/maand');
define('KREDITOR_LANG_INFO_NL_PAYMENTTEXT3_MONTH', ' Maand -  ');
define('KREDITOR_LANG_INFO_NL_ERRORINVOICE', 'Klarna Factuur - fout');
define('KREDITOR_LANG_INFO_NL_ERRORDIVIDE', 'Klarna Account - fout');
define('KREDITOR_LANG_INFO_NL_ERRORPREPAY', 'Acceptgiro - fout');
define('KREDITOR_LANG_INFO_NL_FROM', 'van');
define('KREDITOR_LANG_INFO_NL_PARTPAYMENT_FROM', 'Deelbetalen vanaf');
define('KREDITOR_LANG_INFO_NL_HOUSEEXT', 'Toevoeging');
define('KREDITOR_LANG_INFO_NL_GENDER', 'Geslacht');

// ============================                 

/*
// RETURN ERROR IN SWEDISH
function strerror_se($reason)
{
    $url = 'http://www.klarna.com/';

    switch ($reason)
    {
        case "unknown_estore":
        case "invalid_estore_secret":
            return "Det har uppst&aring;tt ett integrationsfel mellan butiken och Klarna (felkod: $reason). Kontakta Webbutiken f&ouml;r mer information eller v&auml;lj ett annat s&auml;tt att betala.";
        case "estore_blacklisted":
        case "customer_blacklisted":
            return "Ett problem har uppst&aring;tt i kommunikationen med Klarna, som sk&ouml;ter v&aring;r fakturering. V&auml;nligen kontakta Klarna ($url) f&ouml;r mer information eller v&auml;lj ett annat s&auml;tt att betala.";
        case "bad_customer_password":
            return "Du har angivit ett felaktigt l&ouml;senord.";
        case "dead":
        case "no_such_person":
        case "pno":
        case "invalid_pno":
            return "Du har angivit ett felaktigt personnummer, var v&auml;nlig och kontrollera om du har r&aring;kat skriva fel.";
        case "under_aged":
        case "customer_not_18":
            return "Tyv&auml;rr m&aring;ste man vara 18 &aring;r f&ouml;r att kunna f&aring; handla genom Klarna.";
        case "customer_not_accepted":
            return "Klarna, som sk&ouml;ter v&aring;r fakturering, har inte registrerat inbetalningar p&aring; alla dina f&ouml;rfallna fakturor. V&auml;nligen kontakta Klarnas kundtj&auml;nst ($url) f&ouml;r att tillsammans hitta en l&ouml;sning eller v&auml;lj ett annat s&auml;tt att betala.";
        case "estore_overrun":
        case "customer_credit_overrun":
            return "Tyv&auml;rr kan inte Klarna, som sk&ouml;ter v&aring;r fakturering, godk&auml;nna ditt k&ouml;p d&aring; du har &ouml;verskridit din kreditgr&auml;ns. V&auml;nligen kontakta Klarnas kundtj&auml;nst ($url) f&ouml;r att tillsammans hitta en l&ouml;sning eller v&auml;lj ett annat s&auml;tt att betala.";
        case "blocked":
        case "unpaid_bills":
            return "Tyv&auml;rr kan inte inte Klarna, som sk&ouml;ter v&aring;r fakturering, godk&auml;nna k&ouml;pet efter kreditkontroll. V&auml;nligen kontakta Klarnas kundtj&auml;nst ($url) f&ouml;r att tillsammans hitta en l&ouml;sning eller v&auml;lj ett annat s&auml;tt att betala.";
        case "bad_name":
            return "Du har angivit ett namn som inte st&auml;mmer &ouml;verens med ditt personnummer. Var v&auml;nlig och kontrollera om du har r&aring;kat skriva fel eller v&auml;lj ett annat s&auml;tt att betala.";
        case "foreign_addr":
        case "bad_addr":
            return "Du har angivit en adress som inte st&auml;mmer &ouml;verens med ditt personnummer. Var v&auml;nlig och kontrollera om du har r&aring;kat skriva fel eller v&auml;lj ett annat s&auml;tt att betala.";
        case "cellno":
            return "Du har angivit ett felaktigt mobilnummer. Var v&auml;nlig och kontrollera om du har r&aring;kat skriva fel eller v&auml;lj ett annat s&auml;tt att betala.";
	  case "postno":
        case "bad_postno":
            return "Du har angivit ett felaktigt postnummer. Var v&auml;nlig och kontrollera om du har r&aring;kat skriva fel eller v&auml;lj ett annat s&auml;tt att betala.";
        case "no_such_subscription":
            return "This error means that an operation such as freeze refered to a customer subscription that doesn�t exist";
        case "not_unique_subscription_no":
            return "The estore must provide estore order numbers that are unique for that estore, if they don�t this error is returned from the XML-RPC operations";;
        case "terminated":
            return "It�s not possible to i.e freeze a terminated subscription";
        case "already_set":
            return "It�s not possible to i.e freeze a frozen subscription";
        case "need_email_addr":
            return "This error may be returned when the subscription is created and (a) the subscription type requires auth by email and (b) the XML-RPC from the estore that tries to create the subscription doesn't have a valid email addr in the email field";
        default:
            return "Ett problem har uppst&aring;tt i kommunikationen med Klarna, som sk&ouml;ter v&aring;r fakturering. V&auml;nligen kontakta Klarna ($url) f&ouml;r mer information eller v&auml;lj ett annat s&auml;tt att betala. (Felkod: $reason)";
    }
}

// RETURN ERROR IN FINNISH
function strerror_fi($reason)
{
    $url = 'http://www.klarna.fi/';

    switch ($reason)
    {
        case "unknown_estore":
        case "invalid_estore_secret":
            return "On syntynyt integrointivirhe kaupan ja Klarnan v&auml;lill&auml; (virhekoodi: $reason). Ota yhteytt&auml; verkkokauppaan tai valitse toinen maksutapa.";
        case "estore_blacklisted":
        case "customer_blacklisted":
            return "Jotain on tapahtunut kommunikaatiossa laskupalvelun hoitajan, Klarnan, kanssa. Ole yst&auml;v&auml;llinen ja ota yhteytt&auml; Klarnaan ($url) tai valitse toinen maksutapa.";
        case "bad_customer_password":
            return "Olet sy&ouml;tt&auml;nyt v&auml;&auml;r&auml;n salasanan.";
        case "dead":
        case "no_such_person":
        case "pno":
        case "invalid_pno":
            return "Olet sy&ouml;tt&auml;ny v&auml;&auml;r&auml;n henkil&ouml;tunnuksen. Ole hyv&auml; ja tarkista tunnuksesi.";
        case "under_aged":
        case "customer_not_18":
            return "Sinun t&auml;ytyy valitettavasti olla 18 vuotta, jotta voit ostaa Klarnan laskupalvelulla.";
        case "customer_not_accepted":
            return "Laskupalvelun hoitaja, Klarna, ei ole vastaanottanut kaikkia er&auml;&auml;ntyneit&auml; laskujasi. Ole yst&auml;v&auml;llinen ja ota yhteytt&auml; Klarnan asiakaspalveluun ($url) tai valitse toinen maksutapa.";
        case "estore_overrun":
        case "customer_credit_overrun":
            return "Klarna, joka hoitaa laskupalvelua, ei voi valitettavasti hyv&auml;ksy&auml; ostostasi, koska olet ylitt&auml;nyt luottorajasi. Ole yst&auml;v&auml;llinen ja ota yhteytt&auml; Klarnan asiakaspalveluun ($url) tai valitse toinen maksutapa.";
        case "blocked":
        case "unpaid_bills":
            return "Klarna, joka hoitaa laskupalvelua, ei voi valitettavasti hyv&auml;ksy&auml; ostostasi luottotarkistuksen j&auml;lkeen. Ole yst&auml;v&auml;llinen ja ota yhteytt&auml; Klarnan asiakaspalveluun ($url) tai valitse toinen maksutapa.";
        case "bad_name":
            return "Olet ilmoittanut nimen, joka ei t&auml;sm&auml;&auml; henkil&ouml;tunnukseesi. Ole yst&auml;v&auml;llinen ja tarkista jos olet kirjoittanut sen v&auml;&auml;rin tai valitse toinen maksutapa.";
        case "foreign_addr":
        case "bad_addr":
            return "Olet ilmoittanut osoitteen, joka ei t&auml;sm&auml;&auml; henkil&ouml;tunnukseesi. Ole yst&auml;v&auml;llinen ja tarkista, jos olet kirjoittanut sen v&auml;&auml;rin tai valitse toinen maksutapa.";
        case "postno":
 	  case "cellno":
            return "Olet ilmoittanut v&auml;&auml;r&auml;nlaisen matkapuhelinnumeron. Ole yst&auml;v&auml;llinen ja tarkista, jos olet kirjoittanut sen v&auml;&auml;rin tai valitse toinen maksutapa.";
        case "bad_postno":
            return "Olet ilmoittanut v&auml;&auml;r&auml;n postinumeron. Ole yst&auml;v&auml;llinen ja tarkista, jos olet sen kirjoittanut v&auml;&auml;rin tai valitse toinen maksutapa.";
        case "no_such_subscription":
            return "This error means that an operation such as freeze refered to a customer subscription that doesn�t exist";
        case "not_unique_subscription_no":
            return "The estore must provide estore order numbers that are unique for that estore, if they don�t this error is returned from the XML-RPC operations";;
        case "terminated":
            return "It�s not possible to i.e freeze a terminated subscription";
        case "already_set":
            return "It�s not possible to i.e freeze a frozen subscription";
        case "need_email_addr":
            return "This error may be returned when the subscription is created and (a) the subscription type requires auth by email and (b) the XML-RPC from the estore that tries to create the subscription doesn't have a valid email addr in the email field";
        default:
            return "Jotain on tapahtunut kommunikaatiossa laskupalvelun hoitajan, Klarnan, kanssa. Ole yst&auml;v&auml;llinen ja ota yhteytt&auml; Klarnaan ($url) tai valitse toinen maksutapa. (Virhekoodi: $reason)";
    }
}

// RETURN ERROR IN DANISH
function strerror_dk($reason)
{
    $url = 'http://www.klarna.dk/';

    switch ($reason)
    {
        case "unknown_estore":
        case "invalid_estore_secret":
            return "Et problem har opst&aring;et (fejlkod: $reason), v�r venlig at kontakte butikken for mere information
eller v�lg en anden betalingsmetode.";
        case "estore_blacklisted":
        case "customer_blacklisted":                  
            return "Et problem har opst&aring;et med kommunikationen til Klarna ($url) som h&aring;ndterer vores
fakturering. Var venlig at kontakte Klarna for mere information eller v�lg
en anden betalingsmetode.";
        case "bad_customer_password":
            return "Fejl i login, forkert password.";
        case "dead":
        case "no_such_person":
        case "pno":
        case "invalid_pno":
            return "Fejl i login, forkert personnummer. V�r venlig at kontrollere at du indtastet det korrekte personnummer.";
        case "under_aged":
        case "customer_not_18":
            return "For at handle gennem kreditor skal du v�re fyldt 18 &aring;r.";
        case "customer_not_accepted":
            return "Klarna som ansvarer for vores fakturaer har ikke registreret nogen betalinger p&aring; dine forl�bne fakturaer. V�r venlig at kontakte Klarna ($url) for mere information eller v�lg en anden betalingsmetode.";
        case "estore_overrun":
        case "customer_credit_overrun":
            return "Klarna som ansvarer for vores fakturaer beklager meget at m&aring;tte meddele dem at din betaling ikke kan accepteres p&aring; grund af at den overskrider din kreditgr�nse. V�r venlig at kontakte Klarna ($url) s&aring; at vi kan finde en l�sning eller v�lg en anden betalingsmetode.";
        case "blocked":
        case "unpaid_bills":
            return "Klarna som ansvarer for vores fakturaer beklager meget at m&aring;tte meddele dem at din betaling ikke kan accepteres p&aring; grund af at du ikke er godkendt af vores kreditoplysning. V�r venlig at kontakte Klarna ($url) s&aring; at vi kan finde en l�sning eller v�lg en anden betalingsmetode.";
        case "bad_name":
            return "Navnet du har intastet stemmer ikke overens med dit personnummer. V�r venlig at kontrollere at du har intastet det korrekte navn og pr�v igen.";
        case "foreign_addr":
        case "bad_addr":
            return "Den adresse som du har intastet stemmer ikke overnes med dit personnummer. V�r venlig at kontrollere at du har intastet den korrekte adresse og pr�v igen.";
        case "postno":
        case "bad_postno":
            return "Du har intastet en postnummer som ikke existerer. Venlig at kontrollere at du har intastet det korrekte postnummer og pr�v igen.";
        case "no_such_subscription":
            return "This error means that an operation such as freeze refered to a customer subscription that doesn�t exist";
        case "not_unique_subscription_no":
            return "The estore must provide estore order numbers that are unique for that estore, if they don�t this error is returned from the XML-RPC operations";;
        case "terminated":
            return "It�s not possible to i.e freeze a terminated subscription";
        case "already_set":
            return "It�s not possible to i.e freeze a frozen subscription";
        case "need_email_addr":
            return "This error may be returned when the subscription is created and (a) the subscription type requires auth by email and (b) the XML-RPC from the estore that tries to create the subscription doesn't have a valid email addr in the email field";
        default:
            return "A problem has risen in the communication with Klarna, that handles our invoicing. Please contact Klarna ($url) for more information or choose an alternative payment method. (errorcode: $reason)";
	}
}

// RETURN ERROR IN NORWEGIAN
function strerror_no($reason)
{
    $url = 'http://www.klarna.no/';
    
    switch ($reason)
    {
        case "unknown_estore":
        case "invalid_estore_secret":
            return "Det oppstod en feil mellom butikken og Klarna (feilkode: $reason). Vennligst kontakt butikken for mer informasjon eller velg en annen betalingsmetode.";
        case "estore_blacklisted":
        case "customer_blacklisted":                  
            return "Det har oppst&aring;tt et problem i kommunikasjonen med Klarna som h&aring;ndterer faktureringen. Vennligst kontakt Klarna ($url) for mer informasjon eller velg en annen betalingsmetode.";
        case "bad_customer_password":
            return "Du har oppgitt feil passord.";
        case "dead":
        case "no_such_person":
        case "pno":
        case "invalid_pno":
            return "Du har oppgitt feil personnummer. Vennligst kontroller og fors�k igjen.";
        case "under_aged":
        case "customer_not_18":
            return "Beklager, men du m&aring; v�re minst 18 &aring;r for &aring; handle via Klarna.";
        case "customer_not_accepted":
            return "Klarna, som h&aring;ndterer v&aring;re fakturaer, har ikke registrert noen innbetalinger p&aring; forfalte fakturaer. Vennligst kontakt Klarna ($url) for &aring; l�se problemet eller velg en annen betalingsmetode.";
        case "estore_overrun":
        case "customer_credit_overrun":
            return "Beklager, men Klarna som h&aring;ndterer v&aring;re fakturaer, kan ikke akseptere betalingsmetoden ettersom kj�pesummen overstiger din kredittgrense. Vennligst kontakt Klarna ($url) for mer informasjon eller velg en annen betalingsmetode.";
        case "blocked":
        case "unpaid_bills":
            return "Beklager, men Klarna som h&aring;ndterer v&aring;re fakturaer, kan ikke akseptere betalingsmetoden etter en kredittsjekk. Vennligst kontakt Klarna ($url) for mer informasjon eller velg en annen betalingsmetode.";
        case "bad_name":
            return "Du har oppgitt et navn som ikke stemmer overens med det oppgitte personnummeret. Vennligst kontroller og fors�k igjen.";
        case "foreign_addr":
        case "bad_addr":
            return "Du har oppgitt en adresse som ikke stemmer overens med det oppgitte personnummeret. Vennligst kontroller og fors�k igjen.";
        case "postno":
        case "bad_postno":
            return "Du har oppgitt et postnummer som ikke eksisterer. Vennligst kontroller og fors�k igjen.";
        case "no_such_subscription":
            return "This error means that an operation such as freeze refered to a customer subscription that doesn�t exist";
        case "not_unique_subscription_no":
            return "The estore must provide estore order numbers that are unique for that estore, if they don�t this error is returned from the XML-RPC operations";;
        case "terminated":
            return "It�s not possible to i.e freeze a terminated subscription";
        case "already_set":
            return "It�s not possible to i.e freeze a frozen subscription";
        case "need_email_addr":
            return "This error may be returned when the subscription is created and (a) the subscription type requires auth by email and (b) the XML-RPC from the estore that tries to create the subscription doesn't have a valid email addr in the email field";
        default:
            return "A problem has risen in the communication with Klarna, that handles our invoicing. Please contact Klarna ($url) for more information or choose an alternative payment method. (errorcode: $reason)";
    }
	
}
*/
?>
