<?php
/* -----------------------------------------------------------------------------------------
   $Id: login.php,v 1.16 2016/06/10 09:21:33 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(login.php,v 1.79 2003/05/19); www.oscommerce.com 
   (c) 2003      nextcommerce (login.php,v 1.13 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   guest account idea by Ingo T. <xIngox@web.de>
   ---------------------------------------------------------------------------------------*/

  include( 'includes/application_top.php');
  if(!defined('NO_FLOODBLOCKER_CHECK') or NO_FLOODBLOCKER_CHECK != 'True'){
	include( DIR_WS_CLASSES.'class.floodblocker.php');
	$flb = new FloodBlocker ( 'cache/' );

	  // Create as many rules as you want...

	  $flb->rules = array (
		40=>10,    // rule 1 - maximum 10 requests in 10 secs
		90=>30,    // rule 2 - maximum 30 requests in 60 secs
		600=>50,   // rule 3 - maximum 50 requests in 300 secs
		3600=>200  // rule 4 - maximum 200 requests in 3600 secs
	  );
  }
  // At last call CheckFlood(), it will return FALSE if flood detected on any
  // of specified rules.
  
// create smarty elements
$smarty = new yesSmarty;

if(!defined('NO_FLOODBLOCKER_CHECK') or NO_FLOODBLOCKER_CHECK != 'True'){
        if ( ! $flb->CheckFlood ( ) ){
              $message = '<div style="width:50%;font-family:arial,helvetica,sans-serif;font-size:14px;color:#FF0000;padding:8px;border:2px solid #000000;background-color:#CACACA;text-align:center;">'.FLOOD_WARNING_MESSAGE.'<p><i>'.STORE_NAME.'</i></p></div>';
              die($message);
        }
}

$YesBoxes->load( $smarty, basename(__FILE__) );
   
// include needed functions
require_once(DIR_FS_INC . 'xtc_draw_password_field.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_password.inc.php');
require_once(DIR_FS_INC . 'xtc_array_to_string.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
// redirect the customer to a friendly cookie-must-be-enabled page if cookies are disabled (or the session has not started)
if ($session_started == false) {
    xtc_redirect(xtc_href_link(FILENAME_COOKIE_USAGE));
}
if (isset($_GET['action']) && ($_GET['action'] == 'process')) {

    $email_address = $_POST['email_address']??'';
    $password = $_POST['password']??'';
    if(empty($email_address) or empty($password)){
        xtc_redirect(FILENAME_LOGIN);
    }
    $cust_obj = \YES4Trade\Model\customers::get_by_email_address($email_address);
    if ($cust_obj === null) {
	$_GET['login'] = 'fail';
	$info_message=TEXT_NO_EMAIL_ADDRESS_FOUND;
    } else {
        $check_customer = $cust_obj->toArray();
        if (!xtc_validate_password($password, $check_customer['customers_password'])) {
            $_GET['login'] = 'fail';
            $info_message=TEXT_LOGIN_ERROR;
        } else {
            if (SESSION_RECREATE == 'True') {
                xtc_session_recreate();
            }
            unset($_SESSION['failed_login_counter']);
            $item = \YES4Trade\Model\address_book::get_by_customers_id_and_address_book_id((int)$check_customer['customers_id'], (int)$check_customer['customers_default_address_id']);
            $_SESSION['customer_gender'] = $check_customer['customers_gender'];
            $_SESSION['customer_first_name'] = $check_customer['customers_firstname'];
            $_SESSION['customer_last_name'] = $check_customer['customers_lastname'];
            $_SESSION['customer_id'] = $check_customer['customers_id'];
            $_SESSION['customer_vat_id'] = $check_customer['customers_vat_id'];
            $_SESSION['customer_default_address_id'] = $check_customer['customers_default_address_id'];
            $_SESSION['customer_country_id'] = $item->entry_country_id;
            $_SESSION['customer_zone_id'] = $item->entry_zone_id;
            $_SESSION['use_own_mailaddress'] = $check_customer['use_own_mailaddress'];
            $_SESSION['theme'] = (!empty($check_customer['theme']))?$check_customer['theme']:'start';
            $date_now = date('Ymd');
            \YES4Trade\Model\customers_info::update_number_of_logins((int)$_SESSION['customer_id']);
            xtc_write_user_info((int)$_SESSION['customer_id']);
            // restore cart contents
            $_SESSION['cart']->restore_contents();

            if ($_SESSION['cart']->count_contents() > 0){
                xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING));
            }
            xtc_redirect(xtc_href_link(FILENAME_DEFAULT));
        }
    }
}


$breadcrumb->add(NAVBAR_TITLE_LOGIN, xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
require(DIR_WS_INCLUDES . 'header.php'); 

if (isset($_GET['info_message'])) {
    $info_message=$_GET['info_message'];
}
if(!isset($info_message)){
    $info_message = '';
}

$smarty->assign('info_message',$info_message);
$smarty->assign('account_option',ACCOUNT_OPTIONS);
$smarty->assign('BUTTON_NEW_ACCOUNT','<a href="' . xtc_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL') . '">' . xtc_image_button('button_continue.gif', IMAGE_BUTTON_CONTINUE) . '</a>');
$smarty->assign('BUTTON_LOGIN',xtc_image_submit('button_login.gif', IMAGE_BUTTON_LOGIN));
$smarty->assign('BUTTON_GUEST','<a href="' . xtc_href_link(FILENAME_CREATE_GUEST_ACCOUNT, '', 'SSL') . '">' . xtc_image_button('button_continue.gif', IMAGE_BUTTON_CONTINUE) . '</a>');
$smarty->assign('FORM_ACTION',xtc_href_link(FILENAME_LOGIN, 'action=process', 'SSL'));
$smarty->assign('FORM',xtc_draw_form('login',xtc_href_link(FILENAME_LOGIN, 'action=process', 'SSL')));
$smarty->assign('FORM_END','</form>');

$smarty->assign('INPUT_MAIL',xtc_draw_input_field('email_address'));
$smarty->assign('INPUT_PASSWORD',xtc_draw_password_field('password'));
$smarty->assign('LINK_LOST_PASSWORD',xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, '', 'SSL'));
if (isset($_GET['info_message'])){
    $smarty->assign('INPUT_REFERRER',xtc_draw_hidden_field('ref',xtc_db_input($_REQUEST['ref'])));
}else{
    if(strstr($_SERVER['HTTP_REFERER'],'shopping_cart.php')){
        $smarty->assign('INPUT_REFERRER',xtc_draw_hidden_field('ref',xtc_db_input($_SERVER['HTTP_REFERER'])));
    }
}
$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/login.html');
$smarty->assign('main_content',$main_content);

$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
